/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IPseudoElement;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.components.ContextManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class JavaElementPropertyAccessor {
    public static Logger LOGGER = Logger.getLogger(JavaElementPropertyAccessor.class.getName());
    protected Component component;
    private static final Pattern arrayPattern = Pattern.compile("(.*)\\[([^\\]]*)\\]$");
    public static final List<String> LAST_RESORT_RECOGNITION_PROPERTIES = new ArrayList<String>();

    public JavaElementPropertyAccessor(Component component) {
        this.component = component;
    }

    public String getAttribute(String name) {
        return this.getAttribute(name, false);
    }

    public String getAttribute(final String name, final boolean skipSelf) {
        return EventQueueWait.exec(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return JavaElementPropertyAccessor.this._getAttribute(name, skipSelf);
            }
        });
    }

    public String _getAttribute(String name, boolean skipSelf) {
        if (name.startsWith("keystrokeFor-")) {
            return this.getKeyStrokeFor(name.substring("keystrokeFor-".length()));
        }
        String[] split = name.split("\\.");
        String first = split[0];
        Object attributeObject = null;
        try {
            if (!skipSelf) {
                attributeObject = this.getAttributeObject(this, first);
            }
        }
        catch (UnsupportedCommandException unsupportedCommandException) {
            // empty catch block
        }
        if (attributeObject == null) {
            Component c = this.component;
            if (this instanceof IPseudoElement) {
                c = ((IPseudoElement)((Object)this)).getPseudoComponent();
            }
            if ((attributeObject = this.getAttributeObject(c, first)) == null) {
                return null;
            }
        }
        for (int i = 1; i < split.length; ++i) {
            if ((attributeObject = this.getAttributeObject(attributeObject, split[i])) != null) continue;
            return null;
        }
        return this.toString(attributeObject);
    }

    private String getKeyStrokeFor(String action) {
        JSONArray r = new JSONArray();
        if (this.component instanceof JComponent) {
            KeyStroke[] allKeys;
            InputMap inputMap = ((JComponent)this.component).getInputMap();
            for (KeyStroke ks : allKeys = inputMap.allKeys()) {
                if (!action.equals(inputMap.get(ks))) continue;
                r.put(ks.toString());
            }
        }
        if (r.length() > 0) {
            return r.toString();
        }
        return null;
    }

    private String toString(Object attributeObject) {
        return JavaElementPropertyAccessor.removeClassName(attributeObject);
    }

    public Object getAttributeObject(Object srcobj, String name) {
        Object[] oa;
        ArrayList<Object> lo;
        Cloneable o;
        block26: {
            o = null;
            Matcher matcher = arrayPattern.matcher(name);
            if (matcher.matches()) {
                try {
                    o = this.getAttributeObject(srcobj, this.getGetMethod(matcher.group(1)));
                    if (o != null) {
                        if (o instanceof Map) {
                            o = ((Map)((Object)o)).get(matcher.group(2));
                            LOGGER.info("Accessing map with " + matcher.group(2) + " = " + o);
                        } else {
                            o = EventQueueWait.call(o, "get", Integer.parseInt(matcher.group(2)));
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    LOGGER.info("Method get not found for " + o.getClass());
                }
            }
            try {
                if (o == null) {
                    String isMethod = this.getIsMethod(name);
                    o = EventQueueWait.call(srcobj, isMethod, new Object[0]);
                }
            }
            catch (Throwable e) {
                if (e instanceof NoSuchMethodException) break block26;
                return null;
            }
        }
        try {
            if (o == null) {
                String getMethod = this.getGetMethod(name);
                o = EventQueueWait.call(srcobj, getMethod, new Object[0]);
            }
        }
        catch (Throwable getMethod) {
            // empty catch block
        }
        try {
            if (o == null) {
                o = EventQueueWait.call(srcobj, name, new Object[0]);
            }
        }
        catch (Throwable getMethod) {
            // empty catch block
        }
        try {
            if (o == null) {
                o = this.getFieldValue(srcobj, name);
            }
        }
        catch (Throwable getMethod) {
            // empty catch block
        }
        if (o != null && o.getClass().isArray() && !o.getClass().getComponentType().isPrimitive()) {
            lo = new ArrayList();
            oa = (Object[])o;
            for (Object object : oa) {
                lo.add(object);
            }
            o = lo;
        }
        if (o != null && o instanceof Map) {
            HashMap lm = new HashMap();
            Map om = (Map)((Object)o);
            Set keySet = om.keySet();
            for (Object object : keySet) {
                lm.put(object.toString(), om.get(object));
            }
            o = lm;
        }
        if (o != null && o instanceof Collection) {
            lo = new ArrayList<Object>();
            oa = (Object[])o;
            for (Object e : oa) {
                lo.add(e);
            }
            o = lo;
        }
        if (o == null && srcobj instanceof Collection) {
            lo = new ArrayList();
            Collection c = (Collection)srcobj;
            for (Object e : c) {
                lo.add(this.getAttributeObject(e, name));
            }
            return lo;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFieldValue(Object component, String name) {
        AccessibleObject f = null;
        Class<?> klass = component.getClass();
        while (f == null && klass != null) {
            try {
                f = klass.getDeclaredField(name);
            }
            catch (SecurityException e) {
                return null;
            }
            catch (NoSuchFieldException e) {
                klass = klass.getSuperclass();
            }
        }
        if (f == null) {
            return null;
        }
        boolean accessible = f.isAccessible();
        try {
            ((Field)f).setAccessible(true);
            Object object = ((Field)f).get(component);
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        finally {
            ((Field)f).setAccessible(accessible);
        }
        return null;
    }

    private String getIsMethod(String name) {
        return "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String getGetMethod(String name) {
        return "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public boolean hasAttribue(String name) {
        return this.hasMethod(this.getIsMethod(name)) || this.hasMethod(this.getGetMethod(name));
    }

    private boolean hasMethod(String name) {
        try {
            this.component.getClass().getMethod(name, new Class[0]);
            return true;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public String getText() {
        return EventQueueWait.exec(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return JavaElementPropertyAccessor.this._getText();
            }
        });
    }

    public String _getText() {
        Object attributeObject;
        Component c = this.component;
        if (this instanceof IPseudoElement) {
            c = ((IPseudoElement)((Object)this)).getPseudoComponent();
        }
        if ((attributeObject = this.getAttributeObject(c, c instanceof JToggleButton ? "selected" : "text")) == null) {
            return null;
        }
        return attributeObject.toString();
    }

    public final boolean isDisplayed() {
        return (Boolean)EventQueueWait.call_noexc(this, "_isDisplayed", new Object[0]);
    }

    public boolean _isDisplayed() {
        try {
            this.component.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            return false;
        }
        catch (Throwable e) {
            throw new UnsupportedCommandException("getLocationOnScreen is not supported by " + this.component.getClass().getName(), e);
        }
        return true;
    }

    public Point getLocation() {
        return (Point)EventQueueWait.call_noexc(this, "_getLocation", new Object[0]);
    }

    public Point _getLocation() {
        Point p = this.component.getLocation();
        return new Point(p.x, p.y);
    }

    public Dimension getSize() {
        return (Dimension)EventQueueWait.call_noexc(this, "_getSize", new Object[0]);
    }

    public Dimension _getSize() {
        Dimension d = this.component.getSize();
        return new Dimension(d.width, d.height);
    }

    public boolean isSelected() {
        return (Boolean)EventQueueWait.call_noexc(this, "_isSelected", new Object[0]);
    }

    public boolean _isSelected() {
        String selected = this._getAttribute("selected", true);
        if (selected != null) {
            return Boolean.parseBoolean(selected);
        }
        throw new UnsupportedCommandException("isSelected is not supported by " + this.component.getClass().getName(), null);
    }

    public final boolean isEnabled() {
        return (Boolean)EventQueueWait.call_noexc(this, "_isEnabled", new Object[0]);
    }

    public boolean _isEnabled() {
        return this.component.isEnabled();
    }

    public Component getComponent() {
        return this.component;
    }

    public String getTagName() {
        Class<?> c = this.component.getClass();
        if (this instanceof IPseudoElement) {
            c = ((IPseudoElement)((Object)this)).getPseudoComponent().getClass();
        }
        return this.getTagName(c);
    }

    private String getTagName(Class<?> klass) {
        Class<?> javaClass;
        Class<?> c = javaClass = this.findJavaClass(klass);
        String simpleName = c.getSimpleName();
        while ("".equals(simpleName)) {
            c = c.getSuperclass();
            simpleName = c.getSimpleName();
        }
        return this.hyphenated(c);
    }

    private String hyphenated(Class<?> klass) {
        String r = klass.getSimpleName();
        if ((klass.getPackage().getName().equals("javax.swing") || klass.getPackage().getName().startsWith("javax.swing.")) && r.charAt(0) == 'J') {
            r = r.substring(1);
        }
        return r.substring(0, 1).toLowerCase() + r.substring(1).replaceAll("[A-Z][A-Z]*", "-$0").toLowerCase();
    }

    private Class<?> findJavaClass(Class<?> c) {
        while (c.getPackage() == null || !c.getPackage().getName().startsWith("java.awt") && !c.getPackage().getName().startsWith("javax.swing")) {
            c = c.getSuperclass();
        }
        return c;
    }

    public String getType() {
        String name = this.component.getClass().getName();
        if (name.startsWith("javax.swing")) {
            return name.substring("javax.swing.".length());
        }
        return name;
    }

    public String getLabelText() {
        String text;
        if (this.component instanceof JLabel && (text = ((JLabel)this.component).getText()) != null && !text.equals("")) {
            return "lbl:" + this.stripLastColon(text);
        }
        return null;
    }

    public String getInstanceOf() {
        Class<?> klass;
        for (klass = this.component.getClass(); klass != null && klass.getPackage() != null && !klass.getPackage().getName().startsWith("javax.swing") && !klass.getPackage().getName().startsWith("java.awt"); klass = klass.getSuperclass()) {
        }
        return klass == null ? null : klass.getName();
    }

    public Point getPosition() {
        return this.component.getLocationOnScreen();
    }

    public String getPrecedingLabel() {
        Container container = this.component.getParent();
        if (container == null) {
            return null;
        }
        List<Component> allComponents = this.findAllComponents();
        Point locComponent = this.component.getLocationOnScreen();
        ArrayList<Component> rowLeft = new ArrayList<Component>();
        for (Component label : allComponents) {
            Point locLabel = label.getLocationOnScreen();
            if (label instanceof JPanel || !(locLabel.getX() < locComponent.getX()) || !(locLabel.getY() >= locComponent.getY()) || !(locLabel.getY() <= locComponent.getY() + (double)this.component.getHeight()) || label instanceof Box.Filler) continue;
            rowLeft.add(label);
        }
        Collections.sort(rowLeft, new Comparator<Component>(){

            @Override
            public int compare(Component o1, Component o2) {
                Point locO1 = o1.getLocationOnScreen();
                Point locO2 = o2.getLocationOnScreen();
                return (int)(locO1.getX() - locO2.getX());
            }
        });
        if (rowLeft.size() > 0 && rowLeft.get(rowLeft.size() - 1) instanceof JLabel) {
            return this.stripLastColon(((JLabel)rowLeft.get(rowLeft.size() - 1)).getText().trim());
        }
        return null;
    }

    private List<Component> findAllComponents() {
        Component top = this.getTopWindow(this.component);
        ArrayList<Component> allComponents = new ArrayList<Component>();
        if (top != null) {
            this.fillUp(allComponents, top);
        }
        return allComponents;
    }

    private void fillUp(List<Component> allComponents, Component c) {
        if (!c.isVisible() || !c.isShowing()) {
            return;
        }
        allComponents.add(c);
        if (c instanceof Container) {
            Component[] components;
            for (Component component : components = ((Container)c).getComponents()) {
                this.fillUp(allComponents, component);
            }
        }
        if (c instanceof Window) {
            Window[] ownedWindows = ((Window)c).getOwnedWindows();
            for (Component component : ownedWindows) {
                this.fillUp(allComponents, component);
            }
        }
    }

    private Component getTopWindow(Component c) {
        while (c != null) {
            if (c instanceof Window || ContextManager.isContext(c)) {
                return c;
            }
            c = c.getParent();
        }
        return null;
    }

    public String getOMapClassName() {
        if (this.component instanceof Frame || this.component instanceof Window || this.component instanceof Dialog || this.component instanceof JInternalFrame) {
            String className = this.component.getClass().getName();
            Package pkg = this.component.getClass().getPackage();
            if (pkg == null) {
                return className;
            }
            String pkgName = pkg.getName();
            if (!pkgName.startsWith("javax.swing") && !pkgName.startsWith("java.awt")) {
                return className;
            }
            if (className.equals("javax.swing.ColorChooserDialog")) {
                return className;
            }
            if (this.component instanceof JDialog) {
                Component[] components = ((JDialog)this.component).getContentPane().getComponents();
                if (components.length == 1 && components[0] instanceof JFileChooser) {
                    return JFileChooser.class.getName() + "#Dialog";
                }
                if (components.length == 1 && components[0] instanceof JOptionPane) {
                    return JOptionPane.class.getName() + "#Dialog_" + ((JOptionPane)components[0]).getMessageType() + "_" + ((JOptionPane)components[0]).getOptionType();
                }
            }
            return null;
        }
        return null;
    }

    public String getOMapClassSimpleName() {
        if (this.component instanceof Frame || this.component instanceof Window || this.component instanceof Dialog || this.component instanceof JInternalFrame) {
            String className = this.component.getClass().getName();
            String simpleName = this.component.getClass().getSimpleName();
            Package pkg = this.component.getClass().getPackage();
            if (pkg == null) {
                return simpleName;
            }
            String pkgName = pkg.getName();
            if (!pkgName.startsWith("javax.swing") && !pkgName.startsWith("java.awt")) {
                return simpleName;
            }
            if (className.equals("javax.swing.ColorChooserDialog")) {
                return simpleName;
            }
            if (this.component instanceof JDialog) {
                Component[] components = ((JDialog)this.component).getContentPane().getComponents();
                if (components.length == 1 && components[0] instanceof JFileChooser) {
                    return JFileChooser.class.getSimpleName() + "#Dialog";
                }
                if (components.length == 1 && components[0] instanceof JOptionPane) {
                    return JOptionPane.class.getSimpleName() + "#Dialog";
                }
            }
            return null;
        }
        return null;
    }

    public int getIndexOfType() {
        List<Component> allComponents = this.findAllComponents();
        int index = 0;
        Class<?> klass = this.component.getClass();
        String tagName = this.getTagName(klass);
        for (Component c : allComponents) {
            if (c == this.component) {
                return index;
            }
            if (!this.getTagName(c.getClass()).equals(tagName)) continue;
            ++index;
        }
        return -1;
    }

    public String getFieldName() {
        List<String> fieldNames = this.getFieldNames();
        if (fieldNames.size() == 0) {
            return null;
        }
        return fieldNames.get(0);
    }

    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Container container = this.component.getParent(); container != null; container = container.getParent()) {
            this.findFields(this.component, container, fieldNames);
        }
        return fieldNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findFields(Component current, Component container, List<String> fieldNames) {
        Field[] declaredFields;
        for (Field field : declaredFields = container.getClass().getDeclaredFields()) {
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                Object o = field.get(container);
                if (o != current) continue;
                fieldNames.add(field.getName());
            }
            catch (Throwable throwable) {
            }
            finally {
                field.setAccessible(accessible);
            }
        }
    }

    public String getCText() {
        Object o = this.getAttributeObject(this.getComponent(), "text");
        if (o == null || !(o instanceof String) || o.equals("")) {
            return null;
        }
        return (String)o;
    }

    public String getButtonText() {
        if (this.component instanceof AbstractButton) {
            return this.getCText();
        }
        return null;
    }

    public String getButtonIconFile() {
        if (this.component instanceof AbstractButton) {
            return this.getIconFile();
        }
        return null;
    }

    public String getIconFile() {
        String description;
        Object o = this.getAttributeObject(this.getComponent(), "icon");
        if (o == null || !(o instanceof Icon)) {
            return null;
        }
        Icon icon = (Icon)o;
        if (icon instanceof ImageIcon && (description = ((ImageIcon)icon).getDescription()) != null && description.length() != 0) {
            return JavaElementPropertyAccessor.mapFromImageDescription(description);
        }
        return null;
    }

    public static String mapFromImageDescription(String description) {
        try {
            String name = new URL(description).getPath();
            if (name.lastIndexOf(47) != -1) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            if (name.lastIndexOf(46) != -1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            return name;
        }
        catch (MalformedURLException e) {
            return description;
        }
    }

    public String getClassName() {
        return this.component.getClass().getName();
    }

    public boolean getEnabled() {
        return this.component.isEnabled();
    }

    public String getToolTipText() {
        if (this.component instanceof JComponent) {
            return ((JComponent)this.component).getToolTipText();
        }
        return null;
    }

    public String getName() {
        return this.getComponent().getName();
    }

    private String stripLastColon(String name) {
        if (name.endsWith(":")) {
            name = name.substring(0, name.length() - 1).trim();
        }
        if (name.length() == 0) {
            return null;
        }
        return name;
    }

    public String getMenuKey() {
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((menuShortcutKeyMask & 2) == 2) {
            return "Control";
        }
        if ((menuShortcutKeyMask & 4) == 4) {
            return "Meta";
        }
        return "";
    }

    public String getAccessibleName() {
        if (this.component instanceof JTabbedPane) {
            return null;
        }
        return this.component.getAccessibleContext().getAccessibleName();
    }

    public Point getMidpoint() {
        EventQueueWait.call_noexc(this, "_makeVisible", new Object[0]);
        return (Point)EventQueueWait.call_noexc(this, "_getMidpoint", new Object[0]);
    }

    public Object _makeVisible() {
        return null;
    }

    public Point _getMidpoint() {
        Dimension d = this.component.getSize();
        return new Point(d.width / 2, d.height / 2);
    }

    public String getLabeledBy() {
        if (this.getComponent() instanceof JComponent) {
            try {
                JLabel label = (JLabel)((JComponent)this.getComponent()).getClientProperty("labeledBy");
                if (label != null && label.getText() != null && !label.getText().equals("")) {
                    return this.stripLastColon(label.getText().trim());
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public Map<String, String> findURP(List<List<String>> rp) {
        List<Component> allComponents = this.findAllComponents();
        allComponents.remove(this.component);
        for (List<String> list : rp) {
            Map<String, String> rpValues = this.findValues(list);
            if (rpValues == null || this.hasAComponentsByRP(allComponents, rpValues)) continue;
            return rpValues;
        }
        return this.findValues(LAST_RESORT_RECOGNITION_PROPERTIES);
    }

    private Map<String, String> findValues(List<String> list) {
        HashMap<String, String> rpValues = new HashMap<String, String>();
        for (String attribute : list) {
            String value = this.getAttribute(attribute);
            if (value == null || "".equals(value)) {
                rpValues = null;
                break;
            }
            rpValues.put(attribute, value);
        }
        return rpValues;
    }

    private boolean hasAComponentsByRP(List<Component> allComponents, Map<String, String> rpValues) {
        for (Component component : allComponents) {
            if (!this.matchesRP(component, rpValues)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesRP(Component component, Map<String, String> rpValues) {
        JavaElementPropertyAccessor pa = new JavaElementPropertyAccessor(component);
        Set<Map.Entry<String, String>> entrySet = rpValues.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (entry.getValue().equals(pa.getAttribute(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaElementPropertyAccessor other = (JavaElementPropertyAccessor)obj;
        return !(this.component == null ? other.component != null : !this.component.equals(other.component));
    }

    public Map<String, String> findAttributes(Collection<String> props) {
        HashMap<String, String> r = new HashMap<String, String>();
        for (String prop : props) {
            String value = this.getAttribute(prop);
            if (value == null) continue;
            r.put(prop, value);
        }
        return r;
    }

    public int getInternalFrameIndex2() {
        return InternalFrameMonitor.getIndex(this.component);
    }

    public String callMethod(JSONObject callDetails) {
        String methodName = callDetails.getString("method");
        JSONObject parameters = callDetails.getJSONObject("parameters");
        try {
            Method method = this.getClass().getMethod(methodName, JSONObject.class);
            return (String)method.invoke((Object)this, parameters);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public Color getBackground() {
        return this.component.getBackground();
    }

    public Color getForeground() {
        return this.component.getForeground();
    }

    public Font getFont() {
        return this.component.getFont();
    }

    public String getFontFamily() {
        return this.component.getFont().getFamily();
    }

    public Border getBorder() {
        if (this.component instanceof JComponent) {
            return ((JComponent)this.component).getBorder();
        }
        return null;
    }

    public Integer getColumnCount() {
        if (this.component instanceof JTable) {
            return ((JTable)this.component).getColumnCount();
        }
        if (this.component instanceof JTableHeader) {
            return ((JTableHeader)this.component).getColumnModel().getColumnCount();
        }
        return null;
    }

    public Integer getRowCount() {
        if (this.component instanceof JTable) {
            return ((JTable)this.component).getRowCount();
        }
        return null;
    }

    public Integer getItemCount() {
        if (this.component instanceof JComboBox) {
            return ((JComboBox)this.component).getItemCount();
        }
        return null;
    }

    public Integer getModelSize() {
        if (this.component instanceof JList) {
            return ((JList)this.component).getModel().getSize();
        }
        return null;
    }

    public String getColumnName(int c) {
        JTable table = (JTable)this.component;
        JTableHeader tableHeader = table.getTableHeader();
        String columnName = tableHeader != null ? tableHeader.getColumnModel().getColumn(c).getHeaderValue().toString() : table.getColumnName(c);
        return columnName;
    }

    public static String removeClassName(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                buffer.append(JavaElementPropertyAccessor.removeClassName(Array.get(object, i)));
                if (i == length - 1) continue;
                buffer.append(", ");
            }
            buffer.append("]");
            return buffer.toString();
        }
        if (object.getClass().isPrimitive() || object instanceof String) {
            return object.toString();
        }
        try {
            return object.toString().replaceFirst(object.getClass().getName(), "");
        }
        catch (Throwable t) {
            return object.toString();
        }
    }

    static {
        LAST_RESORT_RECOGNITION_PROPERTIES.add("tagName");
        LAST_RESORT_RECOGNITION_PROPERTIES.add("indexOfType");
    }

    public static class InternalFrameMonitor {
        static final List<JInternalFrame> frames = new ArrayList<JInternalFrame>();

        public static int getIndex(Component component) {
            return frames.indexOf(component);
        }

        public static void init() {
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (event.getSource() instanceof JInternalFrame) {
                        if (event.getID() == 102) {
                            frames.add((JInternalFrame)event.getSource());
                        }
                        if (event.getID() == 103) {
                            frames.remove(event.getSource());
                        }
                    }
                }
            }, 1L);
        }
    }
}

