/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.IPseudoElement;
import net.sourceforge.marathon.javaagent.JavaElementFactory;
import net.sourceforge.marathon.javaagent.JavaElementPropertyAccessor;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.NoSuchWindowException;
import net.sourceforge.marathon.javaagent.Wait;
import net.sourceforge.marathon.javaagent.WindowTitle;
import net.sourceforge.marathon.javaagent.components.FileDialogElement;
import org.json.JSONArray;
import org.json.JSONObject;
import sun.awt.AppContext;

public class JavaTargetLocator {
    public static final Logger LOGGER = Logger.getLogger(JavaTargetLocator.class.getName());
    public static JSONArray allProperties = new JSONArray();
    private IJavaAgent driver;
    private JWindow currentWindow;
    private Map<Window, JWindow> windows = new HashMap<Window, JWindow>();

    public JavaTargetLocator(IJavaAgent driver) {
        this.driver = driver;
    }

    public IJavaAgent window(final String windowDetails) {
        if (this.driver.getImplicitWait() != 0L) {
            new EventQueueWait(){

                @Override
                public boolean till() {
                    try {
                        return JavaTargetLocator.this.window_internal(windowDetails) != null;
                    }
                    catch (NoSuchWindowException e) {
                        return false;
                    }
                }
            }.wait_noexc("Timedout waiting for the window", this.driver.getImplicitWait(), 50L);
        }
        try {
            return EventQueueWait.exec(new Callable<IJavaAgent>(){

                @Override
                public IJavaAgent call() {
                    return JavaTargetLocator.this.window_internal(windowDetails);
                }
            });
        }
        catch (Exception e) {
            throw new NoSuchWindowException(e.getMessage(), e);
        }
    }

    private IJavaAgent window_internal(String windowDetails) {
        Window[] windows;
        String nameOrHandleOrTitle = null;
        JSONObject winDetailsJsonObject = null;
        try {
            winDetailsJsonObject = new JSONObject(windowDetails);
            nameOrHandleOrTitle = winDetailsJsonObject.getString("title");
        }
        catch (Exception e) {
            nameOrHandleOrTitle = windowDetails;
        }
        for (Window window : windows = this.getValidWindows()) {
            JWindow jw = new JWindow(window);
            try {
                if (winDetailsJsonObject != null) {
                    jw.setContainerNamingProperties(this.getContainerNP(window, winDetailsJsonObject.getJSONObject("containerNP")));
                    allProperties = winDetailsJsonObject.getJSONArray("allProperties");
                }
            }
            catch (RuntimeException e) {
                LOGGER.warning(e.getMessage());
                throw e;
            }
            String title = jw.getTitle();
            if (nameOrHandleOrTitle.startsWith("/") && !nameOrHandleOrTitle.startsWith("//")) {
                if (title == null || !title.matches(nameOrHandleOrTitle.substring(1))) continue;
                this.setCurrentWindow(window);
                return this.driver;
            }
            if (nameOrHandleOrTitle.startsWith("//")) {
                if (title == null || !title.equals(nameOrHandleOrTitle.substring(1))) continue;
                this.setCurrentWindow(window);
                return this.driver;
            }
            if (title == null || !title.equals(nameOrHandleOrTitle)) continue;
            this.setCurrentWindow(window);
            return this.driver;
        }
        for (Window window : windows) {
            String handle = JavaTargetLocator.getWindowHandle(window);
            if (!nameOrHandleOrTitle.equals(handle)) continue;
            this.setCurrentWindow(window);
            return this.driver;
        }
        throw new NoSuchWindowException("Cannot find window: " + windowDetails, null);
    }

    private List<List<String>> getContainerNP(Window window, JSONObject map) {
        String wClassName = this.getWindowClassName(map, window);
        if (wClassName != null) {
            JSONArray npArray = map.getJSONArray(wClassName);
            ArrayList<List<String>> containerNP = new ArrayList<List<String>>();
            for (int i = 0; i < npArray.length(); ++i) {
                ArrayList<String> pList = new ArrayList<String>();
                JSONArray pArray = (JSONArray)npArray.get(i);
                for (int j = 0; j < pArray.length(); ++j) {
                    pList.add(pArray.getString(j));
                }
                containerNP.add(pList);
            }
            return containerNP;
        }
        return null;
    }

    private String getWindowClassName(JSONObject containerNP, Window window) {
        Class<?> klass = window.getClass();
        while (klass.getName() != null && !klass.getName().equals("java.lang.Object")) {
            if (containerNP.has(klass.getName())) {
                return klass.getName();
            }
            klass = klass.getSuperclass();
        }
        return null;
    }

    public void deleteWindow() {
        Window w = this.getTopContainer().getWindow();
        this.windows.remove(w);
        this.getTopContainer().deleteWindow();
    }

    private Window[] getValidWindows() {
        ArrayList<Window> valid = new ArrayList<Window>();
        Set<AppContext> appContexts = AppContext.getAppContexts();
        for (AppContext appContext : appContexts) {
            Window[] windows;
            for (Window window : windows = JavaTargetLocator.getWindows(appContext)) {
                if (window.getClass().getName().equals("javax.swing.SwingUtilities$SharedOwnerFrame") || window.getClass().getName().equals("javax.swing.Popup$HeavyWeightWindow") || !window.isVisible()) continue;
                valid.add(window);
            }
        }
        return valid.toArray(new Window[valid.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Window[] getWindows(AppContext appContext) {
        Class<Window> clazz = Window.class;
        synchronized (Window.class) {
            Window[] realCopy;
            Vector windowList = (Vector)appContext.get(Window.class);
            if (windowList != null) {
                int fullSize = windowList.size();
                int realSize = 0;
                Window[] fullCopy = new Window[fullSize];
                for (int i = 0; i < fullSize; ++i) {
                    Window w = (Window)((WeakReference)windowList.get(i)).get();
                    if (w == null) continue;
                    fullCopy[realSize++] = w;
                }
                realCopy = fullSize != realSize ? Arrays.copyOf(fullCopy, realSize) : fullCopy;
            } else {
                realCopy = new Window[]{};
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return realCopy;
        }
    }

    private void setCurrentWindow(Window window) {
        JWindow jw = this.windows.get(window);
        if (jw == null) {
            jw = new JWindow(window);
            this.windows.put(window, jw);
        }
        this.currentWindow = jw;
        EventQueueWait.call_noexc(window, "toFront", new Object[0]);
    }

    private static String getWindowHandle(Container topContainer) {
        return Integer.toHexString(System.identityHashCode(topContainer));
    }

    public String getTitle() {
        return this.getFocusedWindowTitle();
    }

    private String getFocusedWindowTitle() {
        new Wait(){

            @Override
            public boolean until() {
                return JavaTargetLocator.this.findFocusWindow() != null;
            }
        }.wait("No focused window available", 60000L, 500L);
        Window focusWindow = this.findFocusWindow();
        if (focusWindow != null) {
            return new JWindow(focusWindow).getTitle();
        }
        return null;
    }

    private Window findFocusWindow() {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (w != null) {
            return w;
        }
        w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (w != null) {
            return w;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null) {
            w = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (w != null) {
            return w;
        }
        Window[] validWindows = this.getValidWindows();
        if (validWindows.length > 0) {
            return validWindows[validWindows.length - 1];
        }
        return null;
    }

    public String getWindowHandle() {
        return this.getTopContainer().getHandle();
    }

    public Collection<String> getWindowHandles() {
        Window[] windows;
        ArrayList<String> windowHandles = new ArrayList<String>();
        for (Window window : windows = this.getValidWindows()) {
            windowHandles.add(JavaTargetLocator.getWindowHandle(window));
        }
        return windowHandles;
    }

    public JWindow getTopContainer() {
        new Wait(){

            @Override
            public boolean until() {
                try {
                    JavaTargetLocator.this._getTopContainer();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }.wait("No top level window available", 60000L, 500L);
        return this._getTopContainer();
    }

    private JWindow _getTopContainer() {
        if (this.currentWindow == null) {
            Window[] windows = this.getValidWindows();
            if (windows.length == 1) {
                this.setCurrentWindow(windows[0]);
            } else if (windows.length > 1) {
                throw new NoSuchWindowException("No top level window is set. Java driver is unable to select from multiple windows", null);
            }
        }
        if (this.currentWindow == null) {
            throw new NoSuchWindowException("No top level window is set. Java driver is unable to find a suitable implicit candidate", null);
        }
        return this.currentWindow;
    }

    public JWindow getWindowForHandle(String windowHandle) {
        Window[] windows;
        for (Window window : windows = this.getValidWindows()) {
            if (!windowHandle.equals(JavaTargetLocator.getWindowHandle(window))) continue;
            return new JWindow(window);
        }
        throw new NoSuchWindowException("No window found corresponding to the given window Handle", null);
    }

    public IJavaElement findElement(String id) {
        return this.getTopContainer().findElement(id);
    }

    public IJavaElement getActiveElement() {
        JWindow top = this.getTopContainer();
        Component active = top.getWindow().getFocusOwner();
        if (active == null) {
            throw new NoSuchElementException("Could not find focus owner for the topmost window", null);
        }
        return top.findElement(active);
    }

    public JWindow getCurrentWindow() {
        this.getTopContainer();
        return this.currentWindow;
    }

    public JSONObject getWindowProperties() {
        return this.getTopContainer().getWindowProperties();
    }

    public JWindow getFileDialogContainer() {
        Window[] pwindows;
        for (Window window : pwindows = this.getValidWindows()) {
            if (!window.getClass().getName().equals("java.awt.FileDialog")) continue;
            return new JWindow(window);
        }
        throw new NoSuchElementException("Couldn't find file dialog window", null);
    }

    public class JWindow {
        private String currentWindowHandle;
        private Window currentWindow;
        private ElementMap elements = new ElementMap();
        private Map<Component, IJavaElement> components = new HashMap<Component, IJavaElement>();
        private List<List<String>> containerNP;

        private JWindow(Window window) {
            this.currentWindow = window;
            this.currentWindowHandle = JavaTargetLocator.getWindowHandle(window);
        }

        public Window getWindow() {
            return this.currentWindow;
        }

        public String getHandle() {
            return this.currentWindowHandle;
        }

        public String getTitle() {
            return EventQueueWait.exec(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    WindowTitle windowTitle = new WindowTitle(JWindow.this.currentWindow);
                    windowTitle.setContainerNamingProperties(JWindow.this.containerNP);
                    return windowTitle.getTitle();
                }
            });
        }

        public void setContainerNamingProperties(List<List<String>> containerNP) {
            this.containerNP = containerNP;
        }

        public void deleteWindow() {
            EventQueueWait.call_noexc(this.currentWindow, "dispose", new Object[0]);
        }

        public Dimension getSize() {
            return (Dimension)EventQueueWait.call_noexc(this.currentWindow, "getSize", new Object[0]);
        }

        public Point getLocation() {
            return (Point)EventQueueWait.call_noexc(this.currentWindow, "getLocation", new Object[0]);
        }

        public void setSize(int width, int height) {
            EventQueueWait.call_noexc(this.currentWindow, "setSize", width, height);
        }

        public void setLocation(int x, int y) {
            EventQueueWait.call_noexc(this.currentWindow, "setLocation", x, y);
        }

        public void maximize() {
            if (this.currentWindow instanceof JFrame) {
                EventQueueWait.call_noexc(this.currentWindow, "setExtendedState", 6);
            }
        }

        public IJavaElement addElement(IJavaElement je) {
            Component active = je instanceof IPseudoElement ? ((IPseudoElement)((Object)je)).getParent().getComponent() : je.getComponent();
            IJavaElement found = this.components.get(active);
            if (found != null) {
                je.setId(found.getId());
                return je;
            }
            if (je instanceof IPseudoElement) {
                this.elements.put(((IPseudoElement)((Object)je)).getParent().createId(), ((IPseudoElement)((Object)je)).getParent());
                je.setId(((IPseudoElement)((Object)je)).getParent().getId());
            } else {
                this.elements.put(je.createId(), je);
            }
            this.components.put(active, je instanceof IPseudoElement ? ((IPseudoElement)((Object)je)).getParent() : je);
            return je;
        }

        public IJavaElement findElement(String id) {
            IJavaElement e;
            String info = null;
            try {
                id = URLDecoder.decode(id, "utf8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            int indexOf = id.indexOf(35);
            if (indexOf > 0) {
                String idPart = id.substring(0, indexOf);
                info = id.substring(indexOf + 1);
                id = idPart;
            }
            if ((e = this.elements.get(id)) == null) {
                throw new NoSuchElementException("Could not find element for the given id in the topmost window", null);
            }
            if (info == null) {
                return e;
            }
            JSONObject pobj = new JSONObject(info);
            String selector = pobj.getString("selector");
            JSONArray parray = pobj.getJSONArray("parameters");
            Object[] params = new Object[parray.length()];
            for (int i = 0; i < parray.length(); ++i) {
                params[i] = parray.get(i);
            }
            e = e.getByPseudoElement(selector, params).get(0);
            return e;
        }

        public IJavaElement findElement(Component active) {
            IJavaElement found = this.components.get(active);
            if (found == null) {
                IJavaElement e = JavaElementFactory.createElement(active, JavaTargetLocator.this.driver, this);
                this.elements.put(e.createId(), e);
                this.components.put(active, e);
                found = e;
            }
            return found;
        }

        public IJavaElement findElementFromMap(Component active) {
            return this.components.get(active);
        }

        public JSONObject getWindowProperties() {
            String title = this.getTitle();
            String componentClassName = this.currentWindow.getClass().getName();
            String omapClassName = this.getOMapClassName();
            JSONObject object = new JSONObject();
            object.put("title", title).put("component.class.name", componentClassName).put("oMapClassName", omapClassName).put("tagName", "window");
            JavaElementPropertyAccessor pa = new JavaElementPropertyAccessor(this.currentWindow);
            for (int i = 0; i < allProperties.length(); ++i) {
                String property = allProperties.getString(i);
                String attribute = pa.getAttribute(property);
                if (attribute == null) continue;
                object.put(property, attribute);
            }
            return object;
        }

        public String getOMapClassName() {
            if (this.currentWindow instanceof Frame || this.currentWindow instanceof Window || this.currentWindow instanceof Dialog) {
                String className = this.currentWindow.getClass().getName();
                Package pkg = this.currentWindow.getClass().getPackage();
                if (pkg == null) {
                    return className;
                }
                String pkgName = pkg.getName();
                if (!pkgName.startsWith("javax.swing") && !pkgName.startsWith("java.awt")) {
                    return className;
                }
                if (className.equals("javax.swing.ColorChooserDialog")) {
                    return className;
                }
                if (this.currentWindow instanceof JDialog) {
                    Component[] components = ((JDialog)this.currentWindow).getContentPane().getComponents();
                    if (components.length == 1 && components[0] instanceof JFileChooser) {
                        return JFileChooser.class.getName() + "#Dialog";
                    }
                    if (components.length == 1 && components[0] instanceof JOptionPane) {
                        return JOptionPane.class.getName() + "#Dialog_" + ((JOptionPane)components[0]).getMessageType() + "_" + ((JOptionPane)components[0]).getOptionType();
                    }
                }
                return null;
            }
            return null;
        }

        public IJavaElement findFileDialogElement(JWindow dialog) {
            FileDialogElement e = new FileDialogElement(dialog, JavaTargetLocator.this.driver, this);
            this.elements.put(e.createId(), e);
            return e;
        }
    }

    public static class ElementMap {
        private Map<String, IJavaElement> elements = new HashMap<String, IJavaElement>();

        public void put(String id, IJavaElement je) {
            this.elements.put(id, je);
        }

        public IJavaElement get(String id) {
            return this.elements.get(id);
        }
    }
}

