/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.marathon.javaagent.JavaAgentKeys;

public class KeyboardMap {
    public static final Logger LOGGER;
    private char c;
    private static Map<Character, List<CharSequence[]>> keys;

    public KeyboardMap(char c) {
        this.c = c;
    }

    private static void loadEntries(InputStream is) throws IOException {
        CharSequence[] cs;
        Pattern p = Pattern.compile("\\(([^\\)]*)\\)");
        BufferedReader r = new BufferedReader(new InputStreamReader(is, Charset.forName("utf-8")));
        String line = r.readLine();
        while (line != null) {
            if (line.trim().length() == 0) {
                line = r.readLine();
                continue;
            }
            char c = line.charAt(0);
            line = line.substring(1).trim();
            Matcher matcher = p.matcher(line);
            ArrayList<CharSequence[]> lcs = new ArrayList<CharSequence[]>();
            while (matcher.find()) {
                lcs.add(KeyboardMap.getSequence(matcher.group(1)));
            }
            keys.put(Character.valueOf(c), lcs);
            line = r.readLine();
        }
        r.close();
        if (keys.get(Character.valueOf(' ')) == null) {
            ArrayList<CharSequence[]> lcs = new ArrayList<CharSequence[]>();
            cs = new CharSequence[]{"32"};
            lcs.add(cs);
            keys.put(Character.valueOf(' '), lcs);
        }
        if (keys.get(Character.valueOf('\n')) == null) {
            ArrayList<CharSequence[]> lcs = new ArrayList<CharSequence[]>();
            cs = new CharSequence[]{"10"};
            lcs.add(cs);
            keys.put(Character.valueOf('\n'), lcs);
        }
    }

    private static CharSequence[] getSequence(String keys) {
        ArrayList<CharSequence> lcs = new ArrayList<CharSequence>();
        Scanner scanner = new Scanner(keys);
        while (scanner.hasNext()) {
            String key = scanner.next();
            if (key.equals("SHIFT")) {
                lcs.add(JavaAgentKeys.SHIFT);
                continue;
            }
            if (key.equals("ALT")) {
                lcs.add(JavaAgentKeys.ALT);
                continue;
            }
            if (key.equals("META")) {
                lcs.add(JavaAgentKeys.META);
                continue;
            }
            if (key.equals("CONTROL")) {
                lcs.add(JavaAgentKeys.CONTROL);
                continue;
            }
            String vkCode = "VK_" + key;
            try {
                lcs.add(KeyEvent.class.getDeclaredField(vkCode).get(null) + "");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return lcs.toArray(new CharSequence[lcs.size()]);
    }

    public List<CharSequence[]> getKeys() {
        return keys.get(Character.valueOf(this.c));
    }

    static {
        Locale locale;
        String fileName;
        LOGGER = Logger.getLogger(KeyboardMap.class.getName());
        keys = new HashMap<Character, List<CharSequence[]>>();
        File marathon = new File(System.getProperty("user.home"), ".marathon");
        File kmapFile = new File(marathon, fileName = (locale = InputContext.getInstance().getLocale()).getLanguage() + "_" + locale.getCountry() + ".kb");
        if (!kmapFile.exists() && !(kmapFile = new File(marathon, "default.kb")).exists()) {
            kmapFile = null;
        }
        InputStream is = null;
        if (kmapFile != null) {
            try {
                is = new FileInputStream(kmapFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (is == null && (is = KeyboardMap.class.getResourceAsStream("layouts/" + fileName)) == null) {
            is = KeyboardMap.class.getResourceAsStream("layouts/default.kb");
        }
        if (is == null) {
            throw new RuntimeException("Unable to load keyboard map");
        }
        try {
            KeyboardMap.loadEntries(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load keyboard map", e);
        }
    }
}

