/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import net.sourceforge.marathon.javaagent.JavaAgentKeys;

public enum KeysMap {
    NULL(JavaAgentKeys.NULL, 0),
    Cancel(JavaAgentKeys.CANCEL, 3),
    Help(JavaAgentKeys.HELP, 156),
    Backspace(JavaAgentKeys.BACK_SPACE, 8),
    Tab(JavaAgentKeys.TAB, 9),
    Clear(JavaAgentKeys.CLEAR, 12),
    Return(JavaAgentKeys.RETURN, 10),
    Enter(JavaAgentKeys.ENTER, 10),
    Pause(JavaAgentKeys.PAUSE, 19),
    Escape(JavaAgentKeys.ESCAPE, 27),
    Space(JavaAgentKeys.SPACE, 32),
    Pageup(JavaAgentKeys.PAGE_UP, 33),
    Pagedown(JavaAgentKeys.PAGE_DOWN, 34),
    End(JavaAgentKeys.END, 35),
    Home(JavaAgentKeys.HOME, 36),
    Left(JavaAgentKeys.LEFT, 37),
    Up(JavaAgentKeys.UP, 38),
    Right(JavaAgentKeys.RIGHT, 39),
    Down(JavaAgentKeys.DOWN, 40),
    Insert(JavaAgentKeys.INSERT, 155),
    Delete(JavaAgentKeys.DELETE, 127),
    Semicolon(JavaAgentKeys.SEMICOLON, 59),
    Equals(JavaAgentKeys.EQUALS, 61),
    SHIFT(JavaAgentKeys.SHIFT, 16),
    LEFT_SHIFT(JavaAgentKeys.LEFT_SHIFT, 16),
    CONTROL(JavaAgentKeys.CONTROL, 17),
    LEFT_CONTROL(JavaAgentKeys.LEFT_CONTROL, 17),
    ALT(JavaAgentKeys.ALT, 18),
    LEFT_ALT(JavaAgentKeys.LEFT_ALT, 18),
    ARROW_LEFT(JavaAgentKeys.ARROW_LEFT, 226),
    ARROW_UP(JavaAgentKeys.ARROW_UP, 224),
    ARROW_RIGHT(JavaAgentKeys.ARROW_RIGHT, 227),
    ARROW_DOWN(JavaAgentKeys.ARROW_DOWN, 225),
    NUMPAD0(JavaAgentKeys.NUMPAD0, 96),
    NUMPAD1(JavaAgentKeys.NUMPAD1, 97),
    NUMPAD2(JavaAgentKeys.NUMPAD2, 98),
    NUMPAD3(JavaAgentKeys.NUMPAD3, 99),
    NUMPAD4(JavaAgentKeys.NUMPAD4, 100),
    NUMPAD5(JavaAgentKeys.NUMPAD5, 101),
    NUMPAD6(JavaAgentKeys.NUMPAD6, 102),
    NUMPAD7(JavaAgentKeys.NUMPAD7, 103),
    NUMPAD8(JavaAgentKeys.NUMPAD8, 104),
    NUMPAD9(JavaAgentKeys.NUMPAD9, 105),
    MULTIPLY(JavaAgentKeys.MULTIPLY, 106),
    ADD(JavaAgentKeys.ADD, 107),
    SEPARATOR(JavaAgentKeys.SEPARATOR, 108),
    SUBTRACT(JavaAgentKeys.SUBTRACT, 109),
    DECIMAL(JavaAgentKeys.DECIMAL, 110),
    DIVIDE(JavaAgentKeys.DIVIDE, 111),
    F1(JavaAgentKeys.F1, 112),
    F2(JavaAgentKeys.F2, 113),
    F3(JavaAgentKeys.F3, 114),
    F4(JavaAgentKeys.F4, 115),
    F5(JavaAgentKeys.F5, 116),
    F6(JavaAgentKeys.F6, 117),
    F7(JavaAgentKeys.F7, 118),
    F8(JavaAgentKeys.F8, 119),
    F9(JavaAgentKeys.F9, 120),
    F10(JavaAgentKeys.F10, 121),
    F11(JavaAgentKeys.F11, 122),
    F12(JavaAgentKeys.F12, 123),
    META(JavaAgentKeys.META, 157),
    COMMAND(JavaAgentKeys.COMMAND, 157);

    private final JavaAgentKeys keys;
    private final int code;

    private KeysMap(JavaAgentKeys keys, int code) {
        this.keys = keys;
        this.code = code;
    }

    public JavaAgentKeys getKeys() {
        return this.keys;
    }

    public int getCode() {
        return this.code;
    }

    public static KeysMap findMap(JavaAgentKeys k) {
        for (KeysMap km : KeysMap.values()) {
            if (!km.getKeys().equals(k)) continue;
            return km;
        }
        return null;
    }

    public static KeysMap findMap(int k) {
        for (KeysMap km : KeysMap.values()) {
            if (km.getCode() != k) continue;
            return km;
        }
        return null;
    }
}

