/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.Device;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IDevice;
import net.sourceforge.marathon.javaagent.JavaAgentKeys;
import net.sourceforge.marathon.javaagent.KeyboardMap;
import net.sourceforge.marathon.javaagent.KeysMap;
import net.sourceforge.marathon.javaagent.Platform;

public class RobotDevice
extends Device {
    public static final Logger LOGGER;
    private Robot robot;
    private DeviceState deviceState = new DeviceState();
    static Map<Integer, String> keyCodeToString;
    static Map<Integer, String> buttonToString;

    public RobotDevice() {
        try {
            this.robot = new Robot();
            this.robotXsetAutoWaitForIdle(true);
            this.robotXsetAutoDelay();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendKeys(Component component, CharSequence ... keysToSend) {
        component = Device.getActiveComponent(component);
        EventQueueWait.requestFocus(component);
        for (CharSequence seq : keysToSend) {
            for (int i = 0; i < seq.length(); ++i) {
                this.sendKey(component, seq.charAt(i));
            }
        }
    }

    private void sendKey(Component component, char c) {
        JavaAgentKeys keys = JavaAgentKeys.getKeyFromUnicode(c);
        if (keys == null) {
            this.dispatchNormalCharacter(component, c);
            return;
        }
        if (keys == JavaAgentKeys.NULL) {
            this.deviceState.resetModifierState(component);
        } else if (this.deviceState.isModifier(keys)) {
            this.deviceState.toggleKeyState(component, keys);
        } else {
            this.pressKey(component, keys);
            this.releaseKey(component, keys);
        }
    }

    private void dispatchNormalCharacter(Component component, char c) {
        KeyboardMap kbMap = new KeyboardMap(c);
        List<CharSequence[]> keysList = kbMap.getKeys();
        if (keysList == null) {
            return;
        }
        for (CharSequence[] keys : keysList) {
            for (CharSequence key : keys) {
                if (this.deviceState.isModifier(key)) {
                    this.pressKey(component, (JavaAgentKeys)key);
                    continue;
                }
                this.robotXkeyPress(Integer.parseInt(key.toString()));
            }
            for (int i = keys.length - 1; i >= 0; --i) {
                CharSequence key = keys[i];
                if (this.deviceState.isModifier(key)) {
                    this.releaseKey(component, (JavaAgentKeys)key);
                    continue;
                }
                this.robotXkeyRelease(Integer.parseInt(key.toString()));
            }
        }
    }

    @Override
    public void pressKey(Component component, JavaAgentKeys keyToPress) {
        KeysMap keysMap = KeysMap.findMap(keyToPress);
        int keycode = keysMap.getCode();
        this.robotXkeyPress(keycode);
    }

    @Override
    public void releaseKey(Component component, JavaAgentKeys keyToRelease) {
        KeysMap keysMap = KeysMap.findMap(keyToRelease);
        int keycode = keysMap.getCode();
        this.robotXkeyRelease(keycode);
    }

    @Override
    public void buttonDown(Component component, IDevice.Buttons button, int xoffset, int yoffset) {
        this.moveto(component, xoffset, yoffset);
        this.robotXmousePress(16);
    }

    @Override
    public void buttonUp(Component component, IDevice.Buttons button, int xoffset, int yoffset) {
        this.robotXmouseRelease(16);
    }

    @Override
    public void moveto(final Component component) {
        Dimension d = EventQueueWait.exec(new Callable<Dimension>(){

            @Override
            public Dimension call() {
                return component.getSize();
            }
        });
        this.moveto(component, d.width / 2, d.height / 2);
    }

    @Override
    public void moveto(final Component component, int xoffset, int yoffset) {
        Point compLocation = EventQueueWait.exec(new Callable<Point>(){

            @Override
            public Point call() {
                return component.getLocationOnScreen();
            }
        });
        this.robotXmouseMove(compLocation.x + xoffset, compLocation.y + yoffset);
    }

    @Override
    public void click(Component component, IDevice.Buttons button, int clickCount, int xoffset, int yoffset) {
        this.ensureVisible(component, new Rectangle(xoffset, yoffset, 50, 50));
        int b = 16;
        if (button.getButton() == 0) {
            b = 16;
        } else if (button.getButton() == 1) {
            b = 8;
        } else if (button.getButton() == 2) {
            b = 4;
        }
        Point compLocation = component.getLocationOnScreen();
        int x = compLocation.x + xoffset;
        int y = compLocation.y + yoffset;
        this.robotXmouseMove(x, y);
        for (int i = 0; i < clickCount; ++i) {
            this.robotXmousePress(b);
            this.robotXmouseRelease(b);
        }
    }

    private void robotXmouseMove(int x, int y) {
        Logger.getLogger(RobotDevice.class.getName()).info("robot.mouseMove(" + x + "," + y + ")");
        try {
            this.robot.mouseMove(x, y);
        }
        catch (IllegalThreadStateException e) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void robotXmousePress(int b) {
        Logger.getLogger(RobotDevice.class.getName()).info("robot.mousePress(" + buttonToString.get(b) + ")");
        try {
            this.robot.mousePress(b);
        }
        catch (IllegalThreadStateException e) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void robotXmouseRelease(int b) {
        Logger.getLogger(RobotDevice.class.getName()).info("robot.mouseRelease(" + buttonToString.get(b) + ")");
        try {
            this.robot.mouseRelease(b);
        }
        catch (IllegalThreadStateException e) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void robotXsetAutoWaitForIdle(boolean b) {
        Logger.getLogger(RobotDevice.class.getName()).info("robot.setAutoWaitForIdle(" + b + ")");
        this.robot.setAutoWaitForIdle(b);
    }

    private void robotXkeyRelease(int keyCode) {
        String s = keyCodeToString.get(keyCode);
        if (s != null) {
            Logger.getLogger(RobotDevice.class.getName()).info("robot.keyReleases(" + s + ")");
        } else {
            Logger.getLogger(RobotDevice.class.getName()).info("robot.keyReleases(" + keyCode + ")");
        }
        try {
            this.robot.keyRelease(keyCode);
        }
        catch (IllegalThreadStateException e) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void robotXkeyPress(int keyCode) {
        String s = keyCodeToString.get(keyCode);
        if (s != null) {
            Logger.getLogger(RobotDevice.class.getName()).info("robot.keyPress(" + s + ")");
        } else {
            Logger.getLogger(RobotDevice.class.getName()).info("robot.keyPress(" + keyCode + ")");
        }
        try {
            this.robot.keyPress(keyCode);
        }
        catch (IllegalThreadStateException e) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void robotXsetAutoDelay() {
        int delay = 50;
        if (Platform.getCurrent().is(Platform.LINUX)) {
            delay = 50;
        }
        if ((delay = Integer.getInteger("marathon.robot.delay", delay).intValue()) == 0) {
            return;
        }
        Logger.getLogger(RobotDevice.class.getName()).info("robot.setAutoDelay(" + delay + ")");
        this.robot.setAutoDelay(delay);
    }

    static {
        Field[] declaredFields;
        LOGGER = Logger.getLogger(RobotDevice.class.getName());
        keyCodeToString = new HashMap<Integer, String>();
        buttonToString = new HashMap<Integer, String>();
        for (Field field : declaredFields = KeyEvent.class.getDeclaredFields()) {
            if (!field.getName().startsWith("VK_")) continue;
            try {
                keyCodeToString.put(field.getInt(null), field.getName().substring(3));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        buttonToString.put(16, "BUTTON1");
        buttonToString.put(8, "BUTTON2");
        buttonToString.put(4, "BUTTON3");
    }

    public class DeviceState {
        Map<JavaAgentKeys, Boolean> keyStates = new HashMap<JavaAgentKeys, Boolean>();

        public DeviceState() {
            this.keyStates.put(JavaAgentKeys.SHIFT, false);
            this.keyStates.put(JavaAgentKeys.CONTROL, false);
            this.keyStates.put(JavaAgentKeys.ALT, false);
            this.keyStates.put(JavaAgentKeys.META, false);
        }

        public void toggleKeyState(Component component, JavaAgentKeys key) {
            Boolean pressed = this.keyStates.get(key) == false;
            this.keyStates.put(key, pressed);
            if (pressed.booleanValue()) {
                RobotDevice.this.pressKey(component, key);
            } else {
                RobotDevice.this.releaseKey(component, key);
            }
        }

        private boolean isModifier(CharSequence key) {
            return key == JavaAgentKeys.CONTROL || key == JavaAgentKeys.ALT || key == JavaAgentKeys.META || key == JavaAgentKeys.SHIFT;
        }

        private void resetModifierState(Component component) {
            for (Map.Entry<JavaAgentKeys, Boolean> keyState : this.keyStates.entrySet()) {
                if (!keyState.getValue().booleanValue()) continue;
                this.toggleKeyState(component, keyState.getKey());
            }
        }
    }
}

