/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.JavaElementPropertyAccessor;

public class WindowTitle {
    public static final Logger LOGGER = Logger.getLogger(WindowTitle.class.getName());
    private Window window;
    private List<List<String>> containerNP;

    public WindowTitle(Window window) {
        this.window = window;
    }

    public String getTitle() {
        String title = this.getTitleFromNP(this.window);
        Window[] windows = Window.getWindows();
        String original = title;
        int index = 1;
        for (Window w : windows) {
            String wTitle;
            if (w == this.window) {
                return title;
            }
            if (!w.isVisible() || !original.equals(wTitle = this.getTitleFromNP(w))) continue;
            title = original + "(" + index++ + ")";
        }
        return title;
    }

    private String getTitleFromNP(Window w1) {
        String title = null;
        if (this.containerNP != null) {
            List<String> list;
            Iterator<List<String>> iterator = this.containerNP.iterator();
            while (iterator.hasNext() && (title = this.getWindowName(new JavaElementPropertyAccessor(w1), list = iterator.next())) == null) {
            }
        }
        if (title == null) {
            title = this.getTitle(w1);
        }
        return title;
    }

    private String getWindowName(JavaElementPropertyAccessor w, List<String> properties) {
        StringBuilder sb = new StringBuilder();
        for (String property : properties) {
            String v = w.getAttribute(property);
            if (v == null) {
                return null;
            }
            sb.append(v).append(':');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString().trim();
    }

    private String getTitle(Component component) {
        String title = null;
        if (component instanceof Dialog) {
            title = ((Dialog)component).getTitle();
        } else if (component instanceof Frame) {
            title = ((Frame)component).getTitle();
        }
        return title == null ? "<NoTitle>" : title;
    }

    public void setContainerNamingProperties(List<List<String>> containerNP) {
        this.containerNP = containerNP;
    }
}

