/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import net.sourceforge.marathon.javaagent.components.IContextChecker;

public class ContextManager {
    public static final Logger LOGGER = Logger.getLogger(InstanceCheck.class.getName());
    private static LinkedList<IContextChecker> containers = new LinkedList();

    public static void add(Class<? extends Component> klass) {
        ContextManager.add(new InstanceCheck(klass));
    }

    public static void add(IContextChecker e) {
        containers.addFirst(e);
    }

    public static boolean isContext(Component c) {
        for (IContextChecker checker : containers) {
            if (!checker.isContext(c)) continue;
            return true;
        }
        return false;
    }

    static {
        ContextManager.add(JInternalFrame.class);
    }

    private static class InstanceCheck
    implements IContextChecker {
        private Class<? extends Component> componentClass;

        public InstanceCheck(Class<? extends Component> klass) {
            this.componentClass = klass;
        }

        @Override
        public boolean isContext(Component c) {
            return this.componentClass.isInstance(c);
        }
    }
}

