/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.components.JComboBoxOptionJavaElement;
import org.json.JSONArray;

public class JComboBoxJavaElement
extends AbstractJavaElement {
    public static final Logger LOGGER = Logger.getLogger(JComboBoxJavaElement.class.getName());

    public JComboBoxJavaElement(Component component, IJavaAgent driver, JavaTargetLocator.JWindow window) {
        super(component, driver, window);
    }

    public String getContent() {
        return new JSONArray(JComboBoxJavaElement.getContent((JComboBox)this.component)).toString();
    }

    public static String[][] getContent(JComboBox component) {
        int nOptions = component.getModel().getSize();
        String[][] content = new String[1][nOptions];
        for (int i = 0; i < nOptions; ++i) {
            content[0][i] = JComboBoxOptionJavaElement.getText(component, i, true);
        }
        return content;
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("nth-option")) {
            return Arrays.asList(new JComboBoxOptionJavaElement(this, (Integer)params[0] - 1));
        }
        if (selector.equals("all-options") || selector.equals("all-cells")) {
            return this.collectItems(new ArrayList<IJavaElement>(), new Predicate(){

                @Override
                public boolean isValid(JComboBoxOptionJavaElement e) {
                    return true;
                }
            });
        }
        return super.getByPseudoElement(selector, params);
    }

    private List<IJavaElement> collectItems(List<IJavaElement> r, Predicate p) {
        int nitems = this.getCount();
        for (int i = 0; i < nitems; ++i) {
            JComboBoxOptionJavaElement l = new JComboBoxOptionJavaElement(this, i);
            if (!p.isValid(l)) continue;
            r.add(l);
        }
        return r;
    }

    private int getCount() {
        try {
            return EventQueueWait.exec(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return ((JComboBox)JComboBoxJavaElement.this.getComponent()).getModel().getSize();
                }
            });
        }
        catch (Exception e) {
            throw new InternalError("Call to getSize() failed for JList#model");
        }
    }

    @Override
    public String _getText() {
        return JComboBoxJavaElement.getSelectedItemText((JComboBox)this.component);
    }

    public static String getSelectedItemText(JComboBox combo) {
        int selectedIndex = combo.getSelectedIndex();
        if (selectedIndex == -1) {
            return "";
        }
        return JComboBoxOptionJavaElement.getText(combo, selectedIndex, true);
    }

    @Override
    public boolean marathon_select(String value) {
        final String text = JComboBoxOptionJavaElement.stripHTMLTags(value);
        int selectedItem = this.findMatch(value, new Predicate(){

            @Override
            public boolean isValid(JComboBoxOptionJavaElement e) {
                return text.equals(e.getAttribute("text"));
            }
        });
        if (selectedItem == -1) {
            if (((JComboBox)this.getComponent()).isEditable()) {
                ((JTextField)((JComboBox)this.getComponent()).getEditor().getEditorComponent()).setText(value);
                return true;
            }
            return false;
        }
        ((JComboBox)this.getComponent()).setSelectedIndex(selectedItem);
        return true;
    }

    private int findMatch(String text, Predicate p) {
        int count = this.getCount();
        for (int item = 0; item < count; ++item) {
            if (!p.isValid(new JComboBoxOptionJavaElement(this, item))) continue;
            return item;
        }
        return -1;
    }

    private static interface Predicate {
        public boolean isValid(JComboBoxOptionJavaElement var1);
    }
}

