/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.components.JEditorPanePosJavaElement;
import net.sourceforge.marathon.javaagent.components.JEditorPaneTagJavaElement;
import net.sourceforge.marathon.javaagent.components.PropertyHelper;
import org.json.JSONObject;

public class JEditorPaneJavaElement
extends AbstractJavaElement {
    public static final Logger LOGGER = Logger.getLogger(JEditorPaneJavaElement.class.getName());
    private static final HTML.Tag[] allTags = new HTML.Tag[]{HTML.Tag.A, HTML.Tag.ADDRESS, HTML.Tag.APPLET, HTML.Tag.AREA, HTML.Tag.B, HTML.Tag.BASE, HTML.Tag.BASEFONT, HTML.Tag.BIG, HTML.Tag.BLOCKQUOTE, HTML.Tag.BODY, HTML.Tag.BR, HTML.Tag.CAPTION, HTML.Tag.CENTER, HTML.Tag.CITE, HTML.Tag.CODE, HTML.Tag.DD, HTML.Tag.DFN, HTML.Tag.DIR, HTML.Tag.DIV, HTML.Tag.DL, HTML.Tag.DT, HTML.Tag.EM, HTML.Tag.FONT, HTML.Tag.FORM, HTML.Tag.FRAME, HTML.Tag.FRAMESET, HTML.Tag.H1, HTML.Tag.H2, HTML.Tag.H3, HTML.Tag.H4, HTML.Tag.H5, HTML.Tag.H6, HTML.Tag.HEAD, HTML.Tag.HR, HTML.Tag.HTML, HTML.Tag.I, HTML.Tag.IMG, HTML.Tag.INPUT, HTML.Tag.ISINDEX, HTML.Tag.KBD, HTML.Tag.LI, HTML.Tag.LINK, HTML.Tag.MAP, HTML.Tag.MENU, HTML.Tag.META, HTML.Tag.NOFRAMES, HTML.Tag.OBJECT, HTML.Tag.OL, HTML.Tag.OPTION, HTML.Tag.P, HTML.Tag.PARAM, HTML.Tag.PRE, HTML.Tag.SAMP, HTML.Tag.SCRIPT, HTML.Tag.SELECT, HTML.Tag.SMALL, HTML.Tag.SPAN, HTML.Tag.STRIKE, HTML.Tag.S, HTML.Tag.STRONG, HTML.Tag.STYLE, HTML.Tag.SUB, HTML.Tag.SUP, HTML.Tag.TABLE, HTML.Tag.TD, HTML.Tag.TEXTAREA, HTML.Tag.TH, HTML.Tag.TITLE, HTML.Tag.TR, HTML.Tag.TT, HTML.Tag.U, HTML.Tag.UL, HTML.Tag.VAR};

    public JEditorPaneJavaElement(Component component, IJavaAgent driver, JavaTargetLocator.JWindow window) {
        super(component, driver, window);
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("tag")) {
            final ArrayList<IJavaElement> r = new ArrayList<IJavaElement>();
            if (!(((JEditorPane)this.getComponent()).getDocument() instanceof HTMLDocument)) {
                return r;
            }
            final HTML.Tag tag = this.findTag((String)params[0]);
            if (tag == null) {
                return r;
            }
            if (params.length == 1) {
                EventQueueWait.exec(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPaneJavaElement.this.fillElements(tag, r, new Predicate(){

                            @Override
                            public boolean isValid(JEditorPaneTagJavaElement e) {
                                return true;
                            }
                        });
                    }
                });
            } else {
                r.add(new JEditorPaneTagJavaElement(this, tag, (Integer)params[1] - 1));
            }
            return r;
        }
        if (selector.equals("select-by-properties")) {
            ArrayList<IJavaElement> r = new ArrayList<IJavaElement>();
            if (!(((JEditorPane)this.getComponent()).getDocument() instanceof HTMLDocument)) {
                return r;
            }
            JSONObject o = new JSONObject((String)params[0]);
            return this.selectByProperties(new ArrayList<IJavaElement>(), o);
        }
        throw new UnsupportedCommandException("JEditorPane does not support pseudoelement " + selector, null);
    }

    private List<IJavaElement> selectByProperties(final ArrayList<IJavaElement> r, JSONObject o) {
        Properties p;
        if (o.has("select")) {
            String spec = o.getString("select");
            if (!spec.startsWith("text=") && !spec.startsWith("link=")) {
                int pos = Integer.parseInt(spec);
                return Arrays.asList(new JEditorPanePosJavaElement(this, pos));
            }
            p = this.parseSelectProperties(spec);
        } else {
            p = PropertyHelper.asProperties(o);
        }
        EventQueueWait.exec(new Runnable(){

            @Override
            public void run() {
                JEditorPaneJavaElement.this.fillElements(HTML.Tag.A, r, new PropertyPredicate(p));
            }
        });
        return r;
    }

    private Properties parseSelectProperties(String spec) {
        Properties p = new Properties();
        String hRef = null;
        String text = null;
        int hRefIndex = 0;
        int textIndex = 0;
        boolean isText = false;
        if (spec.startsWith("text=")) {
            isText = true;
            text = spec = spec.substring(5);
        } else if (spec.startsWith("link=")) {
            isText = false;
            hRef = spec = spec.substring(5);
        } else {
            return p;
        }
        int lastIndexOf = spec.lastIndexOf(40);
        if (lastIndexOf != -1) {
            if (isText) {
                textIndex = Integer.parseInt(spec.substring(lastIndexOf + 1, spec.length() - 1));
                text = spec.substring(0, lastIndexOf);
            } else {
                hRefIndex = Integer.parseInt(spec.substring(lastIndexOf + 1, spec.length() - 1));
                hRef = spec.substring(0, lastIndexOf);
            }
        }
        if (text != null) {
            p.setProperty("text", text);
            p.setProperty("textIndex", textIndex + "");
        } else {
            p.setProperty("href", hRef);
            p.setProperty("hRefIndex", hRefIndex + "");
        }
        return p;
    }

    private void fillElements(HTML.Tag tag, ArrayList<IJavaElement> r, Predicate predicate) {
        HTMLDocument document = (HTMLDocument)((JEditorPane)this.getComponent()).getDocument();
        HTMLDocument.Iterator iterator = document.getIterator(tag);
        int index = 0;
        while (iterator.isValid()) {
            JEditorPaneTagJavaElement e;
            if (predicate.isValid(e = new JEditorPaneTagJavaElement(this, tag, index++))) {
                r.add(e);
            }
            iterator.next();
        }
    }

    private HTML.Tag findTag(String tagName) {
        for (HTML.Tag tag : allTags) {
            if (!tagName.toUpperCase().equals(tag.toString().toUpperCase())) continue;
            return tag;
        }
        return null;
    }

    private static interface Predicate {
        public boolean isValid(JEditorPaneTagJavaElement var1);
    }

    private static final class PropertyPredicate
    implements Predicate {
        private final Properties p;

        private PropertyPredicate(Properties p) {
            this.p = p;
        }

        @Override
        public boolean isValid(JEditorPaneTagJavaElement e) {
            Enumeration<Object> keys = this.p.keys();
            while (keys.hasMoreElements()) {
                String object = (String)keys.nextElement();
                if (this.p.getProperty(object).equals(e.getAttribute(object))) continue;
                return false;
            }
            return true;
        }
    }
}

