/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.InvalidElementStateException;
import net.sourceforge.marathon.javaagent.components.JEditorPaneJavaElement;

public class JEditorPanePosJavaElement
extends AbstractJavaElement {
    public static final Logger LOGGER = Logger.getLogger(JEditorPanePosJavaElement.class.getName());
    private int pos;
    private AbstractJavaElement parent;

    public JEditorPanePosJavaElement(JEditorPaneJavaElement parent, int pos) {
        super(parent);
        this.parent = parent;
        this.pos = pos;
    }

    @Override
    public Object _makeVisible() {
        JEditorPane editor = (JEditorPane)this.parent.getComponent();
        try {
            Rectangle bounds = editor.modelToView(this.pos);
            if (bounds != null) {
                bounds.height = editor.getVisibleRect().height;
                editor.scrollRectToVisible(bounds);
            }
        }
        catch (BadLocationException e) {
            throw new InvalidElementStateException("Invalid position " + this.pos + "(" + e.getMessage() + ")", e);
        }
        return null;
    }

    @Override
    public Point _getMidpoint() {
        JEditorPane editor = (JEditorPane)this.parent.getComponent();
        try {
            Rectangle bounds = editor.modelToView(this.pos);
            return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        }
        catch (BadLocationException e) {
            throw new InvalidElementStateException("Invalid position " + this.pos + "(" + e.getMessage() + ")", e);
        }
    }

    @Override
    public void _moveto() {
        JEditorPane editor = (JEditorPane)this.parent.getComponent();
        try {
            Rectangle bounds = editor.modelToView(this.pos);
            this.getDriver().getDevices().moveto(this.parent.getComponent(), bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        }
        catch (BadLocationException e) {
            throw new InvalidElementStateException("Invalid position " + this.pos + "(" + e.getMessage() + ")", e);
        }
    }
}

