/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.IPseudoElement;
import net.sourceforge.marathon.javaagent.InvalidElementStateException;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.components.JEditorPaneJavaElement;
import org.json.JSONArray;
import org.json.JSONObject;

public class JEditorPaneTagJavaElement
extends AbstractJavaElement
implements IPseudoElement {
    public static final Logger LOGGER = Logger.getLogger(JEditorPaneTagJavaElement.class.getName());
    private int index;
    private HTML.Tag tag;
    private JEditorPaneJavaElement parent;
    static final HTML.Attribute[] allAttributes = new HTML.Attribute[]{HTML.Attribute.FACE, HTML.Attribute.COMMENT, HTML.Attribute.SIZE, HTML.Attribute.COLOR, HTML.Attribute.CLEAR, HTML.Attribute.BACKGROUND, HTML.Attribute.BGCOLOR, HTML.Attribute.TEXT, HTML.Attribute.LINK, HTML.Attribute.VLINK, HTML.Attribute.ALINK, HTML.Attribute.WIDTH, HTML.Attribute.HEIGHT, HTML.Attribute.ALIGN, HTML.Attribute.NAME, HTML.Attribute.HREF, HTML.Attribute.REL, HTML.Attribute.REV, HTML.Attribute.TITLE, HTML.Attribute.TARGET, HTML.Attribute.SHAPE, HTML.Attribute.COORDS, HTML.Attribute.ISMAP, HTML.Attribute.NOHREF, HTML.Attribute.ALT, HTML.Attribute.ID, HTML.Attribute.SRC, HTML.Attribute.HSPACE, HTML.Attribute.VSPACE, HTML.Attribute.USEMAP, HTML.Attribute.LOWSRC, HTML.Attribute.CODEBASE, HTML.Attribute.CODE, HTML.Attribute.ARCHIVE, HTML.Attribute.VALUE, HTML.Attribute.VALUETYPE, HTML.Attribute.TYPE, HTML.Attribute.CLASS, HTML.Attribute.STYLE, HTML.Attribute.LANG, HTML.Attribute.DIR, HTML.Attribute.DECLARE, HTML.Attribute.CLASSID, HTML.Attribute.DATA, HTML.Attribute.CODETYPE, HTML.Attribute.STANDBY, HTML.Attribute.BORDER, HTML.Attribute.SHAPES, HTML.Attribute.NOSHADE, HTML.Attribute.COMPACT, HTML.Attribute.START, HTML.Attribute.ACTION, HTML.Attribute.METHOD, HTML.Attribute.ENCTYPE, HTML.Attribute.CHECKED, HTML.Attribute.MAXLENGTH, HTML.Attribute.MULTIPLE, HTML.Attribute.SELECTED, HTML.Attribute.ROWS, HTML.Attribute.COLS, HTML.Attribute.DUMMY, HTML.Attribute.CELLSPACING, HTML.Attribute.CELLPADDING, HTML.Attribute.VALIGN, HTML.Attribute.HALIGN, HTML.Attribute.NOWRAP, HTML.Attribute.ROWSPAN, HTML.Attribute.COLSPAN, HTML.Attribute.PROMPT, HTML.Attribute.HTTPEQUIV, HTML.Attribute.CONTENT, HTML.Attribute.LANGUAGE, HTML.Attribute.VERSION, HTML.Attribute.N, HTML.Attribute.FRAMEBORDER, HTML.Attribute.MARGINWIDTH, HTML.Attribute.MARGINHEIGHT, HTML.Attribute.SCROLLING, HTML.Attribute.NORESIZE, HTML.Attribute.ENDTAG};

    public JEditorPaneTagJavaElement(JEditorPaneJavaElement parent, HTML.Tag tag, int index) {
        super(parent);
        this.parent = parent;
        this.tag = tag;
        this.index = index;
    }

    @Override
    public String _getText() {
        HTMLDocument.Iterator iterator = this.findTag((HTMLDocument)((JEditorPane)this.parent.getComponent()).getDocument());
        int startOffset = iterator.getStartOffset();
        int endOffset = iterator.getEndOffset();
        try {
            return ((HTMLDocument)((JEditorPane)this.parent.getComponent()).getDocument()).getText(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException e) {
            throw new InvalidElementStateException("Unable to get text for tag " + this.tag + " in document with index " + this.index, e);
        }
    }

    private HTMLDocument.Iterator findTag(HTMLDocument doc) {
        HTMLDocument.Iterator iterator = doc.getIterator(this.tag);
        int current = 0;
        while (iterator.isValid() && current++ != this.index) {
            iterator.next();
        }
        if (!iterator.isValid()) {
            throw new NoSuchElementException("Unable to find tag " + this.tag + " in document with index " + this.index, null);
        }
        return iterator;
    }

    @Override
    public IJavaElement getParent() {
        return this.parent;
    }

    @Override
    public String createHandle() {
        JSONObject o = new JSONObject().put("selector", "tag").put("parameters", new JSONArray().put(this.tag.toString()).put(this.index + 1));
        return this.parent.getHandle() + "#" + o.toString();
    }

    @Override
    public String getAttribute(final String name) {
        if ("text".equals(name)) {
            return this.getText();
        }
        if ("hRefIndex".equals(name)) {
            return this.getHRefIndex() + "";
        }
        if ("textIndex".equals(name)) {
            return this.getTextIndex() + "";
        }
        return EventQueueWait.exec(new Callable<String>(){

            @Override
            public String call() throws Exception {
                HTMLDocument.Iterator iterator = JEditorPaneTagJavaElement.this.findTag((HTMLDocument)((JEditorPane)JEditorPaneTagJavaElement.this.parent.getComponent()).getDocument());
                AttributeSet attributes = iterator.getAttributes();
                HTML.Attribute attr = JEditorPaneTagJavaElement.this.findAttribute(name);
                if (attr != null && attributes.isDefined(attr)) {
                    return attributes.getAttribute(attr).toString();
                }
                return null;
            }
        });
    }

    @Override
    public Object _makeVisible() {
        JEditorPane editor = (JEditorPane)this.parent.getComponent();
        HTMLDocument.Iterator iterator = this.findTag((HTMLDocument)editor.getDocument());
        int startOffset = iterator.getStartOffset();
        int endOffset = iterator.getEndOffset();
        try {
            Rectangle bounds = editor.modelToView(startOffset + (endOffset - startOffset) / 2);
            if (bounds != null) {
                bounds.height = editor.getVisibleRect().height;
                editor.scrollRectToVisible(bounds);
            }
        }
        catch (BadLocationException e) {
            throw new InvalidElementStateException("Unable to get text for tag " + this.tag + " in document with index " + this.index, e);
        }
        return null;
    }

    @Override
    public void _moveto() {
        JEditorPane editor = (JEditorPane)this.parent.getComponent();
        HTMLDocument.Iterator iterator = this.findTag((HTMLDocument)editor.getDocument());
        int startOffset = iterator.getStartOffset();
        int endOffset = iterator.getEndOffset();
        try {
            Rectangle bounds = editor.modelToView(startOffset + (endOffset - startOffset) / 2);
            this.getDriver().getDevices().moveto(this.parent.getComponent(), bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        }
        catch (BadLocationException e) {
            throw new InvalidElementStateException("Unable to get text for tag " + this.tag + " in document with index " + this.index, e);
        }
    }

    @Override
    public boolean _isEnabled() {
        return true;
    }

    @Override
    public Component getPseudoComponent() {
        throw new RuntimeException("No physical pseudo component available for JEditorPane tag items");
    }

    private HTML.Attribute findAttribute(String attrName) {
        for (HTML.Attribute attr : allAttributes) {
            if (!attrName.toUpperCase().equals(attr.toString().toUpperCase())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public Point _getMidpoint() {
        JEditorPane editor = (JEditorPane)this.parent.getComponent();
        HTMLDocument.Iterator iterator = this.findTag((HTMLDocument)editor.getDocument());
        int startOffset = iterator.getStartOffset();
        int endOffset = iterator.getEndOffset();
        try {
            Rectangle bounds = editor.modelToView(startOffset + (endOffset - startOffset) / 2);
            return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        }
        catch (BadLocationException e) {
            throw new InvalidElementStateException("Unable to get text for tag " + this.tag + " in document with index " + this.index + "(StartOffset: " + startOffset + " EndOffset: " + endOffset + ")", e);
        }
    }

    public int getHRefIndex() {
        return EventQueueWait.exec(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                String href = JEditorPaneTagJavaElement.this.getAttribute("href");
                int hRefIndex = 0;
                int current = 0;
                JEditorPane editor = (JEditorPane)JEditorPaneTagJavaElement.this.parent.getComponent();
                HTMLDocument document = (HTMLDocument)editor.getDocument();
                HTMLDocument.Iterator iterator = document.getIterator(HTML.Tag.A);
                while (iterator.isValid()) {
                    String attribute;
                    Object attributeObject;
                    if (current++ >= JEditorPaneTagJavaElement.this.index) {
                        return hRefIndex;
                    }
                    AttributeSet attributes = iterator.getAttributes();
                    if (attributes != null && (attributeObject = attributes.getAttribute(HTML.Attribute.HREF)) != null && (attribute = attributeObject.toString()).equals(href)) {
                        ++hRefIndex;
                    }
                    iterator.next();
                }
                return -1;
            }
        });
    }

    public int getTextIndex() {
        return EventQueueWait.exec(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                String href = JEditorPaneTagJavaElement.this.getText();
                int hRefIndex = 0;
                int current = 0;
                JEditorPane editor = (JEditorPane)JEditorPaneTagJavaElement.this.parent.getComponent();
                HTMLDocument document = (HTMLDocument)editor.getDocument();
                HTMLDocument.Iterator iterator = document.getIterator(HTML.Tag.A);
                while (iterator.isValid()) {
                    if (current++ >= JEditorPaneTagJavaElement.this.index) {
                        return hRefIndex;
                    }
                    String attribute = ((HTMLDocument)((JEditorPane)JEditorPaneTagJavaElement.this.parent.getComponent()).getDocument()).getText(iterator.getStartOffset(), iterator.getEndOffset() - iterator.getStartOffset());
                    if (attribute != null && attribute.equals(href)) {
                        ++hRefIndex;
                    }
                    iterator.next();
                }
                return -1;
            }
        });
    }
}

