/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IPseudoElement;
import net.sourceforge.marathon.javaagent.JavaElementPropertyAccessor;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.components.JListJavaElement;
import org.json.JSONArray;
import org.json.JSONObject;

public class JListItemJavaElement
extends AbstractJavaElement
implements IPseudoElement {
    public static final Logger LOGGER = Logger.getLogger(JListItemJavaElement.class.getName());
    private int item;
    private JListJavaElement parent;
    private static final int MAX_LIST_ITEMS = Integer.parseInt(System.getProperty("marathon.duplicate.check.max", "100"));

    public JListItemJavaElement(JListJavaElement parent, int item) {
        super(parent);
        this.parent = parent;
        this.item = item;
    }

    private void validateItem() {
        if (this.item >= ((JList)this.parent.getComponent()).getModel().getSize()) {
            throw new NoSuchElementException("Index out of bounds error on JList: " + this.item, null);
        }
    }

    @Override
    public String createHandle() {
        JSONObject o = new JSONObject().put("selector", "nth-item").put("parameters", new JSONArray().put(this.item + 1));
        return this.parent.getHandle() + "#" + o.toString();
    }

    @Override
    public JListJavaElement getParent() {
        return this.parent;
    }

    @Override
    public void _moveto() {
        this.validateItem();
        Rectangle bounds = this.getCellBounds();
        this.getDriver().getDevices().moveto(this.parent.getComponent(), bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    private Rectangle getCellBounds() {
        return ((JList)this.parent.getComponent()).getCellBounds(this.item, this.item);
    }

    @Override
    public boolean _isDisplayed() {
        JList list = (JList)this.parent.getComponent();
        return this.item <= list.getLastVisibleIndex() && this.item >= list.getFirstVisibleIndex();
    }

    @Override
    public Component getPseudoComponent() {
        return EventQueueWait.exec(new Callable<Component>(){

            @Override
            public Component call() throws Exception {
                JListItemJavaElement.this.validateItem();
                JList list = (JList)JListItemJavaElement.this.parent.getComponent();
                return JListItemJavaElement.getRendererComponent(list, JListItemJavaElement.this.item);
            }
        });
    }

    public static Component getRendererComponent(JList list, int item) {
        Object value = list.getModel().getElementAt(item);
        ListCellRenderer cellRenderer = list.getCellRenderer();
        Component rendererComponent = cellRenderer.getListCellRendererComponent(list, value, item, false, false);
        if (rendererComponent == null) {
            return null;
        }
        return rendererComponent;
    }

    public int getIndex() {
        return this.item;
    }

    @Override
    public Point _getMidpoint() {
        this.validateItem();
        Rectangle bounds = this.getCellBounds();
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    @Override
    public String _getText() {
        return JListItemJavaElement.getText((JList)this.component, this.item);
    }

    public static String getText(JList list, int index) {
        String original;
        String itemText = original = JListItemJavaElement.getItemText(list, index);
        int suffixIndex = 0;
        if (list.getModel().getSize() > MAX_LIST_ITEMS) {
            return itemText;
        }
        for (int i = 0; i < index; ++i) {
            String current = JListItemJavaElement.getItemText(list, i);
            if (!current.equals(original)) continue;
            itemText = String.format("%s(%d)", original, ++suffixIndex);
        }
        return itemText;
    }

    protected static String getItemText(JList listItem, int index) {
        Component renComponent = JListItemJavaElement.getRendererComponent(listItem, index);
        JavaElementPropertyAccessor pa = new JavaElementPropertyAccessor(renComponent);
        return pa.getText();
    }
}

