/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JList;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.components.JListItemJavaElement;
import net.sourceforge.marathon.javaagent.components.PropertyHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public class JListJavaElement
extends AbstractJavaElement {
    public static final Logger LOGGER = Logger.getLogger(JListJavaElement.class.getName());

    public JListJavaElement(Component component, IJavaAgent driver, JavaTargetLocator.JWindow window) {
        super(component, driver, window);
    }

    public String getContent() {
        return new JSONArray(JListJavaElement.getContent((JList)this.component)).toString();
    }

    public static String[][] getContent(JList component) {
        int nItems = component.getModel().getSize();
        String[][] content = new String[1][nItems];
        for (int i = 0; i < nItems; ++i) {
            content[0][i] = JListItemJavaElement.getText(component, i);
        }
        return content;
    }

    @Override
    public String _getText() {
        return JListJavaElement.getSelectionText((JList)this.component);
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("nth-item")) {
            return Arrays.asList(new JListItemJavaElement(this, (Integer)params[0] - 1));
        }
        if (selector.equals("all-items") || selector.equals("all-cells")) {
            return this.collectItems(new ArrayList<IJavaElement>(), new Predicate(){

                @Override
                public boolean isValid(JListItemJavaElement e) {
                    return true;
                }
            });
        }
        if (selector.equals("select-by-properties")) {
            return this.findItemByProperties(new JSONObject((String)params[0]));
        }
        return super.getByPseudoElement(selector, params);
    }

    private List<IJavaElement> findItemByProperties(JSONObject o) {
        if (!o.has("select")) {
            return Collections.emptyList();
        }
        final String item = o.getString("select");
        ArrayList<IJavaElement> r = new ArrayList<IJavaElement>();
        return this.collectItems(r, new Predicate(){

            @Override
            public boolean isValid(JListItemJavaElement e) {
                return item.equals(e._getText());
            }
        });
    }

    public List<IJavaElement> collectItems(List<IJavaElement> r, Predicate p) {
        int nitems = this.getCount();
        for (int i = 0; i < nitems; ++i) {
            JListItemJavaElement l = new JListItemJavaElement(this, i);
            if (!p.isValid(l)) continue;
            r.add(l);
        }
        return r;
    }

    public int getCount() {
        try {
            return EventQueueWait.exec(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return ((JList)JListJavaElement.this.getComponent()).getModel().getSize();
                }
            });
        }
        catch (Exception e) {
            throw new InternalError("Call to getSize() failed for JList#model");
        }
    }

    @Override
    public boolean marathon_select(JSONArray jsonArray) {
        Properties[] pa = new Properties[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            pa[i] = PropertyHelper.asProperties(jsonArray.getJSONObject(i));
        }
        return this.setItemSelection(pa);
    }

    @Override
    public boolean marathon_select(String value) {
        Properties[] pa = PropertyHelper.fromStringToArray(value, new String[][]{{"text"}});
        return this.setItemSelection(pa);
    }

    private boolean setItemSelection(Properties[] pa) {
        ArrayList<IJavaElement> r = new ArrayList<IJavaElement>();
        for (final Properties properties : pa) {
            this.collectItems(r, new Predicate(){

                @Override
                public boolean isValid(JListItemJavaElement e) {
                    Set<Object> keySet = properties.keySet();
                    for (Object object : keySet) {
                        if (properties.getProperty(object.toString()).equals(e.getAttribute(object.toString()))) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        if (r.size() != pa.length) {
            return false;
        }
        int[] indices = new int[r.size()];
        int index = 0;
        for (IJavaElement je : r) {
            indices[index++] = ((JListItemJavaElement)je).getIndex();
        }
        ((JList)this.component).setSelectedIndices(indices);
        return true;
    }

    public static String getSelectionText(JList list) {
        int[] selectedIndices;
        ArrayList<Properties> pa = new ArrayList<Properties>();
        for (int index : selectedIndices = list.getSelectedIndices()) {
            Properties p = new Properties();
            p.setProperty("listText", JListItemJavaElement.getText(list, index));
            pa.add(p);
        }
        return PropertyHelper.toString(pa.toArray(new Properties[pa.size()]), new String[]{"listText"});
    }

    public static int getIndexAt(JList list, Point point) {
        if (point == null) {
            return list.getSelectedIndex();
        }
        return list.locationToIndex(point);
    }

    private static interface Predicate {
        public boolean isValid(JListItemJavaElement var1);
    }
}

