/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaAgentException;
import net.sourceforge.marathon.javaagent.JavaElementFactory;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;

public class JMenuItemJavaElement
extends AbstractJavaElement {
    public static final Logger LOGGER = Logger.getLogger(JMenuItemJavaElement.class.getName());

    public JMenuItemJavaElement(Component component, IJavaAgent driver, JavaTargetLocator.JWindow window) {
        super(component, driver, window);
    }

    @Override
    public boolean marathon_select(String value) {
        if (value != null && !"".equals(value)) {
            return this.setSelectedPath(value.split("\\>\\>"));
        }
        return true;
    }

    private boolean setSelectedPath(String[] items) {
        if (items.length == 1) {
            this.click();
            return true;
        }
        if (this.component instanceof JMenu) {
            if (!((JMenu)this.component).isPopupMenuVisible()) {
                this.click();
                return false;
            }
        } else {
            throw new JavaAgentException("Component is not a JMenu", null);
        }
        Component current = this.component;
        for (int i = 1; i < items.length; ++i) {
            if ((current = this.findMenuElement(current, items[i])) == null) {
                return false;
            }
            if (current instanceof JMenu) {
                if (((JMenu)current).isPopupMenuVisible()) continue;
                JavaElementFactory.createElement(current, this.driver, this.window).click();
                return false;
            }
            if (i != items.length - 1) {
                throw new JavaAgentException("A Jmenuitem found in the middle of menu path?", null);
            }
            JavaElementFactory.createElement(current, this.driver, this.window).click();
        }
        return true;
    }

    private Component findMenuElement(Component parent, String text) {
        if (parent instanceof JMenu) {
            Component[] components;
            for (Component component : components = ((JMenu)parent).getMenuComponents()) {
                IJavaElement ije = JavaElementFactory.createElement(component, this.driver, this.window);
                if (!text.equals(JMenuItemJavaElement.getText(ije.getText(), component, components))) continue;
                return component;
            }
        } else {
            throw new JavaAgentException("Can't find menu elements from a menuitem that is not a menu", null);
        }
        return null;
    }

    public static String getText(String original, Component current, Component[] components) {
        String itemText = original;
        int suffixIndex = 0;
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == current) {
                return itemText;
            }
            if (!(components[i] instanceof AbstractButton)) continue;
            AbstractButton menuItem = (AbstractButton)components[i];
            String menuItemText = menuItem.getText();
            if ("".equals(menuItemText) || menuItemText == null) {
                menuItemText = JMenuItemJavaElement.getTextFromIcon((JMenuItem)components[i]);
            }
            if (!menuItemText.equals(original)) continue;
            itemText = String.format("%s(%d)", original, ++suffixIndex);
        }
        return itemText;
    }

    @Override
    public String _getText() {
        JMenuItem current = (JMenuItem)this.component;
        return JMenuItemJavaElement.getItemText(current);
    }

    public static String getItemText(JMenuItem current) {
        String text = current.getText();
        if (text == null || "".equals(text)) {
            return JMenuItemJavaElement.getTextFromIcon(current);
        }
        return text;
    }

    private static String getTextFromIcon(JMenuItem mi) {
        Icon icon = mi.getIcon();
        if (icon != null && icon instanceof ImageIcon) {
            String description = ((ImageIcon)icon).getDescription();
            return JMenuItemJavaElement.getNameFromImageDescription(description);
        }
        return null;
    }

    private static String getNameFromImageDescription(String description) {
        try {
            String name = new URL(description).getPath();
            if (name.lastIndexOf(47) != -1) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            if (name.lastIndexOf(46) != -1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            return name;
        }
        catch (MalformedURLException e) {
            return description;
        }
    }
}

