/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaAgentException;
import net.sourceforge.marathon.javaagent.JavaElementFactory;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;

public class JSpinnerJavaElement
extends AbstractJavaElement {
    public static final Logger LOGGER = Logger.getLogger(JSpinnerJavaElement.class.getName());

    public JSpinnerJavaElement(Component component, IJavaAgent driver, JavaTargetLocator.JWindow window) {
        super(component, driver, window);
    }

    @Override
    public boolean marathon_select(String value) {
        JComponent spinnerEditor = ((JSpinner)this.component).getEditor();
        if (spinnerEditor == null) {
            throw new JavaAgentException("Null value returned by getEditor() on spinner", null);
        }
        IJavaElement ele = JavaElementFactory.createElement(spinnerEditor, this.driver, this.window);
        ele.marathon_select(value);
        try {
            ((JSpinner)this.component).commitEdit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("editor")) {
            return Arrays.asList(JavaElementFactory.createElement(this.getEditor(), this.getDriver(), this.getWindow()));
        }
        return super.getByPseudoElement(selector, params);
    }

    @Override
    public String _getText() {
        IJavaElement editor = JavaElementFactory.createElement(this.getEditor(), this.getDriver(), this.getWindow());
        return editor.getText();
    }

    private Component getEditor() {
        JComponent editorComponent = ((JSpinner)this.component).getEditor();
        if (editorComponent == null) {
            throw new JavaAgentException("Null value returned by getEditor() on spinner", null);
        }
        if (editorComponent instanceof JSpinner.DefaultEditor) {
            editorComponent = ((JSpinner.DefaultEditor)editorComponent).getTextField();
        }
        return editorComponent;
    }
}

