/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.components.JTabbedPaneTabJavaElement;
import org.json.JSONArray;
import org.json.JSONObject;

public class JTabbedPaneJavaElement
extends AbstractJavaElement {
    public static final Logger LOGGER = Logger.getLogger(JTabbedPaneJavaElement.class.getName());

    public JTabbedPaneJavaElement(Component component, IJavaAgent driver, JavaTargetLocator.JWindow window) {
        super(component, driver, window);
    }

    @Override
    public String _getText() {
        return JTabbedPaneJavaElement.getSelectedItemText((JTabbedPane)this.component);
    }

    public static String getSelectedItemText(JTabbedPane component) {
        int selectedIndex = component.getSelectedIndex();
        if (selectedIndex != -1) {
            return JTabbedPaneTabJavaElement.getText(component, selectedIndex);
        }
        return "";
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("nth-tab")) {
            int tabIndex = (Integer)params[0] - 1;
            return Arrays.asList(new JTabbedPaneTabJavaElement(this, tabIndex));
        }
        if (selector.equals("all-tabs")) {
            int nitems = this.getCount();
            ArrayList<IJavaElement> r = new ArrayList<IJavaElement>();
            for (int i = 0; i < nitems; ++i) {
                r.add(new JTabbedPaneTabJavaElement(this, i));
            }
            return r;
        }
        if (selector.equals("selected-tab")) {
            int tabIndex = ((JTabbedPane)this.component).getSelectedIndex();
            if (tabIndex != -1) {
                return Arrays.asList(new JTabbedPaneTabJavaElement(this, tabIndex));
            }
            return Arrays.asList(new IJavaElement[0]);
        }
        if (selector.equals("select-by-properties")) {
            return this.findNodeByProperties(new JSONObject((String)params[0]));
        }
        return super.getByPseudoElement(selector, params);
    }

    private List<IJavaElement> findNodeByProperties(JSONObject o) {
        if (!o.has("select")) {
            return Collections.emptyList();
        }
        String tab = o.getString("select");
        int tabIndex = this.findTabIndex((JTabbedPane)this.component, tab);
        if (tabIndex != -1) {
            return Arrays.asList(new JTabbedPaneTabJavaElement(this, tabIndex));
        }
        return Collections.emptyList();
    }

    private int getCount() {
        try {
            return EventQueueWait.exec(new Callable<Integer>(){

                @Override
                public Integer call() {
                    JTabbedPane pane = (JTabbedPane)JTabbedPaneJavaElement.this.getComponent();
                    return pane.getTabCount();
                }
            });
        }
        catch (Exception e) {
            throw new InternalError("Call to getTabCount() failed for JTabbedPane#getTabCount");
        }
    }

    @Override
    public boolean marathon_select(String tab) {
        int tabIndex = this.findTabIndex((JTabbedPane)this.component, tab);
        if (tabIndex != -1) {
            ((JTabbedPane)this.component).setSelectedIndex(tabIndex);
        }
        return tabIndex != -1;
    }

    private int findTabIndex(JTabbedPane tp, String tab) {
        int tabCount = tp.getTabCount();
        int tabIndex = -1;
        for (int index = 0; index < tabCount; ++index) {
            String current = JTabbedPaneTabJavaElement.getText(tp, index);
            if (!tab.equals(current)) continue;
            tabIndex = index;
            break;
        }
        return tabIndex;
    }

    public String getContent() {
        return new JSONArray(JTabbedPaneJavaElement.getContent((JTabbedPane)this.component)).toString();
    }

    public static String[][] getContent(JTabbedPane component) {
        int nItems = component.getTabCount();
        String[][] content = new String[1][nItems];
        for (int i = 0; i < nItems; ++i) {
            content[0][i] = JTabbedPaneTabJavaElement.getText(component, i);
        }
        return content;
    }
}

