/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.IPseudoElement;
import net.sourceforge.marathon.javaagent.InvalidElementStateException;
import net.sourceforge.marathon.javaagent.JavaElementFactory;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.components.JTabbedPaneJavaElement;
import org.json.JSONArray;
import org.json.JSONObject;

public class JTabbedPaneTabJavaElement
extends AbstractJavaElement
implements IPseudoElement {
    public static final Logger LOGGER = Logger.getLogger(JTabbedPaneTabJavaElement.class.getName());
    private int tabIndex;
    private JTabbedPaneJavaElement parent;

    public JTabbedPaneTabJavaElement(JTabbedPaneJavaElement parent, int tabIndex) {
        super(parent);
        this.parent = parent;
        this.tabIndex = tabIndex;
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("component")) {
            return Arrays.asList(JavaElementFactory.createElement(this.getTabComponent(this.tabIndex), this.getDriver(), this.getWindow()));
        }
        if (selector.equals("tab-component")) {
            Component tc = this.getTabTabComponent(this.tabIndex);
            if (tc != null) {
                return Arrays.asList(JavaElementFactory.createElement(tc, this.getDriver(), this.getWindow()));
            }
            return Arrays.asList(new IJavaElement[0]);
        }
        throw new UnsupportedCommandException("JTabbedPane does not support pseudoelement " + selector, null);
    }

    private Component getTabComponent(final int tabIndex) {
        this.validateTab();
        return EventQueueWait.exec(new Callable<Component>(){

            @Override
            public Component call() throws Exception {
                return ((JTabbedPane)JTabbedPaneTabJavaElement.this.getComponent()).getComponentAt(tabIndex);
            }
        });
    }

    private Component getTabTabComponent(final int tabIndex) {
        this.validateTab();
        return EventQueueWait.exec(new Callable<Component>(){

            @Override
            public Component call() throws Exception {
                return ((JTabbedPane)JTabbedPaneTabJavaElement.this.getComponent()).getTabComponentAt(tabIndex);
            }
        });
    }

    @Override
    public String createHandle() {
        JSONObject o = new JSONObject().put("selector", "nth-tab").put("parameters", new JSONArray().put(this.tabIndex + 1));
        return this.parent.getHandle() + "#" + o.toString();
    }

    @Override
    public String _getText() {
        return JTabbedPaneTabJavaElement.getText((JTabbedPane)this.parent.getComponent(), this.tabIndex);
    }

    public static String getText(JTabbedPane tabbedPane, int index) {
        String original;
        String itemText = original = JTabbedPaneTabJavaElement.getItemText(tabbedPane, index);
        int suffixIndex = 0;
        for (int i = 0; i < index; ++i) {
            String current = JTabbedPaneTabJavaElement.getItemText(tabbedPane, i);
            if (!current.equals(original)) continue;
            itemText = String.format("%s(%d)", original, ++suffixIndex);
        }
        return itemText;
    }

    protected static String getItemText(JTabbedPane tabbedPane, int index) {
        String titleAt = tabbedPane.getTitleAt(index);
        if (titleAt == null || "".equals(titleAt)) {
            return JTabbedPaneTabJavaElement.getTabNameFromIcon(tabbedPane, index);
        }
        return titleAt;
    }

    private static String getTabNameFromIcon(JTabbedPane tp, int index) {
        Icon iconAt = tp.getIconAt(index);
        if (iconAt == null || !(iconAt instanceof ImageIcon) || ((ImageIcon)iconAt).getDescription() == null) {
            return "tabIndex-" + index;
        }
        String description = ((ImageIcon)iconAt).getDescription();
        return JTabbedPaneTabJavaElement.nameFromImageDescription(description);
    }

    private static String nameFromImageDescription(String description) {
        try {
            String name = new URL(description).getPath();
            if (name.lastIndexOf(47) != -1) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            if (name.lastIndexOf(46) != -1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            return name;
        }
        catch (MalformedURLException e) {
            return description;
        }
    }

    @Override
    public IJavaElement getParent() {
        return this.parent;
    }

    @Override
    public void _moveto() {
        Rectangle bounds = this.getTabBounds();
        this.getDriver().getDevices().moveto(this.parent.getComponent(), bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    private Rectangle getTabBounds() {
        return ((JTabbedPane)this.parent.getComponent()).getBoundsAt(this.tabIndex);
    }

    private boolean makeTabVisible(JTabbedPane tp, int selectedTab) {
        int n;
        this.validateTab();
        if (!(tp.getUI() instanceof BasicTabbedPaneUI)) {
            try {
                EventQueueWait.call(tp, "setSelectedIndex", selectedTab);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidElementStateException("Unable to call setSelectedIndex on JTabbedPane. selectedTab = " + selectedTab, e);
            }
            return true;
        }
        boolean isVisible = false;
        int loopCount = n = tp.getTabCount();
        Action backward = tp.getActionMap().get("scrollTabsBackwardAction");
        Action forward = tp.getActionMap().get("scrollTabsForwardAction");
        while (!isVisible && loopCount-- > 0) {
            int firstVisibleTab = -1;
            int lastVisibleTab = -1;
            for (int i = 0; i < n; ++i) {
                Rectangle tabBounds = tp.getBoundsAt(i);
                int tabForCoordinate = tp.getUI().tabForCoordinate(tp, tabBounds.x + tabBounds.width / 2, tabBounds.y + tabBounds.height / 2);
                if (tabForCoordinate == -1) continue;
                if (firstVisibleTab == -1) {
                    firstVisibleTab = tabForCoordinate;
                }
                lastVisibleTab = tabForCoordinate;
            }
            isVisible = firstVisibleTab <= selectedTab && selectedTab <= lastVisibleTab;
            if (isVisible) continue;
            if (selectedTab < firstVisibleTab) {
                backward.actionPerformed(new ActionEvent(tp, 1001, ""));
                continue;
            }
            forward.actionPerformed(new ActionEvent(tp, 1001, ""));
        }
        return isVisible;
    }

    @Override
    public boolean _isDisplayed() {
        Rectangle bounds = ((JTabbedPane)this.parent.getComponent()).getBoundsAt(this.tabIndex);
        return bounds != null && SwingUtilities.isRectangleContainingRectangle(((JTabbedPane)this.parent.getComponent()).getVisibleRect(), bounds);
    }

    @Override
    public boolean _isEnabled() {
        return ((JTabbedPane)this.parent.getComponent()).isEnabledAt(this.tabIndex);
    }

    @Override
    public Component getPseudoComponent() {
        throw new RuntimeException("No physical pseudo component available for JTabbedPane's tab items");
    }

    private void validateTab() {
        EventQueueWait.exec(new Runnable(){

            @Override
            public void run() {
                JTabbedPane pane = (JTabbedPane)JTabbedPaneTabJavaElement.this.parent.getComponent();
                int tabCount = pane.getTabCount();
                if (JTabbedPaneTabJavaElement.this.tabIndex < 0 || JTabbedPaneTabJavaElement.this.tabIndex >= tabCount) {
                    throw new NoSuchElementException("Invalid tab index for JTabbedPane: " + JTabbedPaneTabJavaElement.this.tabIndex, null);
                }
            }
        });
    }

    @Override
    public Object _makeVisible() {
        this.makeTabVisible((JTabbedPane)this.parent.getComponent(), this.tabIndex);
        return null;
    }

    @Override
    public Point _getMidpoint() {
        if (!this.isDisplayed()) {
            throw new InvalidElementStateException("The tabitem " + (this.tabIndex + 1) + " is not visible", null);
        }
        Rectangle bounds = this.getTabBounds();
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }
}

