/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.IPseudoElement;
import net.sourceforge.marathon.javaagent.JavaElementFactory;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.components.JTableJavaElement;
import org.json.JSONArray;
import org.json.JSONObject;

public class JTableCellJavaElement
extends AbstractJavaElement
implements IPseudoElement {
    public static final Logger LOGGER = Logger.getLogger(JTableCellJavaElement.class.getName());
    private JTableJavaElement parent;
    private int viewRow;
    private int viewCol;

    public JTableCellJavaElement(JTableJavaElement parent, int row, int col) {
        super(parent);
        this.parent = parent;
        this.viewRow = row;
        this.viewCol = col;
    }

    @Override
    public String createHandle() {
        JSONObject o = new JSONObject().put("selector", "mnth-cell").put("parameters", new JSONArray().put(this.viewRow + 1).put(this.viewCol + 1));
        return this.parent.getHandle() + "#" + o.toString();
    }

    @Override
    public IJavaElement getParent() {
        return this.parent;
    }

    @Override
    public Component getPseudoComponent() {
        return EventQueueWait.exec(new Callable<Component>(){

            @Override
            public Component call() throws Exception {
                JTableCellJavaElement.this.validateRowCol();
                JTable table = (JTable)JTableCellJavaElement.this.parent.getComponent();
                int row = table.convertRowIndexToModel(JTableCellJavaElement.this.viewRow);
                int col = table.convertColumnIndexToModel(JTableCellJavaElement.this.viewCol);
                TableCellRenderer cellRenderer = table.getCellRenderer(JTableCellJavaElement.this.viewRow, JTableCellJavaElement.this.viewCol);
                Object value = table.getModel().getValueAt(row, col);
                return cellRenderer.getTableCellRendererComponent(table, value, false, false, JTableCellJavaElement.this.viewRow, JTableCellJavaElement.this.viewCol);
            }
        });
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("editor")) {
            return Arrays.asList(JavaElementFactory.createElement(this.parent.getEditor(this.viewRow, this.viewCol), this.getDriver(), this.getWindow()));
        }
        throw new UnsupportedCommandException("JTableCell Java Element does not support pseudoelement " + selector, null);
    }

    private void validateRowCol() {
        JTable table = (JTable)this.parent.getComponent();
        try {
            int row = table.convertRowIndexToModel(this.viewRow);
            int col = table.convertColumnIndexToModel(this.viewCol);
            TableModel model = table.getModel();
            if (row >= 0 && row < model.getRowCount() && col >= 0 && col < model.getColumnCount()) {
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new NoSuchElementException("Invalid row/col for JTable: (" + this.viewRow + ", " + this.viewCol + ")", null);
    }

    @Override
    public void _moveto() {
        this.validateRowCol();
        Rectangle bounds = this.getCellBounds();
        this.getDriver().getDevices().moveto(this.parent.getComponent(), bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    private Rectangle getCellBounds() {
        return ((JTable)this.parent.getComponent()).getCellRect(this.viewRow, this.viewCol, false);
    }

    @Override
    public boolean _isDisplayed() {
        return EventQueueWait.exec(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return JTableCellJavaElement.this.isVisible((JTable)JTableCellJavaElement.this.parent.getComponent(), JTableCellJavaElement.this.viewRow, JTableCellJavaElement.this.viewCol);
            }
        });
    }

    private boolean isVisible(JTable table, int row, int col) {
        Rectangle visibleRect = table.getVisibleRect();
        Rectangle cellRect = table.getCellRect(row, col, false);
        return SwingUtilities.isRectangleContainingRectangle(visibleRect, cellRect);
    }

    @Override
    public Point _getMidpoint() {
        this.validateRowCol();
        Rectangle bounds = this.getCellBounds();
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    public int getViewRow() {
        return this.viewRow + 1;
    }

    public int getViewColumn() {
        return this.viewCol + 1;
    }

    public String getViewColumnName() {
        String columnName = this.getColumnName(this.viewCol);
        if (columnName == null) {
            return "" + (this.viewCol + 1);
        }
        return columnName;
    }

    public int getRow() {
        return this.viewRow;
    }

    public String getColumn() {
        String columnName = this.getColumnName(this.viewCol);
        if (columnName == null) {
            return "" + this.viewCol;
        }
        return columnName;
    }

    public int getCol() {
        return this.viewCol;
    }
}

