/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.IPseudoElement;
import net.sourceforge.marathon.javaagent.JavaElementPropertyAccessor;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.components.JTableHeaderJavaElement;
import org.json.JSONArray;
import org.json.JSONObject;

public class JTableHeaderItemJavaElement
extends AbstractJavaElement
implements IPseudoElement {
    public static final Logger LOGGER = Logger.getLogger(JTableHeaderItemJavaElement.class.getName());
    private JTableHeaderJavaElement parent;
    private int item;

    public JTableHeaderItemJavaElement(JTableHeaderJavaElement parent, int item) {
        super(parent);
        this.parent = parent;
        this.item = item;
    }

    @Override
    public String createHandle() {
        JSONObject o = new JSONObject().put("selector", "nth-item").put("parameters", new JSONArray().put(this.item + 1));
        return this.parent.getHandle() + "#" + o.toString();
    }

    @Override
    public IJavaElement getParent() {
        return this.parent;
    }

    @Override
    public void _moveto() {
        int columnCount = this.getColumnCount();
        if (this.item < 0 || this.item >= columnCount) {
            throw new NoSuchElementException("Index out of bounds error on JTableHeader: " + this.item, null);
        }
        Rectangle bounds = this.getCellBounds();
        this.getDriver().getDevices().moveto(this.parent.getComponent(), bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    @Override
    public Component getPseudoComponent() {
        return EventQueueWait.exec(new Callable<Component>(){

            @Override
            public Component call() {
                return JTableHeaderItemJavaElement.getRendererComponent((JTableHeader)JTableHeaderItemJavaElement.this.parent.getComponent(), JTableHeaderItemJavaElement.this.item);
            }
        });
    }

    private Rectangle getCellBounds() {
        return ((JTableHeader)this.parent.getComponent()).getHeaderRect(this.item);
    }

    @Override
    public Point _getMidpoint() {
        int columnCount = this.getColumnCount();
        if (this.item < 0 || this.item >= columnCount) {
            throw new NoSuchElementException("Index out of bounds error on JTableHeader: " + this.item, null);
        }
        Rectangle bounds = this.getCellBounds();
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    public int getItem() {
        return this.item + 1;
    }

    public static Component getRendererComponent(JTableHeader jTableHeader, int item) {
        int columnCount = jTableHeader.getColumnModel().getColumnCount();
        if (item < 0 || item >= columnCount) {
            throw new NoSuchElementException("Index out of bounds error on JTableHeader: " + item, null);
        }
        Object headerValue = jTableHeader.getColumnModel().getColumn(item).getHeaderValue();
        TableCellRenderer headerRenderer = jTableHeader.getColumnModel().getColumn(item).getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = jTableHeader.getDefaultRenderer();
        }
        Component rendererComponent = headerRenderer.getTableCellRendererComponent(jTableHeader.getTable(), headerValue, false, false, 0, item);
        return rendererComponent;
    }

    @Override
    public String _getText() {
        return JTableHeaderItemJavaElement.getText((JTableHeader)this.component, this.item);
    }

    public static String getText(JTableHeader tableHeader, int index) {
        String original;
        String itemText = original = JTableHeaderItemJavaElement.getItemText(tableHeader, index);
        int suffixIndex = 0;
        for (int i = 0; i < index; ++i) {
            String current = JTableHeaderItemJavaElement.getItemText(tableHeader, i);
            if (!current.equals(original)) continue;
            itemText = String.format("%s(%d)", original, ++suffixIndex);
        }
        return itemText;
    }

    protected static String getItemText(JTableHeader tableHeader, int index) {
        Component r = JTableHeaderItemJavaElement.getRendererComponent(tableHeader, index);
        JavaElementPropertyAccessor pa = new JavaElementPropertyAccessor(r);
        return pa.getText();
    }
}

