/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.components.JTableHeaderItemJavaElement;
import net.sourceforge.marathon.javaagent.components.PropertyHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public class JTableHeaderJavaElement
extends AbstractJavaElement {
    public static final Logger LOGGER = Logger.getLogger(JTableHeaderJavaElement.class.getName());

    public JTableHeaderJavaElement(Component header, IJavaAgent javaAgent, JavaTargetLocator.JWindow window) {
        super(header, javaAgent, window);
    }

    @Override
    public String _getText() {
        int nitems = this.getCount();
        JSONArray r = new JSONArray();
        for (int i = 0; i < nitems; ++i) {
            r.put(new JTableHeaderItemJavaElement(this, i)._getText());
        }
        return r.toString();
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("nth-item")) {
            return Arrays.asList(new JTableHeaderItemJavaElement(this, (Integer)params[0] - 1));
        }
        if (selector.equals("all-items")) {
            int nitems = this.getCount();
            ArrayList<IJavaElement> r = new ArrayList<IJavaElement>();
            for (int i = 0; i < nitems; ++i) {
                r.add(new JTableHeaderItemJavaElement(this, i));
            }
            return r;
        }
        if (selector.equals("select-by-properties")) {
            try {
                JSONObject o = new JSONObject((String)params[0]);
                return this.selectByProperties(new ArrayList<IJavaElement>(), o);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        throw new UnsupportedCommandException("JTableHeader does not support pseudoelement " + selector, null);
    }

    private List<IJavaElement> selectByProperties(ArrayList<IJavaElement> r, JSONObject o) throws Throwable {
        Properties p = o.has("select") ? PropertyHelper.fromString(o.getString("select"), new String[][]{{"text"}}) : PropertyHelper.asProperties(o);
        return this.findmatch(r, new PropertyPredicate(p));
    }

    private List<IJavaElement> findmatch(ArrayList<IJavaElement> r, PropertyPredicate p) {
        JTableHeader header = (JTableHeader)this.component;
        TableColumnModel columnModel = header.getColumnModel();
        int col = columnModel.getColumnCount();
        for (int i = 0; i < col; ++i) {
            JTableHeaderItemJavaElement e = new JTableHeaderItemJavaElement(this, i);
            if (!p.isValid(e)) continue;
            r.add(e);
        }
        return r;
    }

    public int getCount() {
        JTableHeader header = (JTableHeader)this.getComponent();
        return header.getColumnModel().getColumnCount();
    }

    public String getContent() {
        return new JSONArray(JTableHeaderJavaElement.getContent((JTableHeader)this.component)).toString();
    }

    public static String[][] getContent(JTableHeader component) {
        int columnCount = component.getColumnModel().getColumnCount();
        String[][] content = new String[1][columnCount];
        for (int i = 0; i < columnCount; ++i) {
            content[0][i] = JTableHeaderItemJavaElement.getText(component, i);
        }
        return content;
    }

    private static interface Predicate {
        public boolean isValid(JTableHeaderItemJavaElement var1);
    }

    private static final class PropertyPredicate
    implements Predicate {
        private final Properties p;

        private PropertyPredicate(Properties p) {
            this.p = p;
        }

        @Override
        public boolean isValid(JTableHeaderItemJavaElement e) {
            Enumeration<Object> keys = this.p.keys();
            while (keys.hasMoreElements()) {
                String object = (String)keys.nextElement();
                if (this.p.getProperty(object).equals(e.getAttribute(object))) continue;
                return false;
            }
            return true;
        }
    }
}

