/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.components.JTableCellJavaElement;
import net.sourceforge.marathon.javaagent.components.JTableHeaderJavaElement;
import net.sourceforge.marathon.javaagent.components.PropertyHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public class JTableJavaElement
extends AbstractJavaElement {
    public static final Logger LOGGER = Logger.getLogger(JTableJavaElement.class.getName());

    public JTableJavaElement(Component component, IJavaAgent driver, JavaTargetLocator.JWindow window) {
        super(component, driver, window);
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("header")) {
            return Arrays.asList(new JTableHeaderJavaElement(((JTable)this.getComponent()).getTableHeader(), this.getDriver(), this.getWindow()));
        }
        if (selector.equals("mnth-cell")) {
            return Arrays.asList(new JTableCellJavaElement(this, (Integer)params[0] - 1, (Integer)params[1] - 1));
        }
        if (selector.equals("all-cells")) {
            return this.collectCells(new ArrayList<IJavaElement>(), new Predicate(){

                @Override
                public boolean isValid(JTableCellJavaElement e) {
                    return true;
                }
            });
        }
        if (selector.equals("select-by-properties")) {
            JSONObject o = new JSONObject((String)params[0]);
            return this.selectByProperties(new ArrayList<IJavaElement>(), o);
        }
        return super.getByPseudoElement(selector, params);
    }

    public List<IJavaElement> collectCells(List<IJavaElement> r, Predicate p) {
        try {
            int rows = (Integer)EventQueueWait.call(this.getComponent(), "getRowCount", new Object[0]);
            int cols = (Integer)EventQueueWait.call(this.getComponent(), "getColumnCount", new Object[0]);
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    JTableCellJavaElement e = new JTableCellJavaElement(this, i, j);
                    if (!p.isValid(e)) continue;
                    r.add(e);
                }
            }
            return r;
        }
        catch (NoSuchMethodException e) {
            return Collections.emptyList();
        }
    }

    private List<IJavaElement> selectByProperties(List<IJavaElement> r, JSONObject o) {
        if (o.has("select")) {
            Properties p = PropertyHelper.fromString(o.getString("select"), new String[][]{{"row", "column"}});
            return this.collectCells(r, new RowColPropertyPredicate(p.getProperty("row"), p.getProperty("column")));
        }
        Properties p = PropertyHelper.asProperties(o);
        return this.collectCells(r, new PropertyPredicate(p));
    }

    public Component getEditor(final int viewRow, final int viewCol) {
        return EventQueueWait.exec(new Callable<Component>(){

            @Override
            public Component call() throws Exception {
                JTableJavaElement.this.validate(viewRow, viewCol);
                JTable table = (JTable)JTableJavaElement.this.getComponent();
                table.editCellAt(viewRow, viewCol);
                Component c = table.getEditorComponent();
                if (c instanceof JComponent) {
                    ((JComponent)c).putClientProperty("marathon.celleditor", true);
                    ((JComponent)c).putClientProperty("marathon.celleditor.parent", table);
                }
                return c;
            }
        });
    }

    @Override
    public String _getText() {
        JTable table = (JTable)this.getComponent();
        int rows = table.getRowCount();
        int cols = table.getColumnCount();
        JSONArray r = new JSONArray();
        for (int i = 0; i < rows; ++i) {
            JSONArray c = new JSONArray();
            for (int j = 0; j < cols; ++j) {
                c.put(new JTableCellJavaElement(this, i, j)._getText());
            }
            r.put(c);
        }
        return r.toString();
    }

    private void validate(int viewRow, int viewCol) {
        JTable table = (JTable)this.getComponent();
        try {
            int row = table.convertRowIndexToModel(viewRow);
            int col = table.convertColumnIndexToModel(viewCol);
            TableModel model = table.getModel();
            if (row >= 0 && row < model.getRowCount() && col >= 0 && col < model.getColumnCount()) {
                if (table.isCellEditable(viewRow, viewCol)) {
                    return;
                }
                throw new NoSuchElementException("The cell is not editable on JTable: (" + viewRow + ", " + viewCol + ")", null);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new NoSuchElementException("Invalid row/col for JTable: (" + viewRow + ", " + viewCol + ")", null);
    }

    public String getContent() {
        return new JSONArray(JTableJavaElement.getContent((JTable)this.component)).toString();
    }

    public static String[][] getContent(JTable component) {
        int rows = component.getRowCount();
        int cols = component.getColumnCount();
        String[][] content = new String[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Object valueAt = component.getValueAt(i, j);
                if (valueAt == null) {
                    valueAt = "";
                }
                content[i][j] = valueAt.toString();
            }
        }
        return content;
    }

    @Override
    public boolean marathon_select(JSONArray jsonArray) {
        ArrayList<IJavaElement> l = new ArrayList<IJavaElement>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject o = jsonArray.getJSONObject(i);
            this.selectByProperties(l, o);
        }
        int[] rows = new int[l.size()];
        int[] cols = new int[l.size()];
        int index = 0;
        for (IJavaElement e : l) {
            rows[index] = ((JTableCellJavaElement)e).getRow();
            cols[index] = ((JTableCellJavaElement)e).getCol();
        }
        this.selectRowsColumns((JTable)this.component, rows, cols);
        return true;
    }

    @Override
    public boolean marathon_select(String text) {
        int[] cols;
        int[] rows;
        JTable table = (JTable)this.component;
        boolean cellEditing = table.isEditing();
        if (cellEditing) {
            return true;
        }
        if ("".equals(text)) {
            table.clearSelection();
            return true;
        }
        if ("all".equals(text)) {
            int i;
            int rowCount = table.getRowCount();
            int columnCount = table.getColumnCount();
            rows = new int[rowCount];
            cols = new int[columnCount];
            for (i = 0; i < rowCount; ++i) {
                rows[i] = i;
            }
            for (i = 0; i < columnCount; ++i) {
                cols[i] = i;
            }
        } else {
            rows = this.parseRows(text);
            String[] colNames = this.parseCols(text);
            cols = new int[colNames.length];
            for (int i = 0; i < colNames.length; ++i) {
                cols[i] = this.getColumnIndex(colNames[i]);
            }
        }
        return this.selectRowsColumns(table, rows, cols);
    }

    private boolean selectRowsColumns(JTable table, int[] rows, int[] cols) {
        int rowCount = table.getRowCount();
        for (int r : rows) {
            if (r < rowCount) continue;
            return false;
        }
        table.clearSelection();
        for (int c : cols) {
            table.addColumnSelectionInterval(c, c);
        }
        for (int r : rows) {
            table.addRowSelectionInterval(r, r);
        }
        return true;
    }

    private int getColumnIndex(String columnName) {
        JTable table = (JTable)this.component;
        int ncolumns = table.getColumnCount();
        for (int i = 0; i < ncolumns; ++i) {
            String column = this.getColumnName(i);
            if (!columnName.equals(this.escape(column))) continue;
            return i;
        }
        if (columnName.length() == 1 && columnName.charAt(0) >= 'A' && columnName.charAt(0) <= 'Z') {
            return columnName.charAt(0) - 65;
        }
        throw new RuntimeException("Could not find column " + columnName + " in table");
    }

    private String escape(String columnName) {
        return columnName.replaceAll("#", "##").replaceAll(",", "#;");
    }

    private int[] parseRows(String s) {
        String rowText = "";
        int i = s.indexOf("rows:");
        if (i != -1) {
            int j = s.indexOf("columns:");
            rowText = j == -1 ? s.substring(i + 5) : s.substring(i + 5, j);
            int k = rowText.indexOf(91);
            int l = rowText.indexOf(93);
            rowText = rowText.substring(k + 1, l);
        }
        StringTokenizer tokenizer = new StringTokenizer(rowText, ", ");
        ArrayList<String> rows = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            rows.add(tokenizer.nextToken());
        }
        int[] irows = new int[rows.size()];
        for (int j = 0; j < irows.length; ++j) {
            try {
                irows[j] = Integer.parseInt((String)rows.get(j));
                continue;
            }
            catch (Throwable t) {
                return new int[0];
            }
        }
        return irows;
    }

    private String[] parseCols(String s) {
        String colText = "";
        int i = s.indexOf("columns:");
        if (i != -1) {
            colText = s.substring(i + 8);
            int k = colText.indexOf(91);
            int l = colText.indexOf(93);
            colText = colText.substring(k + 1, l);
        }
        ArrayList<String> cols = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(colText, ",");
        while (tokenizer.hasMoreElements()) {
            cols.add(tokenizer.nextToken());
        }
        return cols.toArray(new String[cols.size()]);
    }

    private static interface Predicate {
        public boolean isValid(JTableCellJavaElement var1);
    }

    private static class RowColPropertyPredicate
    implements Predicate {
        private String row;
        private String column;

        public RowColPropertyPredicate(String row, String column) {
            this.row = row;
            this.column = column;
        }

        @Override
        public boolean isValid(JTableCellJavaElement e) {
            String eRow = e.getAttribute("row");
            String eColumn = e.getAttribute("column");
            if (this.row.equals(eRow)) {
                if (this.column.equals(eColumn)) {
                    return true;
                }
                if (this.column.length() == 1 && this.column.charAt(0) >= 'A' && this.column.charAt(0) <= 'Z') {
                    int colId = this.column.charAt(0) - 65;
                    if (e.getViewColumn() - 1 == colId) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static final class PropertyPredicate
    implements Predicate {
        private final Properties p;

        private PropertyPredicate(Properties p) {
            this.p = p;
        }

        @Override
        public boolean isValid(JTableCellJavaElement e) {
            Enumeration<Object> keys = this.p.keys();
            while (keys.hasMoreElements()) {
                String object = (String)keys.nextElement();
                if (this.p.getProperty(object).equals(e.getAttribute(object))) continue;
                return false;
            }
            return true;
        }
    }
}

