/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.marathon.javaagent.AbstractJavaElement;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.IPseudoElement;
import net.sourceforge.marathon.javaagent.JavaElementFactory;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.components.JTreeJavaElement;
import org.json.JSONArray;
import org.json.JSONObject;

public class JTreeNodeJavaElement
extends AbstractJavaElement
implements IPseudoElement {
    public static final Logger LOGGER = Logger.getLogger(JTreeNodeJavaElement.class.getName());
    private JTreeJavaElement parent;
    private int viewRow;

    public JTreeNodeJavaElement(JTreeJavaElement parent, int row) {
        super(parent);
        this.parent = parent;
        this.viewRow = row;
    }

    @Override
    public String createHandle() {
        JSONObject o = new JSONObject().put("selector", "nth-node").put("parameters", new JSONArray().put(this.viewRow + 1));
        return this.parent.getHandle() + "#" + o.toString();
    }

    @Override
    public List<IJavaElement> getByPseudoElement(String selector, Object[] params) {
        if (selector.equals("editor")) {
            Component editor = this.getEditor();
            if (editor == null) {
                throw new UnsupportedCommandException("Unable to find editingComponent for the tree. tree.editable = " + ((JTree)this.parent.getComponent()).isEditable(), null);
            }
            return Arrays.asList(JavaElementFactory.createElement(editor, this.getDriver(), this.getWindow()));
        }
        throw new UnsupportedCommandException("JTree node does not support pseudoelement " + selector, null);
    }

    private Component getEditor() {
        return EventQueueWait.exec(new Callable<Component>(){

            @Override
            public Component call() throws Exception {
                JTree tree = (JTree)JTreeNodeJavaElement.this.parent.getComponent();
                TreePath pathForRow = tree.getPathForRow(JTreeNodeJavaElement.this.viewRow);
                tree.startEditingAtPath(pathForRow);
                Component c = this.getEditingComponent(tree);
                if (c instanceof JComponent) {
                    ((JComponent)c).putClientProperty("marathon.celleditor", true);
                }
                return c;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Component getEditingComponent(JTree tree) {
                TreeUI ui = tree.getUI();
                Field cField = null;
                if (ui instanceof BasicTreeUI) {
                    try {
                        cField = BasicTreeUI.class.getDeclaredField("editingComponent");
                        cField.setAccessible(true);
                        Component component = (Component)cField.get(ui);
                        return component;
                    }
                    catch (Throwable t) {
                        LOGGER.warning("Unable to find editingComponent for " + ui.getClass());
                        t.printStackTrace();
                    }
                    finally {
                        if (cField != null) {
                            cField.setAccessible(false);
                        }
                    }
                }
                return null;
            }
        });
    }

    @Override
    public IJavaElement getParent() {
        return this.parent;
    }

    @Override
    public Component getPseudoComponent() {
        return EventQueueWait.exec(new Callable<Component>(){

            @Override
            public Component call() throws Exception {
                JTreeNodeJavaElement.this.validateRow();
                JTree tree = (JTree)JTreeNodeJavaElement.this.parent.getComponent();
                TreeCellRenderer cellRenderer = tree.getCellRenderer();
                TreePath pathForRow = tree.getPathForRow(JTreeNodeJavaElement.this.viewRow);
                Object lastPathComponent = pathForRow.getLastPathComponent();
                return cellRenderer.getTreeCellRendererComponent(tree, lastPathComponent, false, false, false, JTreeNodeJavaElement.this.viewRow, false);
            }
        });
    }

    private void validateRow() {
        int rowCount = ((JTree)this.parent.getComponent()).getRowCount();
        if (this.viewRow >= 0 && this.viewRow < rowCount) {
            return;
        }
        throw new NoSuchElementException("Invalid row for JTree: (" + this.viewRow + ")", null);
    }

    @Override
    public void _moveto() {
        this.validateRow();
        Rectangle bounds = this.getCellBounds();
        this.getDriver().getDevices().moveto(this.parent.getComponent(), bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    private Rectangle getCellBounds() {
        Callable<Rectangle> x = new Callable<Rectangle>(){

            @Override
            public Rectangle call() {
                JTree tree = (JTree)JTreeNodeJavaElement.this.parent.getComponent();
                return tree.getRowBounds(JTreeNodeJavaElement.this.viewRow);
            }
        };
        try {
            return EventQueueWait.exec(x);
        }
        catch (Exception e) {
            return new Rectangle();
        }
    }

    @Override
    public boolean _isDisplayed() {
        return this.isVisible((JTree)this.parent.getComponent(), this.viewRow);
    }

    private boolean isVisible(JTree tree, int row) {
        Rectangle visibleRect = tree.getVisibleRect();
        Rectangle cellRect = tree.getRowBounds(row);
        return SwingUtilities.isRectangleContainingRectangle(visibleRect, cellRect);
    }

    @Override
    public Point _getMidpoint() {
        this.validateRow();
        Rectangle bounds = this.getCellBounds();
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    public boolean isExpanded() {
        return EventQueueWait.exec(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                JTree tree = (JTree)JTreeNodeJavaElement.this.parent.getComponent();
                return tree.isExpanded(JTreeNodeJavaElement.this.viewRow);
            }
        });
    }

    public String escapeSpecialCharacters(String name) {
        return name.replaceAll("/", "\\\\/");
    }

    public int getRow() {
        return this.viewRow;
    }

    public int getViewRow() {
        return this.viewRow + 1;
    }

    @Override
    public void submit() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JTree)JTreeNodeJavaElement.this.parent.getComponent()).stopEditing();
            }
        });
    }
}

