/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class PropertyHelper {
    public static final Logger LOGGER = Logger.getLogger(PropertyHelper.class.getName());

    public static String toString(Properties p, String[] propOrder) {
        StringBuffer sb = new StringBuffer();
        if (p.size() > 1) {
            sb.append("{");
        }
        char[] convertBuf = new char[1024];
        for (int i = 0; i < propOrder.length; ++i) {
            sb.append(PropertyHelper.escape(p.getProperty(propOrder[i]), convertBuf));
            if (i >= propOrder.length - 1) continue;
            sb.append(", ");
        }
        if (p.size() > 1) {
            sb.append("}");
        }
        return sb.toString();
    }

    private static String escape(String s, char[] convertBuf) {
        if (convertBuf.length < s.length()) {
            int newLen = s.length() * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convertBuf = new char[newLen];
        }
        int convertLen = 0;
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ',': 
                case ':': 
                case '\\': 
                case '{': 
                case '}': {
                    convertBuf[convertLen++] = 92;
                    break;
                }
                case ' ': {
                    if (i != 0) break;
                    convertBuf[convertLen++] = 92;
                    break;
                }
            }
            convertBuf[convertLen++] = chars[i];
        }
        return new String(convertBuf, 0, convertLen);
    }

    public static String toString(Properties[] pa, String[] propOrder) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < pa.length; ++i) {
            sb.append(PropertyHelper.toString(pa[i], propOrder));
            if (i >= pa.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static Properties fromString(String s, String[][] props) {
        TokenReader reader = new TokenReader(s);
        return PropertyHelper.readProperties(reader, props);
    }

    public static Properties readProperties(TokenReader reader, String[][] props) {
        if (!reader.hasNext()) {
            throw new RuntimeException("Invalid property list format");
        }
        int token = reader.next();
        if (token == 1) {
            Properties p = new Properties();
            for (String[] prop : props) {
                if (prop.length != 1) continue;
                p.setProperty(prop[0], reader.getText());
                return p;
            }
            throw new RuntimeException("Invalid property list format");
        }
        if (token == 123) {
            ArrayList<String[]> list = new ArrayList<String[]>();
            while (token != 125) {
                String[] tokens = new String[2];
                token = reader.next();
                if (token != 1) {
                    throw new RuntimeException("Invalid property list format");
                }
                tokens[0] = reader.getText();
                token = reader.next();
                if (token == 58) {
                    token = reader.next();
                    if (token != 1) {
                        throw new RuntimeException("Invalid property list format");
                    }
                    tokens[1] = reader.getText();
                    token = reader.next();
                    if (token != 44 && token != 125) {
                        throw new RuntimeException("Invalid property list format");
                    }
                } else if (token == 44 || token == 125) {
                    tokens[1] = tokens[0];
                    tokens[0] = null;
                }
                list.add(tokens);
            }
            String[] first = (String[])list.get(0);
            if (first[0] == null) {
                Properties p = new Properties();
                for (String[] selectedProps : props) {
                    if (selectedProps.length != list.size()) continue;
                    for (int j = 0; j < selectedProps.length; ++j) {
                        p.setProperty(selectedProps[j], ((String[])list.get(j))[1]);
                    }
                    return p;
                }
                throw new RuntimeException("Invalid property list format");
            }
            Properties p = new Properties();
            for (int i = 0; i < list.size(); ++i) {
                String[] prop = (String[])list.get(i);
                p.setProperty(prop[0], prop[1]);
            }
            return p;
        }
        throw new RuntimeException("Invalid property list format");
    }

    public static Properties[] fromStringToArray(String s, String[][] props) {
        if (!(s = s.trim()).startsWith("[") || !s.endsWith("]")) {
            throw new RuntimeException("Invalid property list format");
        }
        if (s.length() == 2) {
            return new Properties[0];
        }
        ArrayList<Properties> plist = new ArrayList<Properties>();
        int token = 44;
        TokenReader reader = new TokenReader(s, 1, s.length() - 1);
        while (token == 44 && reader.hasNext()) {
            Properties p = PropertyHelper.readProperties(reader, props);
            plist.add(p);
            if (!reader.hasNext()) continue;
            token = reader.next();
        }
        return plist.toArray(new Properties[plist.size()]);
    }

    public static String toCSS(Properties properties) {
        Map.Entry<Object, Object> typeProperty = null;
        Map.Entry<Object, Object> indexProperty = null;
        Map.Entry<Object, Object> tagNameProperty = null;
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            if (entry.getKey().equals("type")) {
                typeProperty = entry;
                continue;
            }
            if (entry.getKey().equals("indexOfType")) {
                indexProperty = entry;
                continue;
            }
            if (entry.getKey().equals("tagName")) {
                tagNameProperty = entry;
                continue;
            }
            String value = entry.getValue().toString();
            value = value.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'");
            sb.append("[").append(entry.getKey().toString()).append("=").append("'").append(value).append("']");
        }
        String r = sb.toString();
        if (tagNameProperty != null) {
            r = tagNameProperty.getValue().toString();
        }
        if (typeProperty != null) {
            r = "[" + typeProperty.getKey().toString() + "='" + typeProperty.getValue().toString() + "']" + sb.toString();
        }
        if (indexProperty != null) {
            int index = Integer.parseInt(indexProperty.getValue().toString());
            r = r + ":nth(" + (index + 1) + ")";
        }
        return r;
    }

    public static TableSelection fromTableSelection(String text) {
        text = text.trim();
        Pattern p = Pattern.compile("rows *: *\\[([^\\]]*)\\] *, *columns *: *\\[([^\\]]*)\\]");
        Matcher matcher = p.matcher(text);
        if (matcher.matches()) {
            TableSelection tableSelection = new TableSelection(PropertyHelper.parseCSV(matcher.group(1)), PropertyHelper.parseCSV(matcher.group(2)));
            return tableSelection;
        }
        return null;
    }

    private static String[] parseCSV(String text) {
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(text, ",");
        while (tok.hasMoreTokens()) {
            al.add(tok.nextToken());
        }
        return al.toArray(new String[al.size()]);
    }

    public static String toCSS(JSONObject urp) {
        String[] names;
        Properties props = new Properties();
        for (String prop : names = JSONObject.getNames(urp)) {
            props.setProperty(prop, urp.get(prop).toString());
        }
        return PropertyHelper.toCSS(props);
    }

    public static String toCSS(String name) {
        Properties props = new Properties();
        props.setProperty("contextualTitle", name);
        return PropertyHelper.toCSS(props);
    }

    public static Properties asProperties(JSONObject jsonObject) {
        Properties r = new Properties();
        String[] names = JSONObject.getNames(jsonObject);
        if (names != null) {
            for (String name : names) {
                r.setProperty(name, jsonObject.get(name).toString());
            }
        }
        return r;
    }

    public static class TableSelection {
        private String[] rows;
        private String[] columns;

        public String toString() {
            return "TableSelection [rows=" + Arrays.toString(this.rows) + ", columns=" + Arrays.toString(this.columns) + "]";
        }

        public TableSelection(String[] rows, String[] columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public String[] getRows() {
            return this.rows;
        }

        public String[] getColumns() {
            return this.columns;
        }
    }

    private static final class TokenReader {
        static final int ID = 1;
        static final int COMMA = 44;
        static final int OPENBR = 123;
        static final int CLOSEBR = 125;
        static final int COLON = 58;
        private char[] b;
        String text;
        int index;
        private int len;

        public TokenReader(String s) {
            this.b = s.toCharArray();
            this.len = this.b.length;
            this.index = 0;
        }

        public TokenReader(String s, int off, int len) {
            this.b = s.toCharArray();
            this.index = off;
            this.len = len;
        }

        public boolean hasNext() {
            return this.index < this.len;
        }

        public int next() {
            this.skipSpaces();
            if (this.index >= this.len) {
                throw new RuntimeException("Invalid property list format");
            }
            switch (this.b[this.index]) {
                case ',': 
                case ':': 
                case '{': 
                case '}': {
                    return this.b[this.index++];
                }
            }
            StringBuffer sb = new StringBuffer();
            while (this.index < this.len && this.b[this.index] != ',' && this.b[this.index] != '{' && this.b[this.index] != '}' && this.b[this.index] != ':') {
                if (this.b[this.index] == '\\') {
                    ++this.index;
                    if (this.index >= this.len) {
                        throw new RuntimeException("Invalid property list format");
                    }
                }
                sb.append(this.b[this.index]);
                ++this.index;
            }
            this.text = sb.toString();
            return 1;
        }

        private void skipSpaces() {
            while (this.index < this.len && this.b[this.index] == ' ') {
                ++this.index;
            }
        }

        public String getText() {
            return this.text;
        }
    }
}

