/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.css;

import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.css.ILexer;
import net.sourceforge.marathon.javaagent.css.ParserException;
import net.sourceforge.marathon.javaagent.css.Token;
import net.sourceforge.marathon.javaagent.css.TokenType;

public abstract class AbstractLexer
implements ILexer {
    public static final Logger LOGGER = Logger.getLogger(AbstractLexer.class.getName());
    protected PushbackReader reader;
    private Token laToken;
    protected boolean ignoreWhitespace = true;

    public AbstractLexer(PushbackReader reader) {
        this.reader = reader;
    }

    final Token nextToken() {
        Token token = this.laToken == null ? this.getNextToken() : this.laToken;
        this.laToken = null;
        return token;
    }

    protected abstract Token getNextToken();

    @Override
    public Token expect1(TokenType ... types) {
        Token t = this.expect1r0(types);
        if (t == null) {
            t = this.nextToken();
            ArrayList<TokenType> asList = new ArrayList<TokenType>(Arrays.asList(types));
            throw new ParserException("Expecting one of " + asList + " Got: " + t, null);
        }
        return t;
    }

    private Token findMatchingToken(Token la, TokenType[] types) {
        for (TokenType type : types) {
            if (la.getType() != type) continue;
            return this.nextToken();
        }
        return null;
    }

    @Override
    public Token expect1r0(TokenType ... types) {
        this.ignoreWhitespace = !Arrays.asList(types).contains((Object)TokenType.TT_WHITESPACE);
        return this.findMatchingToken(this.lookAhead(), types);
    }

    public final Token lookAhead() {
        if (this.laToken != null) {
            return this.laToken;
        }
        this.laToken = this.getNextToken();
        return this.laToken;
    }
}

