/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.css.Argument;
import net.sourceforge.marathon.javaagent.css.SelectorFilter;

public class AttributeFilter
implements SelectorFilter {
    public static final Logger LOGGER = Logger.getLogger(AttributeFilter.class.getName());
    private String name;
    private Argument arg;
    private String op;

    public AttributeFilter(String name, Argument arg, String op) {
        this.name = name;
        this.arg = arg;
        this.op = op;
    }

    public String toString() {
        if (this.op == null) {
            return "[" + this.name + "]";
        }
        return "[" + this.name + " " + this.op + " " + this.arg + "]";
    }

    @Override
    public List<IJavaElement> match(IJavaElement je) {
        if (this.doesMatch(je)) {
            return Arrays.asList(je);
        }
        return new ArrayList<IJavaElement>();
    }

    public boolean doesMatch(IJavaElement je) {
        if (this.arg == null) {
            return je.hasAttribue(this.name);
        }
        String expected = je.getAttribute(this.name);
        if (expected == null) {
            return false;
        }
        if (this.op.equals("startsWith")) {
            return expected.startsWith(this.arg.getStringValue());
        }
        if (this.op.equals("endsWith")) {
            return expected.endsWith(this.arg.getStringValue());
        }
        if (this.op.equals("contains")) {
            return expected.contains(this.arg.getStringValue());
        }
        return expected.equals(this.arg.getStringValue());
    }
}

