/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.css;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaElementFactory;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.NoSuchWindowException;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.css.Selector;
import net.sourceforge.marathon.javaagent.css.SimpleSelector;
import org.json.JSONException;

public class ChildSelector
implements Selector {
    public static final Logger LOGGER = Logger.getLogger(ChildSelector.class.getName());
    private Selector parent;
    private SimpleSelector child;

    public ChildSelector(Selector parent, SimpleSelector child) {
        this.parent = parent;
        this.child = child;
    }

    public String toString() {
        return this.parent + " > " + this.child;
    }

    @Override
    public List<IJavaElement> findElements(final IJavaAgent driver, IJavaElement container, long implicitWait) {
        final List<IJavaElement> pElements = this.parent.findElements(driver, container, implicitWait);
        if (pElements.size() == 0) {
            return pElements;
        }
        final Object[] r = new Object[]{null};
        if (implicitWait == 0L) {
            EventQueueWait.exec(new Runnable(){

                @Override
                public void run() {
                    try {
                        r[0] = ChildSelector.this.found(pElements, driver);
                    }
                    catch (NoSuchWindowException e) {
                        r[0] = e;
                    }
                    catch (UnsupportedCommandException e) {
                        r[0] = e;
                    }
                    catch (JSONException e) {
                        r[0] = e;
                    }
                }
            });
        } else {
            new EventQueueWait(){

                @Override
                public boolean till() {
                    try {
                        List<IJavaElement> list;
                        r[0] = list = ChildSelector.this.found(pElements, driver);
                        return list.size() > 0;
                    }
                    catch (NoSuchWindowException e) {
                        r[0] = e;
                        return true;
                    }
                    catch (UnsupportedCommandException e) {
                        r[0] = e;
                        return true;
                    }
                    catch (JSONException e) {
                        r[0] = e;
                        return true;
                    }
                }
            }.wait_noexc("Unable to find component", implicitWait, 50L);
        }
        if (r[0] instanceof NoSuchWindowException) {
            throw (NoSuchWindowException)r[0];
        }
        if (r[0] instanceof UnsupportedCommandException) {
            throw (UnsupportedCommandException)r[0];
        }
        if (r[0] instanceof JSONException) {
            throw (JSONException)r[0];
        }
        return (List)r[0];
    }

    protected List<IJavaElement> found(List<IJavaElement> pElements, IJavaAgent driver) {
        ArrayList<IJavaElement> r = new ArrayList<IJavaElement>();
        for (IJavaElement je : pElements) {
            Component[] components;
            if (!(je.getComponent() instanceof Container)) continue;
            JavaTargetLocator.JWindow topContainer = driver.switchTo().getTopContainer();
            for (Component c : components = ((Container)je.getComponent()).getComponents()) {
                IJavaElement je2 = JavaElementFactory.createElement(c, driver, driver.switchTo().getTopContainer());
                List<IJavaElement> matched = this.child.matchesSelector(je2);
                for (IJavaElement javaElement : matched) {
                    IJavaElement e = topContainer.addElement(javaElement);
                    if (r.contains(e)) continue;
                    r.add(e);
                }
            }
        }
        return r;
    }
}

