/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.css;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.css.Selector;
import net.sourceforge.marathon.javaagent.css.SimpleSelector;

public class DescendentSelector
implements Selector {
    public static final Logger LOGGER = Logger.getLogger(DescendentSelector.class.getName());
    private Selector parent;
    private SimpleSelector descendent;

    public DescendentSelector(Selector parent, SimpleSelector child) {
        this.parent = parent;
        this.descendent = child;
    }

    public String toString() {
        return this.parent + " " + this.descendent;
    }

    @Override
    public List<IJavaElement> findElements(IJavaAgent driver, IJavaElement container, long implicitWait) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        List<IJavaElement> parents = this.parent.findElements(driver, container, implicitWait);
        for (IJavaElement parent : parents) {
            List<IJavaElement> es = this.descendent.findElements(driver, parent, implicitWait);
            for (IJavaElement e : es) {
                if (result.contains(e)) continue;
                result.add(e);
            }
        }
        return result;
    }
}

