/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.css.SelectorFilter;

public class IdFilter
implements SelectorFilter {
    public static final Logger LOGGER = Logger.getLogger(IdFilter.class.getName());
    private String id;

    public IdFilter(String id) {
        this.id = id;
    }

    public String toString() {
        char[] cs = this.id.toCharArray();
        boolean needQuotes = false;
        for (char c : cs) {
            needQuotes = needQuotes || !Character.isJavaIdentifierPart(c);
        }
        if (needQuotes) {
            return "#\"" + this.id + "\"";
        }
        return "#" + this.id;
    }

    @Override
    public List<IJavaElement> match(IJavaElement je) {
        if (this.id.equals(je.getAttribute("name"))) {
            return Arrays.asList(je);
        }
        return new ArrayList<IJavaElement>();
    }
}

