/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.css.Argument;
import net.sourceforge.marathon.javaagent.css.SelectorFilter;

public class PseudoClassFilter
implements SelectorFilter {
    public static final Logger LOGGER = Logger.getLogger(PseudoClassFilter.class.getName());
    private String function;
    private Argument[] args;

    public PseudoClassFilter(String function) {
        this(function, new Argument[0]);
    }

    public PseudoClassFilter(String function, Argument[] args) {
        this.function = function;
        this.args = args;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(":" + this.function);
        if (this.args.length > 0) {
            sb.append("(");
            for (Argument arg : this.args) {
                sb.append(arg.toString());
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<IJavaElement> match(IJavaElement je) {
        if (this.doesMatch(je)) {
            return Arrays.asList(je);
        }
        return new ArrayList<IJavaElement>();
    }

    public boolean doesMatch(IJavaElement je) {
        if (this.args == null || this.args.length == 0) {
            return je.filterByPseudoClass(this.function, new Object[0]);
        }
        Object[] params = new Object[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            params[i] = this.args[i].getValue();
        }
        return je.filterByPseudoClass(this.function, params);
    }

    public boolean isNth() {
        return this.function.equals("nth");
    }

    public int getNthIndex() {
        return (Integer)this.args[0].getValue();
    }
}

