/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.css;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.css.AbstractLexer;
import net.sourceforge.marathon.javaagent.css.LexerException;
import net.sourceforge.marathon.javaagent.css.Token;
import net.sourceforge.marathon.javaagent.css.TokenType;

public class SelectorLexer
extends AbstractLexer {
    public static final Logger LOGGER = Logger.getLogger(SelectorLexer.class.getName());

    public SelectorLexer(String selector) {
        super(new PushbackReader(new StringReader(selector)));
    }

    @Override
    protected Token getNextToken() {
        try {
            int c;
            while ((c = this.reader.read()) != -1) {
                int la = this.reader.read();
                if (la != -1) {
                    this.reader.unread(la);
                }
                if (Character.isWhitespace(c)) {
                    while (Character.isWhitespace(c)) {
                        c = this.reader.read();
                    }
                    if (c != -1) {
                        this.reader.unread(c);
                    }
                    if (this.ignoreWhitespace) continue;
                    return new Token(TokenType.TT_WHITESPACE);
                }
                if (c == 34 || c == 39) {
                    return this.readString(c);
                }
                if (c == 44) {
                    return new Token(TokenType.TT_COMMA);
                }
                if (c == 91) {
                    return new Token(TokenType.TT_OPEN_BR);
                }
                if (c == 93) {
                    return new Token(TokenType.TT_CLOSE_BR);
                }
                if (c == 46) {
                    return new Token(TokenType.TT_SELF_SELECTOR, ".");
                }
                if (c == 40) {
                    return new Token(TokenType.TT_OPEN_PAREN);
                }
                if (c == 41) {
                    return new Token(TokenType.TT_CLOSE_PAREN);
                }
                if (c == 62) {
                    return new Token(TokenType.TT_GREATER);
                }
                if (c == 43) {
                    return new Token(TokenType.TT_PLUS);
                }
                if (c == 126) {
                    return new Token(TokenType.TT_TILDE);
                }
                if (c == 61) {
                    return new Token(TokenType.TT_EQUALS, "=");
                }
                if (c == 94 && la == 61) {
                    this.reader.read();
                    return new Token(TokenType.TT_PREFIXMATCH, "startsWith");
                }
                if (c == 36 && la == 61) {
                    this.reader.read();
                    return new Token(TokenType.TT_SUFFIXMATCH, "endsWith");
                }
                if (c == 42) {
                    if (la == 61) {
                        this.reader.read();
                        return new Token(TokenType.TT_SUBSTRINGMATCH, "contains");
                    }
                    return new Token(TokenType.TT_UNIVERSAL_SELECTOR, "*");
                }
                if (c == 35) {
                    return this.readId();
                }
                if (c == 58) {
                    if (la == 58) {
                        this.reader.read();
                    }
                    return this.readPseudoItem(la == 58 ? TokenType.TT_PSEUDO_ELEMENT : TokenType.TT_PSEUDO_CLASS);
                }
                if (Character.isDigit(c)) {
                    return this.readInteger(c);
                }
                if (Character.isJavaIdentifierStart(c)) {
                    return this.readIdentifier(c);
                }
                throw new LexerException("While reading template start token -- unexpected character '" + (char)c + "'", null);
            }
        }
        catch (IOException e) {
            throw new LexerException("IOError: " + e.getMessage(), e);
        }
        return new Token(TokenType.TT_EOF);
    }

    private Token readId() {
        int c;
        StringBuffer sb = new StringBuffer();
        try {
            while ((c = this.reader.read()) != -1) {
                if (c == 34 || c == 39) {
                    Token t = this.readString(c);
                    return new Token(TokenType.TT_ID, t.getValue());
                }
                if (!Character.isJavaIdentifierPart(c) && c != 45) break;
                sb.append((char)c);
            }
            if (c != -1) {
                this.reader.unread(c);
            }
        }
        catch (IOException e) {
            throw new LexerException("IOError: " + e.getMessage(), e);
        }
        if (sb.length() == 0) {
            throw new LexerException("While reading hashed id -- unexpected character '" + (char)c + "'", null);
        }
        return new Token(TokenType.TT_ID, sb.toString());
    }

    private Token readPseudoItem(TokenType tt) {
        StringBuffer sb = new StringBuffer();
        int c = -1;
        boolean first = false;
        TokenType type = tt;
        try {
            while ((c = this.reader.read()) != -1) {
                if (first && Character.isJavaIdentifierPart(c)) {
                    first = false;
                    sb.append((char)c);
                    continue;
                }
                if (c != 45 && !Character.isJavaIdentifierPart(c) || c == 36) break;
                sb.append((char)c);
            }
            if (c == 40) {
                type = tt == TokenType.TT_PSEUDO_CLASS ? TokenType.TT_PSEUDO_CLASS_ARGS : TokenType.TT_PSEUDO_ELEMENT_ARGS;
            } else if (c != -1) {
                this.reader.unread(c);
            }
        }
        catch (IOException e) {
            throw new LexerException("IOError: " + e.getMessage(), e);
        }
        if (sb.length() == 0) {
            throw new LexerException("While reading pseudo element/class -- unexpected character '" + (char)c + "'", null);
        }
        return new Token(type, sb.toString());
    }

    protected Token readIdentifier(int initial) {
        int c;
        StringBuffer sb = new StringBuffer();
        sb.append((char)initial);
        boolean isAttr = false;
        boolean isTag = false;
        try {
            while ((c = this.reader.read()) != -1 && (c == 45 || c == 46 || Character.isJavaIdentifierPart(c)) && c != 36) {
                if (c == 46) {
                    isAttr = true;
                }
                if (c == 45) {
                    isTag = true;
                }
                sb.append((char)c);
            }
            if (c != -1) {
                this.reader.unread(c);
            }
        }
        catch (IOException e) {
            throw new LexerException("IOError: " + e.getMessage(), e);
        }
        if (sb.length() == 0) {
            throw new LexerException("While reading identifier -- unexpected character '" + (char)c + "'", null);
        }
        String value = sb.toString();
        if (value.equals("true")) {
            return new Token(TokenType.TT_BOOLEAN, value);
        }
        if (value.equals("false")) {
            return new Token(TokenType.TT_BOOLEAN, value);
        }
        if (isAttr && isTag) {
            throw new LexerException("Unable to distinguish between tag and attribute.", null);
        }
        TokenType type = TokenType.TT_IDENTIFIER;
        if (isAttr) {
            type = TokenType.TT_ATTRIBUTE;
        } else if (isTag) {
            type = TokenType.TT_TAG;
        }
        return new Token(type, value);
    }

    protected Token readInteger(int initial) {
        StringBuffer sb = new StringBuffer();
        sb.append((char)initial);
        boolean number = false;
        try {
            int c;
            while ((c = this.reader.read()) != -1 && (Character.isDigit(c) || !number && c == 46)) {
                if (c == 46) {
                    number = true;
                }
                sb.append((char)c);
            }
            if (c != -1) {
                this.reader.unread(c);
            }
        }
        catch (IOException e) {
            throw new LexerException("IOError: " + e.getMessage(), e);
        }
        return new Token(number ? TokenType.TT_NUMBER : TokenType.TT_INTEGER, sb.toString());
    }

    protected Token readString(int sep) {
        StringBuffer sb = new StringBuffer();
        boolean escape = false;
        try {
            int c;
            while ((c = this.reader.read()) != -1) {
                if (c == 92 && !escape) {
                    escape = true;
                    continue;
                }
                if (escape) {
                    if (c == 110) {
                        sb.append('\n');
                    } else {
                        sb.append((char)c);
                    }
                    escape = false;
                    continue;
                }
                if (c == sep) {
                    return new Token(TokenType.TT_STRING, sb.toString());
                }
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            throw new LexerException("IOError: " + e.getMessage(), e);
        }
        throw new LexerException("While reading string - unexpected EOF", null);
    }
}

