/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.css;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.css.AbstractLexer;
import net.sourceforge.marathon.javaagent.css.AdjacentSiblingSelector;
import net.sourceforge.marathon.javaagent.css.Argument;
import net.sourceforge.marathon.javaagent.css.AttributeFilter;
import net.sourceforge.marathon.javaagent.css.ChildSelector;
import net.sourceforge.marathon.javaagent.css.DescendentSelector;
import net.sourceforge.marathon.javaagent.css.GeneralSiblingSelector;
import net.sourceforge.marathon.javaagent.css.IdFilter;
import net.sourceforge.marathon.javaagent.css.PseudoClassFilter;
import net.sourceforge.marathon.javaagent.css.PseudoElementFilter;
import net.sourceforge.marathon.javaagent.css.Selector;
import net.sourceforge.marathon.javaagent.css.SelectorLexer;
import net.sourceforge.marathon.javaagent.css.SimpleSelector;
import net.sourceforge.marathon.javaagent.css.Token;
import net.sourceforge.marathon.javaagent.css.TokenType;

public class SelectorParser {
    public static final Logger LOGGER = Logger.getLogger(SelectorParser.class.getName());
    private AbstractLexer lexer;

    public SelectorParser(String selector) {
        this.lexer = new SelectorLexer(selector);
    }

    public Selector parse() {
        Selector result = this.readSimpleSelector();
        Token isEof;
        while ((isEof = this.lexer.expect1r0(TokenType.TT_EOF)) == null) {
            Token combinator = this.lexer.expect1r0(TokenType.TT_GREATER, TokenType.TT_PLUS, TokenType.TT_TILDE);
            if (combinator == null) {
                result = new DescendentSelector(result, this.readSimpleSelector());
                continue;
            }
            if (combinator.getType() == TokenType.TT_GREATER) {
                result = new ChildSelector(result, this.readSimpleSelector());
                continue;
            }
            if (combinator.getType() == TokenType.TT_PLUS) {
                result = new AdjacentSiblingSelector(result, this.readSimpleSelector());
                continue;
            }
            result = new GeneralSiblingSelector(result, this.readSimpleSelector());
        }
        return result;
    }

    private SimpleSelector readSimpleSelector() {
        Token tag = this.lexer.expect1r0(TokenType.TT_IDENTIFIER, TokenType.TT_TAG, TokenType.TT_UNIVERSAL_SELECTOR, TokenType.TT_SELF_SELECTOR);
        SimpleSelector selector = new SimpleSelector(tag == null ? "*" : tag.getValue());
        Token t = this.lexer.expect1r0(TokenType.TT_ID, TokenType.TT_PSEUDO_CLASS, TokenType.TT_PSEUDO_CLASS_ARGS, TokenType.TT_PSEUDO_ELEMENT, TokenType.TT_PSEUDO_ELEMENT_ARGS, TokenType.TT_OPEN_BR, TokenType.TT_WHITESPACE);
        if (tag == null && t == null) {
            this.lexer.expect1(TokenType.TT_ID, TokenType.TT_PSEUDO_CLASS, TokenType.TT_PSEUDO_CLASS_ARGS, TokenType.TT_PSEUDO_ELEMENT, TokenType.TT_PSEUDO_ELEMENT_ARGS, TokenType.TT_OPEN_BR, TokenType.TT_WHITESPACE);
            return null;
        }
        while (t != null) {
            Argument[] args;
            if (t.getType() == TokenType.TT_WHITESPACE) {
                return selector;
            }
            if (t.getType() == TokenType.TT_ID) {
                selector.addFilter(new IdFilter(t.getValue()));
            } else if (t.getType() == TokenType.TT_PSEUDO_CLASS) {
                selector.addFilter(new PseudoClassFilter(t.getValue()));
            } else if (t.getType() == TokenType.TT_PSEUDO_CLASS_ARGS) {
                args = this.collectArguments();
                selector.addFilter(new PseudoClassFilter(t.getValue(), args));
            } else if (t.getType() == TokenType.TT_PSEUDO_ELEMENT) {
                selector.addFilter(new PseudoElementFilter(t.getValue()));
            } else if (t.getType() == TokenType.TT_PSEUDO_ELEMENT_ARGS) {
                args = this.collectArguments();
                selector.addFilter(new PseudoElementFilter(t.getValue(), args));
            } else if (t.getType() == TokenType.TT_OPEN_BR) {
                t = this.lexer.expect1(TokenType.TT_IDENTIFIER, TokenType.TT_ATTRIBUTE);
                Token equals = this.lexer.expect1r0(TokenType.TT_EQUALS, TokenType.TT_PREFIXMATCH, TokenType.TT_SUBSTRINGMATCH, TokenType.TT_SUFFIXMATCH);
                Argument arg = null;
                if (equals != null) {
                    arg = this.collectArgument();
                }
                selector.addFilter(new AttributeFilter(t.getValue(), arg, equals != null ? equals.getValue() : null));
                this.lexer.expect1(TokenType.TT_CLOSE_BR);
            }
            t = this.lexer.expect1r0(TokenType.TT_ID, TokenType.TT_PSEUDO_CLASS, TokenType.TT_PSEUDO_CLASS_ARGS, TokenType.TT_PSEUDO_ELEMENT, TokenType.TT_PSEUDO_ELEMENT_ARGS, TokenType.TT_OPEN_BR, TokenType.TT_WHITESPACE);
        }
        return selector;
    }

    private Argument[] collectArguments() {
        Token t;
        ArrayList<Argument> args = new ArrayList<Argument>();
        do {
            args.add(this.collectArgument());
        } while ((t = this.lexer.expect1(TokenType.TT_COMMA, TokenType.TT_CLOSE_PAREN)).getType() != TokenType.TT_CLOSE_PAREN);
        return args.toArray(new Argument[args.size()]);
    }

    public Argument collectArgument() {
        Token t = this.lexer.expect1(TokenType.TT_BOOLEAN, TokenType.TT_INTEGER, TokenType.TT_STRING, TokenType.TT_NUMBER);
        Argument arg = t.getType() == TokenType.TT_BOOLEAN ? new Argument(Boolean.valueOf(t.getValue())) : (t.getType() == TokenType.TT_INTEGER ? new Argument(Integer.parseInt(t.getValue())) : (t.getType() == TokenType.TT_NUMBER ? new Argument(Double.parseDouble(t.getValue())) : new Argument(t.getValue())));
        return arg;
    }
}

