/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.NoSuchWindowException;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.css.ParserException;
import net.sourceforge.marathon.javaagent.css.PseudoClassFilter;
import net.sourceforge.marathon.javaagent.css.Selector;
import net.sourceforge.marathon.javaagent.css.SelectorFilter;
import org.json.JSONException;

public class SimpleSelector
implements Selector {
    public static final Logger LOGGER = Logger.getLogger(SimpleSelector.class.getName());
    private String tag;
    private List<SelectorFilter> filters = new ArrayList<SelectorFilter>();
    private PseudoClassFilter nthFilter = null;

    public SimpleSelector(String tag) {
        this.tag = tag;
    }

    public void addFilter(SelectorFilter filter) {
        if (this.nthFilter != null) {
            throw new ParserException("Only a single nth psuedoclass may be specified and it should be the last one", null);
        }
        if (filter instanceof PseudoClassFilter && ((PseudoClassFilter)filter).isNth()) {
            this.nthFilter = (PseudoClassFilter)filter;
        } else {
            this.filters.add(filter);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tag);
        for (SelectorFilter selectorFilter : this.filters) {
            sb.append(selectorFilter.toString());
        }
        if (this.nthFilter != null) {
            sb.append(this.nthFilter.toString());
        }
        return sb.toString();
    }

    @Override
    public List<IJavaElement> findElements(final IJavaAgent driver, final IJavaElement container, long implicitWait) {
        final Object[] r = new Object[]{null};
        if (implicitWait == 0L) {
            EventQueueWait.exec(new Runnable(){

                @Override
                public void run() {
                    try {
                        r[0] = SimpleSelector.this.found(container, driver);
                    }
                    catch (NoSuchWindowException e) {
                        r[0] = e;
                    }
                    catch (UnsupportedCommandException e) {
                        r[0] = e;
                    }
                    catch (JSONException e) {
                        r[0] = e;
                    }
                    catch (Exception e) {
                        r[0] = e;
                    }
                }
            });
        } else {
            new EventQueueWait(){

                @Override
                public boolean till() {
                    try {
                        List<IJavaElement> list;
                        r[0] = list = SimpleSelector.this.found(container, driver);
                        return list.size() > 0;
                    }
                    catch (NoSuchWindowException e) {
                        r[0] = e;
                        return true;
                    }
                    catch (UnsupportedCommandException e) {
                        r[0] = e;
                        return true;
                    }
                    catch (JSONException e) {
                        r[0] = e;
                        return true;
                    }
                    catch (Exception e) {
                        r[0] = e;
                        return true;
                    }
                }
            }.wait_noexc("Unable to find component", implicitWait, 50L);
        }
        if (r[0] instanceof NoSuchWindowException) {
            throw (NoSuchWindowException)r[0];
        }
        if (r[0] instanceof UnsupportedCommandException) {
            throw (UnsupportedCommandException)r[0];
        }
        if (r[0] instanceof JSONException) {
            throw (JSONException)r[0];
        }
        if (r[0] instanceof RuntimeException) {
            throw (RuntimeException)r[0];
        }
        if (r[0] instanceof Exception) {
            throw new RuntimeException(((Exception)r[0]).getMessage(), (Exception)r[0]);
        }
        List list = (List)r[0];
        return list;
    }

    public List<IJavaElement> found(IJavaElement self, IJavaAgent driver) {
        ArrayList<IJavaElement> cs = new ArrayList<IJavaElement>();
        if (this.tag.equals(".")) {
            cs.addAll(this.filterMatches(self));
        } else {
            this.findByTagName(self, cs, driver, false);
        }
        JavaTargetLocator.JWindow topContainer = driver.switchTo().getCurrentWindow();
        ArrayList<IJavaElement> r = new ArrayList<IJavaElement>();
        for (IJavaElement component : cs) {
            r.add(topContainer.addElement(component));
        }
        if (this.nthFilter != null) {
            if (this.nthFilter.getNthIndex() - 1 < r.size()) {
                return Arrays.asList((IJavaElement)r.get(this.nthFilter.getNthIndex() - 1));
            }
            return new ArrayList<IJavaElement>();
        }
        return r;
    }

    private void findByTagName(IJavaElement je, List<IJavaElement> cs, IJavaAgent driver, boolean addThis) {
        IJavaElement[] components;
        if (addThis) {
            cs.addAll(this.matchesSelector(je));
        }
        for (IJavaElement javaElement : components = je.getComponents()) {
            this.findByTagName(javaElement, cs, driver, true);
        }
    }

    public List<IJavaElement> matchesSelector(IJavaElement je) {
        if ("*".equals(this.tag) || this.tag.equals(je.getTagName())) {
            return this.filterMatches(je);
        }
        return new ArrayList<IJavaElement>();
    }

    private List<IJavaElement> filterMatches(IJavaElement je) {
        List<IJavaElement> elements = Arrays.asList(je);
        for (SelectorFilter f : this.filters) {
            ArrayList<IJavaElement> toProcess = new ArrayList<IJavaElement>();
            for (IJavaElement javaElement : elements) {
                toProcess.addAll(f.match(javaElement));
            }
            elements = toProcess;
        }
        return elements;
    }
}

