/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.script;

import java.awt.Component;
import java.lang.reflect.Array;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaAgentException;
import net.sourceforge.marathon.javaagent.script.ScriptExecutor;
import net.sourceforge.marathon.javaagent.server.ExecuteMode;
import net.sourceforge.marathon.javaagent.server.Session;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONScriptRunner {
    public static final Logger LOGGER = Logger.getLogger(JSONScriptRunner.class.getName());
    private String script;
    private Object[] args;
    private Session session;
    private ExecuteMode mode;

    public JSONScriptRunner(String script, JSONArray args, Session session, ExecuteMode mode) {
        this.script = script;
        this.session = session;
        this.mode = mode;
        this.convertJSONArgs(args);
    }

    private void convertJSONArgs(JSONArray jsonArgs) {
        this.args = new Object[jsonArgs.length()];
        for (int i = 0; i < jsonArgs.length(); ++i) {
            Object jsonArg = jsonArgs.get(i);
            this.args[i] = this.convertToJava(jsonArg);
        }
    }

    private Object convertToJava(Object jsonArg) {
        if (jsonArg instanceof Boolean || jsonArg instanceof Integer || jsonArg instanceof Long || jsonArg instanceof Double || jsonArg instanceof String) {
            return jsonArg;
        }
        if (jsonArg instanceof JSONArray) {
            Object[] r = new Object[((JSONArray)jsonArg).length()];
            for (int i = 0; i < r.length; ++i) {
                r[i] = this.convertToJava(((JSONArray)jsonArg).get(i));
            }
            return r;
        }
        if (jsonArg instanceof JSONObject && ((JSONObject)jsonArg).has("ELEMENT")) {
            return this.session.findElement(((JSONObject)jsonArg).getString("ELEMENT")).getComponent();
        }
        throw new RuntimeException("Argument of type `" + jsonArg.getClass() + "` not supported: " + jsonArg);
    }

    public Object execute() {
        ScriptExecutor se = new ScriptExecutor(this.mode);
        try {
            if (this.script.equals("return window.name")) {
                return null;
            }
            return this.convertToJson(se.executeScript(this.script, this.args));
        }
        catch (Exception e) {
            throw new JavaAgentException("Script execution failed with an exception (" + e.getMessage() + ")", e);
        }
    }

    private Object convertToJson(Object jsonArg) {
        if (jsonArg == null) {
            return null;
        }
        if (jsonArg instanceof Boolean || jsonArg instanceof Integer || jsonArg instanceof Long || jsonArg instanceof Double || jsonArg instanceof String) {
            return jsonArg;
        }
        if (jsonArg.getClass().isArray()) {
            JSONArray a = new JSONArray();
            for (int i = 0; i < Array.getLength(jsonArg); ++i) {
                a.put(this.convertToJson(Array.get(jsonArg, i)));
            }
            return a;
        }
        if (jsonArg instanceof Component) {
            IJavaElement e = this.session.findElement((Component)jsonArg);
            return new JSONObject().put("ELEMENT", e.getId());
        }
        return jsonArg.toString();
    }
}

