/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.script;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javax.swing.SwingUtilities;
import net.sourceforge.marathon.javaagent.JavaAgentException;
import net.sourceforge.marathon.javaagent.server.ExecuteMode;

public class ScriptExecutor {
    public static final Logger LOGGER = Logger.getLogger(ScriptExecutor.class.getName());
    private ExecuteMode mode;
    private Object result;
    private boolean callback = false;
    private static final String CLASS_PREFIX = "MarathonExecScript";
    private static int count = 0;

    public ScriptExecutor(ExecuteMode mode) {
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(String methodBody, final Object[] args) throws CannotCompileException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, InterruptedException {
        ClassPool cp = ClassPool.getDefault();
        cp.importPackage("javax.swing");
        cp.importPackage("java.lang.reflect.Array");
        CtClass helloClass = cp.makeClass(ScriptExecutor.getClassName());
        CtMethod make = CtNewMethod.make(this.getMethodBody(args), helloClass);
        if (!methodBody.endsWith(";")) {
            methodBody = methodBody + ";";
        }
        make.insertBefore(methodBody);
        Logger.getLogger(ScriptExecutor.class.getName()).log(Level.INFO, "Method Body:\n" + methodBody);
        helloClass.addMethod(make);
        final Class<?> helloClazz = helloClass.toClass();
        final Method declaredMethod = helloClazz.getDeclaredMethod("execute", this.getMethodParams(args));
        if (this.mode == ExecuteMode.ASYNC) {
            final Object[] newArgs = new Object[args.length + 1];
            System.arraycopy(args, 0, newArgs, 0, args.length);
            newArgs[args.length] = new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void call(Object o) {
                    ScriptExecutor.this.result = o;
                    ScriptExecutor.this.callback = true;
                    ScriptExecutor scriptExecutor = ScriptExecutor.this;
                    synchronized (scriptExecutor) {
                        ScriptExecutor.this.notifyAll();
                    }
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new Runnable(){

                        @Override
                        public void run() {
                            try {
                                declaredMethod.invoke(helloClazz.getConstructor(new Class[0]).newInstance(new Object[0]), newArgs);
                            }
                            catch (Exception e) {
                                ScriptExecutor.this.result = e;
                            }
                        }
                    }.run();
                }
            });
            ScriptExecutor scriptExecutor = this;
            synchronized (scriptExecutor) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException e) {
                    this.result = e;
                }
            }
            if (!this.callback) {
                throw new JavaAgentException("Expected callback not occured. Use $2.call(...) to perform callback", null);
            }
            return this.result;
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    ScriptExecutor.this.result = declaredMethod.invoke(helloClazz.newInstance(), args);
                }
                catch (Exception e) {
                    ScriptExecutor.this.result = e;
                }
            }
        });
        return this.result;
    }

    public static String getClassName() {
        return CLASS_PREFIX + count++;
    }

    public Class<?>[] getMethodParams(Object[] args) {
        Class[] r = new Class[this.mode == ExecuteMode.SYNC ? args.length : args.length + 1];
        for (int i = 0; i < args.length; ++i) {
            r[i] = args[i] == null ? Object.class : (args[i].getClass().isArray() ? Object[].class : args[i].getClass());
        }
        if (this.mode == ExecuteMode.ASYNC) {
            r[args.length] = Callback.class;
        }
        return r;
    }

    public String getMethodBody(Object[] args) {
        String r = "public Object execute(" + this.getMethodArgs(args) + ")";
        Logger.getLogger(ScriptExecutor.class.getName()).log(Level.INFO, "Function signature: " + r);
        return r + " { return null ;}";
    }

    public String getMethodArgs(Object[] args) {
        int index = 0;
        StringBuilder sb = new StringBuilder();
        for (Object o : args) {
            if (o == null) {
                sb.append("Object a" + index++).append(",");
                continue;
            }
            if (o.getClass().isArray()) {
                sb.append("Object[] a" + index++).append(",");
                continue;
            }
            sb.append(o.getClass().getName() + " a" + index++).append(",");
        }
        if (this.mode == ExecuteMode.ASYNC) {
            sb.append(Callback.class.getName() + " a" + index++).append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static interface Callback {
        public void call(Object var1);
    }
}

