/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.server;

import fi.iki.elonen.NanoHTTPD;
import java.awt.AWTException;
import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.Device;
import net.sourceforge.marathon.javaagent.EventQueueWait;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.InvalidElementStateException;
import net.sourceforge.marathon.javaagent.JavaAgentException;
import net.sourceforge.marathon.javaagent.JavaAgentKeys;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.MissingCommandParametersException;
import net.sourceforge.marathon.javaagent.NoSuchElementException;
import net.sourceforge.marathon.javaagent.NoSuchWindowException;
import net.sourceforge.marathon.javaagent.Platform;
import net.sourceforge.marathon.javaagent.SessionNotCreatedException;
import net.sourceforge.marathon.javaagent.StaleElementReferenceException;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.script.JSONScriptRunner;
import net.sourceforge.marathon.javaagent.server.Base64;
import net.sourceforge.marathon.javaagent.server.ExecuteMode;
import net.sourceforge.marathon.javaagent.server.Route;
import net.sourceforge.marathon.javaagent.server.RouteMap;
import net.sourceforge.marathon.javaagent.server.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JavaServer
extends NanoHTTPD {
    public static final Logger LOGGER = Logger.getLogger(JavaServer.class.getName());
    public static final String MIME_JSON = "application/json;charset=UTF-8";
    private Session liveSession;
    private static List<RouteMap> routes;
    public static boolean handlingRequest;
    private int port;
    private static final JSONObject hasCapabilities;
    private JSONObject capabilities = new JSONObject();
    private static final String NULL_OBJECT;
    private boolean exitOnQuit;
    private static ComponentState lastComponenet;

    public JavaServer(int port) {
        this(port, false);
    }

    public JavaServer(int port, boolean exitOnQuit) {
        super(port);
        this.exitOnQuit = exitOnQuit;
        this.port = port;
        this.initCapabilities();
    }

    private void initCapabilities() {
        this.capabilities.put("browserName", "java");
        this.capabilities.put("version", "1.0");
        this.capabilities.put("platform", Platform.getCurrent().toString());
        this.capabilities.put("javascriptEnabled", true);
        this.capabilities.put("takesScreenshot", true);
        this.capabilities.put("handlesAlerts", false);
        this.capabilities.put("databaseEnabled", false);
        this.capabilities.put("locationContextEnabled", false);
        this.capabilities.put("applicationCacheEnabled", false);
        this.capabilities.put("browserConnectionEnabled", false);
        this.capabilities.put("cssSelectorsEnabled", false);
        this.capabilities.put("webStorageEnabled", false);
        this.capabilities.put("rotatable", false);
        this.capabilities.put("acceptSslCerts", false);
        this.capabilities.put("nativeEvents", false);
        this.capabilities.put("loggingPrefs", new JSONObject().put("driver", "ALL"));
    }

    public int getPort() {
        return this.port;
    }

    private static Method getMethod(String name, boolean hasEvents) {
        Method[] methods;
        for (Method method : methods = JavaServer.class.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    private static Method getMethod(String name) {
        return JavaServer.getMethod(name, false);
    }

    public Route findRoute(NanoHTTPD.Method method, String uri) {
        JSONObject params = new JSONObject();
        RouteMap map = this.findRouteMap(method, uri, params);
        if (map == null) {
            return null;
        }
        return new Route(map.getProc(), params, map);
    }

    private RouteMap findRouteMap(NanoHTTPD.Method method, String uri, JSONObject params) {
        for (RouteMap route : routes) {
            String[] expectedParts;
            String[] actualParts;
            if (!route.getMethod().equals((Object)method) || (actualParts = uri.split("/")).length != (expectedParts = route.getUri().split("/")).length) continue;
            HashMap<String, String> tParams = new HashMap<String, String>();
            boolean found = true;
            for (int i = 0; i < actualParts.length; ++i) {
                if (expectedParts[i].startsWith(":")) {
                    tParams.put(expectedParts[i].substring(1), actualParts[i]);
                    continue;
                }
                if (expectedParts[i].equals(actualParts[i])) continue;
                found = false;
                break;
            }
            if (!found) continue;
            Set entrySet = tParams.entrySet();
            for (Map.Entry entry : entrySet) {
                params.put((String)entry.getKey(), entry.getValue());
            }
            return route;
        }
        return null;
    }

    @Override
    public NanoHTTPD.Response serve(String uri, NanoHTTPD.Method method, Map<String, String> header, Map<String, String> parms, Map<String, String> files) {
        JSONObject jsonQuery = null;
        String query = files.get("postData");
        LOGGER.info("JavaServer.serve(" + (Object)((Object)method) + " " + uri + "): " + (query != null ? query : "{}"));
        if (query != null) {
            try {
                jsonQuery = new JSONObject(query);
            }
            catch (JSONException e) {
                LOGGER.info("JavaServer.serve(): " + query);
                return JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "text/html", e.getMessage());
            }
        }
        StringBuilder logmsg = new StringBuilder();
        logmsg.append((Object)((Object)method) + "(" + uri);
        if (jsonQuery != null) {
            logmsg.append(", " + jsonQuery);
        }
        logmsg.append(") = ");
        NanoHTTPD.Response response = this.serve_internal(uri, method, jsonQuery == null ? new JSONObject() : jsonQuery);
        logmsg.append(this.toString(response));
        if (this.liveSession != null && !uri.contains("/log") && Boolean.getBoolean("keepLog")) {
            this.liveSession.log(Level.INFO, logmsg.toString());
        }
        LOGGER.info(logmsg.toString());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(NanoHTTPD.Response response) {
        HashMap<String, String> r = new HashMap<String, String>();
        r.put("status", response.getStatus().toString());
        InputStream data = response.getData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int n = 1024;
        try {
            int b;
            while ((b = data.read()) != -1 && n-- > 0) {
                baos.write(b);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                data.reset();
            }
            catch (IOException iOException) {}
        }
        if (n <= 0) {
            r.put("data", new String(baos.toByteArray()) + "...");
        } else {
            r.put("data", new String(baos.toByteArray()));
        }
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)r).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NanoHTTPD.Response serve_internal(String uri, NanoHTTPD.Method method, JSONObject jsonQuery) {
        handlingRequest = true;
        try {
            Route route = this.findRoute(method, uri);
            if (route != null && route.getProc() != null) {
                NanoHTTPD.Response response = this.handleRoute(route, jsonQuery);
                return response;
            }
            if (route == null) {
                NanoHTTPD.Response response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", "Not Implemented: (route is null)");
                return response;
            }
            NanoHTTPD.Response response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "Not Implemented: route = " + route);
            return response;
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            e.printStackTrace();
            NanoHTTPD.Response response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "text/html", "");
            return response;
        }
        finally {
            handlingRequest = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NanoHTTPD.Response handleRoute(Route route, JSONObject query) {
        NanoHTTPD.Response response;
        JSONObject r = new JSONObject();
        r.put("name", route.getProc().getName());
        r.put("status", 0);
        try {
            Object result;
            JSONObject uriParams = route.getParams();
            Session session = null;
            if (uriParams.has("sessionId") && this.liveSession != null && this.liveSession.getID().equals(uriParams.get("sessionId"))) {
                session = this.liveSession;
            }
            if (session != null) {
                r.put("sessionId", session.getID());
            }
            IJavaElement element = null;
            if (uriParams.has("id")) {
                if (session == null) {
                    throw new SessionNotCreatedException("Invalid Session ID", null);
                }
                element = session.findElement(uriParams.getString("id"));
            }
            JavaTargetLocator.JWindow window = null;
            if (uriParams.has("windowHandle")) {
                if (session == null) {
                    throw new SessionNotCreatedException("Invalid Session ID", null);
                }
                window = session.getWindow(uriParams.getString("windowHandle"));
            }
            if ((result = this.invoke(route, query, uriParams, session, window, element)) instanceof NanoHTTPD.Response) {
                NanoHTTPD.Response response2 = (NanoHTTPD.Response)result;
                return response2;
            }
            if (result == null || result == NULL_OBJECT) {
                r.put("value", (Object)null);
            } else {
                r.put("value", result);
            }
            NanoHTTPD.Response response3 = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, MIME_JSON, r.toString());
            return response3;
        }
        catch (NoSuchWindowException e) {
            r.put("status", 23);
            r.put("value", new JSONObject().put("message", e.getMessage()).put("stackTrace", this.getStackTrace(e)));
            response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, MIME_JSON, r.toString());
            return response;
        }
        catch (NoSuchElementException e) {
            r.put("status", 7);
            r.put("value", new JSONObject().put("message", e.getMessage()).put("stackTrace", this.getStackTrace(e)));
            response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, MIME_JSON, r.toString());
            return response;
        }
        catch (MissingCommandParametersException e) {
            response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "text/plain", e.getMessage());
            return response;
        }
        catch (UnsupportedCommandException e) {
            response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, "text/plain", e.getMessage());
            return response;
        }
        catch (InvalidElementStateException e) {
            r.put("status", 12);
            r.put("value", new JSONObject().put("message", e.getMessage()).put("stackTrace", this.getStackTrace(e)));
            response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, MIME_JSON, r.toString());
            return response;
        }
        catch (StaleElementReferenceException e) {
            r.put("status", 10);
            r.put("value", new JSONObject().put("message", e.getMessage()).put("stackTrace", this.getStackTrace(e)));
            response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, MIME_JSON, r.toString());
            return response;
        }
        catch (SessionNotCreatedException e) {
            r.put("status", 33);
            r.put("value", new JSONObject().put("message", e.getMessage()).put("stackTrace", this.getStackTrace(e)));
            response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, MIME_JSON, r.toString());
            return response;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            r.put("status", 13);
            r.put("value", new JSONObject().put("message", e.getClass().getName() + ":" + e.getMessage()).put("stackTrace", this.getStackTrace(e)));
            response = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, MIME_JSON, r.toString());
            return response;
        }
        finally {
            this.afterEvent();
        }
    }

    private void afterEvent() {
        EventQueueWait.empty();
    }

    private JSONArray getStackTrace(Throwable e) {
        JSONArray trace = new JSONArray();
        while (e != null) {
            StackTraceElement[] stackTrace;
            for (StackTraceElement ste : stackTrace = e.getStackTrace()) {
                try {
                    trace.put(new JSONObject().put("fileName", ste.getFileName()).put("className", ste.getClassName()).put("methodName", ste.getMethodName()).put("lineNumber", ste.getLineNumber()));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            e = e.getCause();
        }
        return trace;
    }

    public Object invoke(Route route, JSONObject query, JSONObject uriParams, Session session, JavaTargetLocator.JWindow window, IJavaElement element) {
        Object result;
        try {
            result = session == null ? route.getProc().invoke((Object)this, query, uriParams) : (element != null ? route.getProc().invoke((Object)this, query, uriParams, session, element) : (window != null ? route.getProc().invoke((Object)this, query, uriParams, session, window) : route.getProc().invoke((Object)this, query, uriParams, session)));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MissingCommandParametersException) {
                throw (MissingCommandParametersException)cause;
            }
            if (cause instanceof JSONException) {
                throw (JSONException)cause;
            }
            if (cause instanceof NoSuchElementException) {
                throw (NoSuchElementException)cause;
            }
            if (cause instanceof NoSuchWindowException) {
                throw (NoSuchWindowException)cause;
            }
            if (cause instanceof UnsupportedCommandException) {
                throw (UnsupportedCommandException)cause;
            }
            if (cause instanceof InvalidElementStateException) {
                throw (InvalidElementStateException)cause;
            }
            if (cause instanceof StaleElementReferenceException) {
                throw (StaleElementReferenceException)cause;
            }
            if (cause instanceof SessionNotCreatedException) {
                throw (SessionNotCreatedException)cause;
            }
            if (cause instanceof JavaAgentException) {
                throw (JavaAgentException)cause;
            }
            throw new JavaAgentException(cause.getMessage(), cause);
        }
        catch (IllegalArgumentException e) {
            throw new JavaAgentException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new JavaAgentException(e.getMessage(), e);
        }
        return result;
    }

    public NanoHTTPD.Response createSession(JSONObject query, JSONObject uriParams) {
        if (this.liveSession == null) {
            Session session;
            String okCaps;
            JSONObject desired = null;
            if (query.has("desiredCapabilities")) {
                desired = (JSONObject)query.get("desiredCapabilities");
            }
            if ((okCaps = this.hasCapabilities(desired, desired)) != null) {
                throw new SessionNotCreatedException(okCaps, null);
            }
            Device.Type t = Device.Type.EVENT_QUEUE;
            if (this.capabilities.getBoolean("nativeEvents")) {
                t = Device.Type.ROBOT;
            }
            LOGGER.info("Creating device with type: " + (Object)((Object)t));
            this.liveSession = session = new Session(t);
            session.setLogLevel(this.getLogLevel(query));
            session.log(Level.INFO, "A new session created. sessionID = " + session.getID());
        }
        try {
            Session session = this.liveSession;
            NanoHTTPD.Response r = JavaServer.newFixedLengthResponse(NanoHTTPD.Response.Status.REDIRECT, "text/html", null);
            r.addHeader("Location", new URL("http", "localhost", this.port, "/session/" + session.getID()).toString());
            return r;
        }
        catch (MalformedURLException e) {
            throw new JavaAgentException(e.getMessage(), e);
        }
    }

    public JSONArray getSessions(JSONObject query, JSONObject uriParams) {
        JSONArray r = new JSONArray();
        JSONObject o = new JSONObject();
        o.put("id", this.liveSession.getID());
        o.put("capabilities", hasCapabilities);
        r.put(o);
        return r;
    }

    private Level getLogLevel(JSONObject query) {
        JSONObject prefs;
        if (query.has("requiredCapabilities") && query.getJSONObject("requiredCapabilities").has("loggingPrefs")) {
            prefs = query.getJSONObject("requiredCapabilities").getJSONObject("loggingPrefs");
        } else if (query.has("desiredCapabilities") && query.getJSONObject("desiredCapabilities").has("loggingPrefs")) {
            prefs = query.getJSONObject("desiredCapabilities").getJSONObject("loggingPrefs");
        } else {
            return Level.ALL;
        }
        if (prefs.has("driver")) {
            return Level.parse(prefs.getString("driver"));
        }
        return Level.ALL;
    }

    private String hasCapabilities(JSONObject required, JSONObject desired) {
        String error;
        if (required != null && (error = this.updateCapabilities(required)) != null) {
            return error;
        }
        error = this.updateCapabilities(desired);
        if (error != null) {
            LOGGER.warning("Desired Capabilities did not match: " + error);
        }
        return null;
    }

    public String updateCapabilities(JSONObject caps) {
        Iterator<String> keys = caps.keys();
        while (keys.hasNext()) {
            Object lvalue;
            String key = keys.next();
            if (!hasCapabilities.has(key)) {
                return "Do not have the capability by name " + key;
            }
            Object rvalue = caps.get(key);
            this.capabilities.put(key, rvalue);
            if (rvalue instanceof Boolean && !((Boolean)rvalue).booleanValue() || (lvalue = hasCapabilities.get(key)).equals(rvalue) || key.equals("loggingPrefs")) continue;
            if (key.equals("platform")) {
                Platform lPlatform = Platform.valueOf((String)lvalue);
                Platform rPlatform = Platform.valueOf((String)rvalue);
                if (rPlatform.is(lPlatform)) continue;
            }
            if (key.equals("version") && rvalue.equals("")) continue;
            return "Java Driver does not support `" + key + "`" + (rvalue instanceof Boolean ? "" : " for value " + rvalue);
        }
        return null;
    }

    public JSONObject getCapabilities(JSONObject query, JSONObject uriParams, Session session) {
        return this.capabilities;
    }

    public JSONObject findElement(JSONObject query, JSONObject uriParams, Session session) {
        this.checkRequiredArguments(query, "using", "value");
        IJavaElement e = session.findElement(query.getString("using"), query.getString("value"));
        return new JSONObject().put("ELEMENT", e.getHandle());
    }

    public String getElementName(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        return element.getTagName();
    }

    public JSONObject getElementLocation(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        return new JSONObject(element.getLocation());
    }

    public String[] toStringArray(JSONArray value) {
        String[] s = new String[value.length()];
        for (int i = 0; i < value.length(); ++i) {
            s[i] = value.getString(i);
        }
        return s;
    }

    public void closeSession(JSONObject query, JSONObject uriParams, Session session) {
        session.deleteWindow();
    }

    public JSONObject getElementSize(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        return new JSONObject(element.getSize());
    }

    public String getElementAttribute(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        String attribute = null;
        try {
            attribute = element.getAttribute(URLDecoder.decode(uriParams.getString("name"), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (attribute == null) {
            return NULL_OBJECT;
        }
        return attribute;
    }

    public JSONObject getStatus(JSONObject query, JSONObject uriParams) {
        JSONObject v = new JSONObject();
        JSONObject os = new JSONObject();
        os.put("arch", System.getProperty("os.arch", "unknown"));
        os.put("name", System.getProperty("os.name", "unknown"));
        os.put("version", System.getProperty("os.version", "unknown"));
        v.put("os", os);
        JSONObject build = new JSONObject();
        build.put("version", "1.0");
        return v.put("build", build);
    }

    public JSONObject getInfo(JSONObject query, JSONObject uriParams) {
        JSONObject v = new JSONObject();
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        v.put("boot-class-path", bean.getBootClassPath());
        v.put("start-time", bean.getStartTime());
        v.put("commandline", System.getProperty("sun.java.command"));
        return v;
    }

    public JSONArray getWindowHandles(JSONObject query, JSONObject uriParams, Session session) {
        return new JSONArray(session.getWindowHandles());
    }

    public void getWindow(JSONObject query, JSONObject uriParams, Session session) {
        this.checkRequiredArguments(query, "name");
        session.window(query.getString("name"));
    }

    public void setImplicitTimeout(JSONObject query, JSONObject uriParams, Session session) {
        this.checkRequiredArguments(query, "ms");
        session.setTimeout(query.getLong("ms"));
    }

    public void setTimeouts(JSONObject query, JSONObject uriParams, Session session) {
        this.checkRequiredArguments(query, "ms");
        session.setTimeout(query.getLong("ms"));
    }

    public void quitSession(JSONObject query, JSONObject uriParams, Session session) {
        if (this.exitOnQuit) {
            session.quit();
        }
        this.liveSession = null;
    }

    public String getWindowHandle(JSONObject query, JSONObject uriParams, Session session) {
        return session.getWindowHandle();
    }

    public JSONObject getWindowSize(JSONObject query, JSONObject uriParams, Session session, JavaTargetLocator.JWindow window) {
        return new JSONObject(window.getSize());
    }

    public JSONObject getWindowPosition(JSONObject query, JSONObject uriParams, Session session, JavaTargetLocator.JWindow window) {
        return new JSONObject(window.getLocation());
    }

    public void setWindowSize(JSONObject query, JSONObject uriParams, Session session, JavaTargetLocator.JWindow window) {
        this.checkRequiredArguments(query, "width", "height");
        window.setSize(query.getInt("width"), query.getInt("height"));
    }

    public void setWindowPosition(JSONObject query, JSONObject uriParams, Session session, JavaTargetLocator.JWindow window) {
        this.checkRequiredArguments(query, "x", "y");
        window.setLocation(query.getInt("x"), query.getInt("y"));
    }

    public void maximizeWindow(JSONObject query, JSONObject uriParams, Session session, JavaTargetLocator.JWindow window) {
        window.maximize();
    }

    public String getWindowTitle(JSONObject query, JSONObject uriParams, Session session) {
        String title = session.getTitle();
        if (title == null) {
            return NULL_OBJECT;
        }
        return title;
    }

    public String getElementText(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        String text = element.getAttribute("text");
        if (text == null) {
            return NULL_OBJECT;
        }
        return text;
    }

    public JSONArray findElements(JSONObject query, JSONObject uriParams, Session session) {
        this.checkRequiredArguments(query, "using", "value");
        JSONArray r = new JSONArray();
        List<IJavaElement> es = session.findElements(query.getString("using"), query.getString("value"));
        for (IJavaElement e : es) {
            r.put(new JSONObject().put("ELEMENT", e.getHandle()));
        }
        return r;
    }

    public JSONObject findActiveElement(JSONObject query, JSONObject uriParams, Session session) {
        IJavaElement e = session.getActiveElement();
        return new JSONObject().put("ELEMENT", e.getHandle());
    }

    public JSONObject findElementOfElement(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        this.checkRequiredArguments(query, "using", "value");
        IJavaElement e = session.findElement(element, query.getString("using"), query.getString("value"));
        return new JSONObject().put("ELEMENT", e.getHandle());
    }

    public JSONArray findElementsOfElement(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        this.checkRequiredArguments(query, "using", "value");
        JSONArray r = new JSONArray();
        List<IJavaElement> es = session.findElements(element, query.getString("using"), query.getString("value"));
        for (IJavaElement e : es) {
            r.put(new JSONObject().put("ELEMENT", e.getHandle()));
        }
        return r;
    }

    public void clearElement(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        element.clear();
    }

    public boolean isSelected(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        return element.isSelected();
    }

    public boolean isEnabled(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        return element.isEnabled();
    }

    public boolean isDisplayed(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        return element.isDisplayed();
    }

    public boolean elementEquals(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        IJavaElement other = session.findElement(uriParams.getString("other"));
        return element.equals(other);
    }

    public JSONArray getLogTypes(JSONObject query, JSONObject uriParams, Session session) {
        return new JSONArray().put("driver");
    }

    public JSONArray getLogs(JSONObject query, JSONObject uriParams, Session session) {
        this.checkRequiredArguments(query, "type");
        JSONArray logEntries = new JSONArray();
        if ("driver".equals(query.getString("type"))) {
            session.fillLog(logEntries);
        }
        return logEntries;
    }

    public String getWindowProperties(JSONObject query, JSONObject uriParams, Session session) {
        JSONObject props = session.getWindowProperties();
        return props.toString();
    }

    public void moveto(JSONObject query, JSONObject uriParams, Session session) {
        int yoffset;
        int xoffset;
        boolean hasOffset;
        IJavaElement element = null;
        if (query.has("element")) {
            element = session.findElement(query.getString("element"));
        }
        if ((hasOffset = query.has("xoffset")) != query.has("yoffset")) {
            throw new MissingCommandParametersException("Missing x-offset or y-offset. Provide both x and y offsets.", null);
        }
        if (element == null && !hasOffset) {
            throw new MissingCommandParametersException("One of the element or offset is expected.", null);
        }
        if (hasOffset) {
            xoffset = query.getInt("xoffset");
            yoffset = query.getInt("yoffset");
        } else {
            Point p = element.getMidpoint();
            xoffset = p.x;
            yoffset = p.y;
        }
        if (element == null) {
            if (hasOffset && JavaServer.lastComponenet.element != null) {
                element = JavaServer.lastComponenet.element;
                xoffset += JavaServer.lastComponenet.x;
                yoffset += JavaServer.lastComponenet.y;
            } else {
                element = session.getActiveElement();
            }
        }
        element.moveto(xoffset, yoffset);
        JavaServer.lastComponenet.x = xoffset;
        JavaServer.lastComponenet.y = yoffset;
        JavaServer.lastComponenet.element = element;
    }

    public void clickElement(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        if (JavaServer.lastComponenet.element != null && JavaServer.lastComponenet.element.equals(element)) {
            element.click(0, 1, JavaServer.lastComponenet.x, JavaServer.lastComponenet.y);
        } else {
            Point p = element.getMidpoint();
            element.click(0, 1, p.x, p.y);
            JavaServer.lastComponenet.element = element;
            JavaServer.lastComponenet.x = p.x;
            JavaServer.lastComponenet.y = p.y;
        }
    }

    public void click(JSONObject query, JSONObject uriParams, Session session) {
        int button = 0;
        if (query.has("button")) {
            button = query.getInt("button");
        }
        this.click(session, button, 1);
    }

    public void submitElement(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        element.submit();
    }

    public void sendKeysElement(JSONObject query, JSONObject uriParams, Session session, IJavaElement element) {
        this.checkRequiredArguments(query, "value");
        JSONArray value = query.getJSONArray("value");
        value.put(JavaAgentKeys.NULL.subSequence(0, 1));
        element.sendKeys(this.toStringArray(value));
    }

    public void sendKeys(JSONObject query, JSONObject uriParams, Session session) {
        this.checkRequiredArguments(query, "value");
        IJavaElement element = null;
        element = JavaServer.lastComponenet.element != null ? JavaServer.lastComponenet.element : session.getActiveElement();
        element.sendKeys(this.toStringArray(query.getJSONArray("value")));
    }

    public void buttondown(JSONObject query, JSONObject uriParams, Session session) {
        int yoffset;
        int xoffset;
        int button = 0;
        if (query != null && query.has("button")) {
            button = query.getInt("button");
        }
        IJavaElement element = null;
        if (JavaServer.lastComponenet.element != null) {
            element = JavaServer.lastComponenet.element;
            xoffset = JavaServer.lastComponenet.x;
            yoffset = JavaServer.lastComponenet.y;
        } else {
            element = session.getActiveElement();
            Point p = element.getMidpoint();
            xoffset = p.x;
            yoffset = p.y;
        }
        element.buttonDown(button, xoffset, yoffset);
    }

    public void buttonup(JSONObject query, JSONObject uriParams, Session session) {
        int yoffset;
        int xoffset;
        int button = 0;
        if (query.has("button")) {
            button = query.getInt("button");
        }
        IJavaElement element = null;
        if (JavaServer.lastComponenet.element != null) {
            element = JavaServer.lastComponenet.element;
            xoffset = JavaServer.lastComponenet.x;
            yoffset = JavaServer.lastComponenet.y;
        } else {
            element = session.getActiveElement();
            Point p = element.getMidpoint();
            xoffset = p.x;
            yoffset = p.y;
        }
        element.buttonUp(button, xoffset, yoffset);
    }

    public void doubleclick(JSONObject query, JSONObject uriParams, Session session) {
        this.click(session, 0, 2);
    }

    private void click(Session session, int button, int clickCount) {
        int yoffset;
        int xoffset;
        IJavaElement element = null;
        if (JavaServer.lastComponenet.element != null) {
            element = JavaServer.lastComponenet.element;
            xoffset = JavaServer.lastComponenet.x;
            yoffset = JavaServer.lastComponenet.y;
        } else {
            element = session.getActiveElement();
            Point p = element.getMidpoint();
            xoffset = p.x;
            yoffset = p.y;
        }
        element.click(button, clickCount, xoffset, yoffset);
    }

    public Object execute(JSONObject query, JSONObject uriParams, Session session) {
        this.checkRequiredArguments(query, "script", "args");
        JSONScriptRunner scriptRunner = new JSONScriptRunner(query.getString("script"), query.getJSONArray("args"), session, ExecuteMode.SYNC);
        return scriptRunner.execute();
    }

    public Object executeAsync(JSONObject query, JSONObject uriParams, Session session) {
        this.checkRequiredArguments(query, "script", "args");
        JSONScriptRunner scriptRunner = new JSONScriptRunner(query.getString("script"), query.getJSONArray("args"), session, ExecuteMode.ASYNC);
        return scriptRunner.execute();
    }

    private void checkRequiredArguments(JSONObject query, String ... args) {
        for (String arg : args) {
            if (query.has(arg)) continue;
            throw new MissingCommandParametersException("Required parameter `" + arg + "` is missing", null);
        }
    }

    public String getScreenShot(JSONObject query, JSONObject uriParams, Session session) throws AWTException, IOException {
        return Base64.encodeToString(session.getScreenShot(), false);
    }

    static {
        hasCapabilities = new JSONObject();
        NULL_OBJECT = new String();
        try {
            hasCapabilities.put("browserName", "java");
            hasCapabilities.put("version", "1.0");
            hasCapabilities.put("platform", Platform.getCurrent().toString());
            hasCapabilities.put("javascriptEnabled", true);
            hasCapabilities.put("takesScreenshot", true);
            hasCapabilities.put("handlesAlerts", false);
            hasCapabilities.put("databaseEnabled", false);
            hasCapabilities.put("locationContextEnabled", false);
            hasCapabilities.put("applicationCacheEnabled", false);
            hasCapabilities.put("browserConnectionEnabled", false);
            hasCapabilities.put("cssSelectorsEnabled", false);
            hasCapabilities.put("webStorageEnabled", false);
            hasCapabilities.put("rotatable", false);
            hasCapabilities.put("acceptSslCerts", false);
            hasCapabilities.put("nativeEvents", true);
            hasCapabilities.put("loggingPrefs", new JSONObject().put("driver", "ALL"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        routes = new ArrayList<RouteMap>();
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/status", JavaServer.getMethod("getStatus")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session", JavaServer.getMethod("createSession")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/sessions", JavaServer.getMethod("getSessions")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId", JavaServer.getMethod("getCapabilities")));
        routes.add(new RouteMap(NanoHTTPD.Method.DELETE, "/session/:sessionId", JavaServer.getMethod("quitSession")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/timeouts", JavaServer.getMethod("setTimeouts")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/timeouts/async_script"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/timeouts/implicit_wait", JavaServer.getMethod("setImplicitTimeout")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/window_handle", JavaServer.getMethod("getWindowHandle")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/window_handles", JavaServer.getMethod("getWindowHandles")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/url", JavaServer.getMethod("getWindowProperties")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/url"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/forward"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/back"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/refresh"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/execute", JavaServer.getMethod("execute")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/execute_async", JavaServer.getMethod("executeAsync")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/screenshot", JavaServer.getMethod("getScreenShot")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/ime/available_engines"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/ime/active_engine"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/ime/activated"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/ime/deactivate"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/ime/activate"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/frame"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/window", JavaServer.getMethod("getWindow")));
        routes.add(new RouteMap(NanoHTTPD.Method.DELETE, "/session/:sessionId/window", JavaServer.getMethod("closeSession")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/window/:windowHandle/size", JavaServer.getMethod("setWindowSize", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/window/:windowHandle/size", JavaServer.getMethod("getWindowSize")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/window/:windowHandle/position", JavaServer.getMethod("setWindowPosition", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/window/:windowHandle/position", JavaServer.getMethod("getWindowPosition")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/window/:windowHandle/maximize", JavaServer.getMethod("maximizeWindow", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/cookie"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/cookie"));
        routes.add(new RouteMap(NanoHTTPD.Method.DELETE, "/session/:sessionId/cookie"));
        routes.add(new RouteMap(NanoHTTPD.Method.DELETE, "/session/:sessionId/cookie/:name"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/source"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/title", JavaServer.getMethod("getWindowTitle")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/element", JavaServer.getMethod("findElement")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/elements", JavaServer.getMethod("findElements")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/element/active", JavaServer.getMethod("findActiveElement")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/element/:id/element", JavaServer.getMethod("findElementOfElement")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/element/:id/elements", JavaServer.getMethod("findElementsOfElement")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/element/:id/click", JavaServer.getMethod("clickElement", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/element/:id/submit", JavaServer.getMethod("submitElement", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/text", JavaServer.getMethod("getElementText")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/element/:id/value", JavaServer.getMethod("sendKeysElement", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/keys", JavaServer.getMethod("sendKeys", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/name", JavaServer.getMethod("getElementName")));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/element/:id/clear", JavaServer.getMethod("clearElement")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/selected", JavaServer.getMethod("isSelected")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/enabled", JavaServer.getMethod("isEnabled")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/attribute/:name", JavaServer.getMethod("getElementAttribute")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/equals/:other", JavaServer.getMethod("elementEquals")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/displayed", JavaServer.getMethod("isDisplayed")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/location", JavaServer.getMethod("getElementLocation")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/location_in_view"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/size", JavaServer.getMethod("getElementSize")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/element/:id/css/:propertyName"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/orientation"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/orientation"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/alert_text"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/alert_text"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/accept_alert"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/dismiss_alert"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/moveto", JavaServer.getMethod("moveto", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/click", JavaServer.getMethod("click", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/buttondown", JavaServer.getMethod("buttondown", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/buttonup", JavaServer.getMethod("buttonup", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/doubleclick", JavaServer.getMethod("doubleclick", true)));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/touch/click"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/touch/down"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/touch/up"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "session/:sessionId/touch/move"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "session/:sessionId/touch/scroll"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "session/:sessionId/touch/scroll"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "session/:sessionId/touch/doubleclick"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "session/:sessionId/touch/longclick"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "session/:sessionId/touch/flick"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "session/:sessionId/touch/flick"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/location"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/location"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/local_storage"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/local_storage"));
        routes.add(new RouteMap(NanoHTTPD.Method.DELETE, "/session/:sessionId/local_storage"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/local_storage/key/:key"));
        routes.add(new RouteMap(NanoHTTPD.Method.DELETE, "/session/:sessionId/local_storage/key/:key"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/local_storage/size"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/session_storage"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/session_storage"));
        routes.add(new RouteMap(NanoHTTPD.Method.DELETE, "/session/:sessionId/session_storage"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/session_storage/key/:key"));
        routes.add(new RouteMap(NanoHTTPD.Method.DELETE, "/session/:sessionId/session_storage/key/:key"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/session_storage/size"));
        routes.add(new RouteMap(NanoHTTPD.Method.POST, "/session/:sessionId/log", JavaServer.getMethod("getLogs")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/log/types", JavaServer.getMethod("getLogTypes")));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/session/:sessionId/application_cache/status"));
        routes.add(new RouteMap(NanoHTTPD.Method.GET, "/info", JavaServer.getMethod("getInfo")));
        lastComponenet = new ComponentState();
    }

    private static class ComponentState {
        public IJavaElement element;
        public int x;
        public int y;

        private ComponentState() {
        }
    }
}

