/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javaagent.server;

import java.awt.AWTException;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.Device;
import net.sourceforge.marathon.javaagent.IJavaAgent;
import net.sourceforge.marathon.javaagent.IJavaElement;
import net.sourceforge.marathon.javaagent.JavaAgent;
import net.sourceforge.marathon.javaagent.JavaTargetLocator;
import net.sourceforge.marathon.javaagent.UnsupportedCommandException;
import net.sourceforge.marathon.javaagent.server.LogEntry;
import org.json.JSONArray;
import org.json.JSONObject;

public class Session {
    public static final Logger LOGGER = Logger.getLogger(Session.class.getName());
    private String id;
    private IJavaAgent agent;
    private List<LogEntry> logEntries = new ArrayList<LogEntry>();
    private Level logLevel = Level.ALL;

    public Session(Device.Type type) {
        this.id = UUID.randomUUID().toString();
        this.agent = new JavaAgent(type);
    }

    public void log(Level level, String message) {
        if (level.intValue() >= this.logLevel.intValue()) {
            this.logEntries.add(new LogEntry(level, message));
        }
    }

    public String getID() {
        return this.id;
    }

    public Collection<String> getWindowHandles() {
        return this.agent.getWindowHandles();
    }

    public void deleteWindow() {
        this.agent.deleteWindow();
    }

    public void window(String name) {
        this.agent.switchTo().window(name);
    }

    public void setTimeout(long millis) {
        this.agent.manage().timeouts().implicitlyWait(millis, TimeUnit.MILLISECONDS);
    }

    public String getWindowHandle() {
        return this.agent.getWindowHandle();
    }

    public String getTitle() {
        return this.agent.getTitle();
    }

    public IJavaElement findElement(String using, String value) {
        if ("name".equals(using)) {
            return this.agent.findElementByName(value);
        }
        if ("tag name".equals(using)) {
            return this.agent.findElementByTagName(value);
        }
        if ("css selector".equals(using)) {
            return this.agent.findElementByCssSelector(value);
        }
        if ("class name".equals(using)) {
            return this.agent.findElementByClassName(value);
        }
        if ("id".equals(using)) {
            return this.agent.findElementByName(value);
        }
        throw new UnsupportedCommandException("Unsupported look up strategy " + using, null);
    }

    public IJavaElement findElement(String id) {
        return this.agent.findElement(id);
    }

    public List<IJavaElement> findElements(String using, String value) {
        if ("name".equals(using)) {
            return this.agent.findElementsByName(value);
        }
        if ("tag name".equals(using)) {
            return this.agent.findElementsByTagName(value);
        }
        if ("css selector".equals(using)) {
            return this.agent.findElementsByCssSelector(value);
        }
        if ("class name".equals(using)) {
            return this.agent.findElementsByClassName(value);
        }
        if ("id".equals(using)) {
            return this.agent.findElementsByName(value);
        }
        throw new UnsupportedCommandException("Unsupported look up strategy " + using, null);
    }

    public IJavaElement getActiveElement() {
        return this.agent.getActiveElement();
    }

    public IJavaElement findElement(IJavaElement parent, String using, String value) {
        if ("name".equals(using)) {
            return parent.findElementByName(value);
        }
        if ("tag name".equals(using)) {
            return parent.findElementByTagName(value);
        }
        if ("css selector".equals(using)) {
            return parent.findElementByCssSelector(value);
        }
        if ("class name".equals(using)) {
            return parent.findElementByClassName(value);
        }
        if ("id".equals(using)) {
            return parent.findElementByName(value);
        }
        throw new UnsupportedCommandException("Unsupported look up strategy " + using, null);
    }

    public List<IJavaElement> findElements(IJavaElement parent, String using, String value) {
        if ("name".equals(using)) {
            return parent.findElementsByName(value);
        }
        if ("tag name".equals(using)) {
            return parent.findElementsByTagName(value);
        }
        if ("css selector".equals(using)) {
            return parent.findElementsByCssSelector(value);
        }
        if ("class name".equals(using)) {
            return parent.findElementsByClassName(value);
        }
        if ("id".equals(using)) {
            return parent.findElementsByName(value);
        }
        throw new UnsupportedCommandException("Unsupported look up strategy " + using, null);
    }

    public void fillLog(JSONArray dest) {
        for (LogEntry logEntry : this.logEntries) {
            dest.put(new JSONObject().put("level", logEntry.getLevel()).put("timestamp", logEntry.getTimestamp()).put("message", logEntry.getMessage()));
        }
        this.logEntries.clear();
    }

    public void quit() {
        this.agent.quit();
    }

    public JavaTargetLocator.JWindow getWindow(String windowHandle) {
        if ("current".equals(windowHandle)) {
            return this.agent.getCurrentWindow();
        }
        return this.agent.getWindow(windowHandle);
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public JSONObject getWindowProperties() {
        return this.agent.getWindowProperties();
    }

    public IJavaElement findElement(Component component) {
        return this.agent.findElement(component);
    }

    public byte[] getScreenShot() throws AWTException, IOException {
        return this.agent.getScreenShot();
    }
}

