/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javadriver;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;

public class ClassPathHelper {
    public static final Logger LOGGER = Logger.getLogger(ClassPathHelper.class.getName());

    public static String getClassPath(Class<?> klass) {
        String packageName = klass.getPackage().getName();
        return ClassPathHelper.getClassPath(packageName, klass.getName());
    }

    private static String getClassPath(String packageName, String name) {
        int index;
        name = name.replace('.', '/');
        URL url = ClassPathHelper.class.getResource("/" + name + ".class");
        if (url == null) {
            return null;
        }
        String resource = null;
        try {
            resource = URLDecoder.decode(url.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        if (resource.startsWith("jar:")) {
            resource = resource.substring(4);
        }
        if (resource.startsWith("file:")) {
            resource = resource.substring(5);
        }
        if ((index = resource.indexOf(33)) != -1) {
            resource = resource.substring(0, index);
        } else {
            String packagePath = packageName.replace('.', '/');
            index = resource.indexOf(packagePath);
            if (index != -1) {
                resource = resource.substring(0, index - 1);
            }
        }
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            resource = resource.substring(1);
        }
        return resource.replace('/', File.separatorChar);
    }

    public static String getClassPath(String name) {
        int lastIndexOf = name.lastIndexOf(46);
        String packageName = lastIndexOf == -1 ? "" : name.substring(0, lastIndexOf);
        return ClassPathHelper.getClassPath(packageName, name);
    }
}

