/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javadriver;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.server.JavaServer;
import net.sourceforge.marathon.javadriver.JavaProfile;

public class EmbeddedServer {
    public static final Logger LOGGER = Logger.getLogger(EmbeddedServer.class.getName());
    private NanoHTTPD javaServer;
    private JavaProfile profile;

    public EmbeddedServer(JavaProfile profile) {
        this.profile = profile;
    }

    public void start(int port) throws IOException {
        if (this.profile.getLaunchType() == JavaProfile.LaunchType.SWING_APPLICATION) {
            this.javaServer = new JavaServer(port);
            this.javaServer.start();
        } else {
            try {
                this.javaServer = (NanoHTTPD)Class.forName("net.sourceforge.marathon.javafxagent.server.JavaServer").getConstructor(Integer.TYPE).newInstance(port);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to instantiate JavaServer", t);
            }
            this.javaServer.start();
        }
    }

    public void stop() {
        if (this.javaServer != null) {
            this.javaServer.stop();
        }
    }
}

