/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javadriver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class FindResources {
    public static final Logger LOGGER = Logger.getLogger(FindResources.class.getName());

    public static Collection<String> getResources(Pattern pattern) {
        String[] classPathElements;
        ArrayList<String> retval = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(File.pathSeparator)) {
            retval.addAll(FindResources.getResources(element, pattern));
        }
        return retval;
    }

    private static Collection<String> getResources(String element, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File file = new File(element);
        if (!file.exists()) {
            return retval;
        }
        if (file.isDirectory()) {
            retval.addAll(FindResources.getResourcesFromDirectory(file, pattern));
        } else {
            retval.addAll(FindResources.getResourcesFromJarFile(file, pattern));
        }
        return retval;
    }

    private static Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ZipFile zf;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            retval.add(fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return retval;
    }

    private static Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    retval.addAll(FindResources.getResourcesFromDirectory(file, pattern));
                    continue;
                }
                try {
                    String fileName = file.getCanonicalPath();
                    boolean accept = pattern.matcher(fileName).matches();
                    if (!accept) continue;
                    retval.add(fileName);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }
        return retval;
    }

    public static Collection<String> findClasses(String klassName) {
        Pattern pattern = Pattern.compile(".*" + klassName + "\\.class$");
        Collection<String> list = FindResources.getResources(pattern);
        ArrayList<String> classes = new ArrayList<String>();
        for (String name : list) {
            classes.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        return classes;
    }

    public static void main(String[] args) {
        String klassName = args.length > 1 ? args[0] : "Player";
        Collection<String> classes = FindResources.findClasses(klassName);
        Logger.getLogger(FindResources.class.getName()).info(classes.toString());
    }
}

