/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javadriver;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import net.sourceforge.marathon.javadriver.JavaDriverCommandExecutor;
import net.sourceforge.marathon.javadriver.JavaProfile;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;

public class JavaDriver
extends RemoteWebDriver {
    public static final Logger LOGGER = Logger.getLogger(JavaDriver.class.getName());

    public JavaDriver() {
        this((Capabilities)JavaDriver.defaultCapabilities());
    }

    public JavaDriver(Capabilities desiredCapabilities) {
        this(desiredCapabilities, null);
    }

    public JavaDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(JavaDriver.extractProfile(desiredCapabilities, requiredCapabilities), desiredCapabilities, requiredCapabilities);
    }

    public JavaDriver(JavaProfile profile) {
        this(profile, JavaDriver.defaultCapabilities());
    }

    public JavaDriver(JavaProfile profile, DesiredCapabilities desiredCapabilities) {
        this(profile, (Capabilities)JavaDriver.defaultCapabilities(), null);
    }

    public JavaDriver(JavaProfile profile, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        super((CommandExecutor)new JavaDriverCommandExecutor(profile), JavaDriver.dropCapabilities(desiredCapabilities, "version"));
    }

    private static Capabilities dropCapabilities(Capabilities capabilities, String ... keysToRemove) {
        if (capabilities == null) {
            return new DesiredCapabilities();
        }
        final HashSet toRemove = Sets.newHashSet((Object[])keysToRemove);
        DesiredCapabilities caps = new DesiredCapabilities(Maps.filterKeys((Map)capabilities.asMap(), (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return !toRemove.contains(key);
            }
        }));
        return caps;
    }

    private static JavaProfile extractProfile(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        JavaProfile javaProfile = new JavaProfile();
        if (requiredCapabilities == null) {
            return javaProfile;
        }
        return javaProfile;
    }

    public static DesiredCapabilities defaultCapabilities() {
        return new DesiredCapabilities("java", "1.0", Platform.ANY);
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        String base64 = (String)this.execute("screenshot").getValue();
        return (X)target.convertFromBase64Png(base64);
    }

    public void clearlogs(String logType) {
        Logs logs = this.manage().logs();
        logs.get(logType);
    }

    public void quit() {
        try {
            super.quit();
        }
        catch (Throwable throwable) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    protected void finalize() throws Throwable {
        this.quit();
    }
}

