/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javadriver;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import net.sourceforge.marathon.javaagent.Wait;
import net.sourceforge.marathon.javadriver.EmbeddedServer;
import net.sourceforge.marathon.javadriver.JavaProfile;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;

public class JavaDriverCommandExecutor
extends HttpCommandExecutor {
    public static final Logger LOGGER = Logger.getLogger(JavaDriverCommandExecutor.class.getName());
    private static final String MARATHON_APPLICATION_DONT_MONITOR = "marathon.application.dont.monitor";
    private EmbeddedServer server;
    private JavaProfile profile;
    private boolean started;

    public JavaDriverCommandExecutor(JavaProfile profile) {
        super(JavaDriverCommandExecutor.getURL(profile));
        this.profile = profile;
        this.started = false;
    }

    private static URL getURL(JavaProfile profile) {
        try {
            return new URL("http", "localhost", profile.getPort(), "/");
        }
        catch (MalformedURLException e) {
            throw new WebDriverException("Unable to create URL for the server", (Throwable)e);
        }
    }

    public void start() {
        if (this.profile.isEmbedded()) {
            if (this.server != null) {
                return;
            }
            int port = this.getAddressOfRemoteServer().getPort();
            this.server = new EmbeddedServer(this.profile);
            try {
                this.server.start(port);
            }
            catch (IOException e) {
                throw new WebDriverException("Unable to start the server on port " + port, (Throwable)e);
            }
        }
        final CommandLine command = this.profile.getCommandLine();
        LOGGER.info("Executing: " + command);
        command.copyOutputTo(this.profile.getOutputStream());
        command.executeAsync();
        try {
            new Wait(){

                public boolean until() {
                    if (JavaDriverCommandExecutor.this.isConnected()) {
                        return true;
                    }
                    if (!command.isRunning()) {
                        return !JavaDriverCommandExecutor.this.profile.isJavaWebStart() && !JavaDriverCommandExecutor.this.profile.isCommandLine() && !Boolean.getBoolean(JavaDriverCommandExecutor.MARATHON_APPLICATION_DONT_MONITOR);
                    }
                    return false;
                }
            }.wait("Unable to estabilsh connection with the application", Long.getLong("marathon.application.wait", 150000L).longValue());
        }
        catch (Exception e) {
            LOGGER.warning("Unable to estabilsh connection with the application(timeout): " + command);
            if (command.isRunning()) {
                command.destroy();
            }
            throw e;
        }
        if (!this.isConnected()) {
            if (command.isRunning()) {
                command.destroy();
                LOGGER.warning("Unable to estabilsh connection with the application: " + command);
                throw new WebDriverException("Unable to estabilsh connection with the application");
            }
            LOGGER.warning("The application exited before establishing the connection: " + command);
            throw new WebDriverException("The application exited before establishing the connection");
        }
    }

    public boolean isConnected() {
        try {
            this.getAddressOfRemoteServer().openConnection().connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        this.server = null;
    }

    public Response execute(Command command) throws IOException {
        if (!this.started) {
            this.start();
            this.started = true;
        }
        if ("quit".equals(command.getName())) {
            this.stop();
        }
        return super.execute(command);
    }
}

