/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javadriver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.marathon.javaagent.JavaAgent;
import net.sourceforge.marathon.javadriver.ClassPathHelper;
import net.sourceforge.marathon.javadriver.FindResources;
import net.sourceforge.marathon.javafxagent.JavaFXAgent;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.CommandLine;

public class JavaProfile {
    public static final Logger LOGGER = Logger.getLogger(JavaProfile.class.getName());
    private static final String PROP_HOME = "marathon.home";
    private static final String MARATHON_AGENT = "marathon.agent";
    private static final String MARATHON_RECORDER = "marathon.recorder";
    private static Map<String, File> jnlpFiles = new HashMap<String, File>();
    private static final File NULLFILE = new File("");
    private List<String> classPathEntries = new ArrayList<String>();
    private List<String> vmArguments = new ArrayList<String>();
    private List<String> wsArguments = new ArrayList<String>();
    private List<String> appArguments = new ArrayList<String>();
    private LaunchMode launchMode;
    private LaunchType launchType = LaunchType.SWING_APPLICATION;
    private String mainClass;
    private String jnlpPath;
    private int port;
    private String startWindowTitle;
    private String workingDirectory;
    private String vmCommand;
    private String command;
    private String appletURL;
    private static String dirOfMarathonJavaDriverJar = ClassPathHelper.getClassPath(JavaProfile.class.getName());
    private boolean keepLog = false;
    private int recordingPort = -1;
    private OutputStream outputStream;
    private String javaHome;
    private boolean nativeEvents;
    private String executableJar;
    private boolean jnlpNoLocalCopy;

    public JavaProfile() {
        this(LaunchMode.EMBEDDED);
    }

    public JavaProfile(LaunchMode launchMode) {
        this.launchMode = launchMode;
        this.port = this.findPort();
    }

    public JavaProfile(URL url) throws URISyntaxException {
        this.parse(url);
        this.port = this.findPort();
    }

    public int getPort() {
        return this.port;
    }

    public CommandLine getCommandLine() {
        if (this.launchMode == LaunchMode.JAVA_COMMAND_LINE) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.findJavaBinary());
            if (this.classPathEntries.size() > 0) {
                args.add("-cp");
                args.add(this.getClassPath());
            }
            args.add(this.mainClass);
            args.addAll(this.appArguments);
            CommandLine commandLine = new CommandLine(args.toArray(new String[args.size()]));
            this.setToolOptions(commandLine);
            if (this.javaHome != null) {
                commandLine.setEnvironmentVariable("JAVA_HOME", this.javaHome);
            }
            if (this.workingDirectory != null) {
                commandLine.setWorkingDirectory(this.workingDirectory);
            }
            if (this.outputStream != null) {
                commandLine.copyOutputTo(this.outputStream);
            }
            return commandLine;
        }
        if (this.launchMode == LaunchMode.JAVA_WEBSTART) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.findJavaWSBinary());
            args.addAll(this.wsArguments);
            if (this.jnlpPath == null) {
                throw new WebDriverException("You must set either JNLP URL or File");
            }
            args.add(this.getLocalCopy(this.jnlpPath));
            CommandLine commandLine = new CommandLine(args.toArray(new String[args.size()]));
            this.setToolOptions(commandLine);
            if (this.javaHome != null) {
                commandLine.setEnvironmentVariable("JAVA_HOME", this.javaHome);
            }
            if (this.workingDirectory != null) {
                commandLine.setWorkingDirectory(this.workingDirectory);
            }
            if (this.outputStream != null) {
                commandLine.copyOutputTo(this.outputStream);
            }
            return commandLine;
        }
        if (this.launchMode == LaunchMode.JAVA_APPLET) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.findAppletViewerBinary());
            if (this.appletURL != null) {
                args.add(this.appletURL);
            }
            CommandLine commandLine = new CommandLine(args.toArray(new String[args.size()]));
            this.setToolOptions(commandLine);
            if (this.javaHome != null) {
                commandLine.setEnvironmentVariable("JAVA_HOME", this.javaHome);
            }
            if (this.workingDirectory != null) {
                commandLine.setWorkingDirectory(this.workingDirectory);
            }
            if (this.outputStream != null) {
                commandLine.copyOutputTo(this.outputStream);
            }
            return commandLine;
        }
        if (this.launchMode == LaunchMode.COMMAND_LINE) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.command);
            args.addAll(this.appArguments);
            CommandLine commandLine = new CommandLine(args.toArray(new String[args.size()]));
            if (this.javaHome != null) {
                commandLine.setEnvironmentVariable("JAVA_HOME", this.javaHome);
            }
            this.setToolOptions(commandLine);
            if (this.workingDirectory != null) {
                commandLine.setWorkingDirectory(this.workingDirectory);
            }
            if (this.outputStream != null) {
                commandLine.copyOutputTo(this.outputStream);
            }
            return commandLine;
        }
        if (this.launchMode == LaunchMode.EXECUTABLE_JAR) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.findJavaBinary());
            args.add("-jar");
            args.add(this.executableJar);
            args.addAll(this.appArguments);
            CommandLine commandLine = new CommandLine(args.toArray(new String[args.size()]));
            if (this.javaHome != null) {
                commandLine.setEnvironmentVariable("JAVA_HOME", this.javaHome);
            }
            this.setToolOptions(commandLine);
            if (this.workingDirectory != null) {
                commandLine.setWorkingDirectory(this.workingDirectory);
            }
            if (this.outputStream != null) {
                commandLine.copyOutputTo(this.outputStream);
            }
            return commandLine;
        }
        return null;
    }

    public JavaProfile addClassPath(File ... jarOrDirs) {
        this.checkValidProperty("classpath");
        for (File jarOrDir : jarOrDirs) {
            if (!jarOrDir.exists()) {
                throw new WebDriverException(String.format("But unable to locate the requested jar or folder: %s", jarOrDir));
            }
            this.classPathEntries.add(jarOrDir.getAbsolutePath());
        }
        return this;
    }

    public JavaProfile addClassPath(String ... jarOrDirs) {
        this.checkValidProperty("classpath");
        for (String s : jarOrDirs) {
            if (!s.matches(".*%[^%]*%.*") && !new File(s).exists()) {
                throw new WebDriverException(String.format("But unable to locate the requested jar or folder: %s", new File(s)));
            }
            this.classPathEntries.add(s);
        }
        return this;
    }

    public JavaProfile addVMArgument(String ... arg) {
        this.checkValidProperty("vmargument");
        for (String a : arg) {
            this.vmArguments.add(a);
        }
        return this;
    }

    public JavaProfile addWSArgument(String ... arg) {
        this.checkValidProperty("wsargument");
        for (String a : arg) {
            this.wsArguments.add(a);
        }
        return this;
    }

    public JavaProfile addApplicationArguments(String ... arg) {
        this.checkValidProperty("appargument");
        for (String a : arg) {
            this.appArguments.add(a);
        }
        return this;
    }

    public JavaProfile setMainClass(String mainClass) {
        this.checkValidProperty("mainclass");
        this.mainClass = mainClass;
        return this;
    }

    public JavaProfile setJNLPPath(String url) {
        this.checkValidProperty("jnlppath");
        this.jnlpPath = url;
        return this;
    }

    public JavaProfile setAppletURL(String url) {
        this.checkValidProperty("appleturl");
        this.appletURL = url;
        return this;
    }

    public JavaProfile setStartWindowTitle(String title) {
        this.checkValidProperty("startwindowtitle");
        this.startWindowTitle = title;
        return this;
    }

    public JavaProfile setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public JavaProfile setCommand(String c) {
        this.checkValidProperty("command");
        this.command = c;
        return this;
    }

    public void setRecordingPort(int recordingPort) {
        this.recordingPort = recordingPort;
    }

    public String getURL() {
        return "http://localhost:" + this.getPort();
    }

    public void copyOutputTo(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            return System.err;
        }
        return this.outputStream;
    }

    public JavaProfile setJavaHome(String javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public JavaProfile setJavaCommand(String vmCommand) {
        this.vmCommand = vmCommand;
        return this;
    }

    public URL asURL() throws URISyntaxException, IOException {
        int i;
        URIBuilder builder = new URIBuilder("http://javaprofile");
        builder.addParameter("launchmode", this.launchMode.name());
        for (i = 1; i <= this.appArguments.size(); ++i) {
            builder.addParameter("arg" + i, this.appArguments.get(i - 1));
        }
        if (this.command != null) {
            builder.addParameter("command", this.command);
        }
        if (this.startWindowTitle != null) {
            builder.addParameter("swt", this.startWindowTitle);
        }
        if (this.javaHome != null) {
            builder.addParameter("javahome", this.javaHome);
        }
        if (this.vmCommand != null) {
            builder.addParameter("vmcommand", this.vmCommand);
        }
        for (i = 1; i <= this.vmArguments.size(); ++i) {
            builder.addParameter("vmarg" + i, this.vmArguments.get(i - 1));
        }
        for (i = 1; i <= this.classPathEntries.size(); ++i) {
            builder.addParameter("cp" + i, this.classPathEntries.get(i - 1));
        }
        if (this.mainClass != null) {
            builder.addParameter("mainclass", this.mainClass);
        }
        for (i = 1; i <= this.wsArguments.size(); ++i) {
            builder.addParameter("wsarg" + i, this.wsArguments.get(i - 1));
        }
        if (this.jnlpPath != null) {
            builder.addParameter("jnlp", this.jnlpPath);
        }
        builder.addParameter("jnlpNoLocalCopy", Boolean.toString(this.jnlpNoLocalCopy));
        if (this.appletURL != null) {
            builder.addParameter("appleturl", this.appletURL);
        }
        if (this.nativeEvents) {
            builder.addParameter("nativeevents", this.nativeEvents + "");
        }
        if (this.executableJar != null) {
            builder.addParameter("executablejar", this.executableJar);
        }
        if (this.launchType != null) {
            builder.addParameter("launchtype", this.launchType.name());
        }
        builder.addParameter("keepLog", Boolean.toString(this.keepLog));
        return builder.build().toURL();
    }

    public void setNativeEvents(boolean nativeEvents) {
        this.nativeEvents = nativeEvents;
    }

    public String toString() {
        return "JavaProfile [classPathEntries=" + this.classPathEntries + ", vmArguments=" + this.vmArguments + ", wsArguments=" + this.wsArguments + ", appArguments=" + this.appArguments + ", launchMode=" + (Object)((Object)this.launchMode) + ", mainClass=" + this.mainClass + ", jnlpPath=" + this.jnlpPath + ", jnlpNoLocalCopy = " + this.jnlpNoLocalCopy + ", port=" + this.port + ", startWindowTitle=" + this.startWindowTitle + ", workingDirectory=" + this.workingDirectory + ", vmCommand=" + this.vmCommand + ", command=" + this.command + ", appletURL=" + this.appletURL + ", recordingPort=" + this.recordingPort + ", javaHome=" + this.javaHome + ", nativeEvents=" + this.nativeEvents + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appArguments == null ? 0 : this.appArguments.hashCode());
        result = 31 * result + (this.appletURL == null ? 0 : this.appletURL.hashCode());
        result = 31 * result + (this.classPathEntries == null ? 0 : this.classPathEntries.hashCode());
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.javaHome == null ? 0 : this.javaHome.hashCode());
        result = 31 * result + (this.jnlpPath == null ? 0 : this.jnlpPath.hashCode());
        result = 31 * result + (this.jnlpNoLocalCopy ? 0 : 1);
        result = 31 * result + (this.launchMode == null ? 0 : this.launchMode.hashCode());
        result = 31 * result + (this.mainClass == null ? 0 : this.mainClass.hashCode());
        result = 31 * result + (this.nativeEvents ? 1231 : 1237);
        result = 31 * result + (this.startWindowTitle == null ? 0 : this.startWindowTitle.hashCode());
        result = 31 * result + (this.vmArguments == null ? 0 : this.vmArguments.hashCode());
        result = 31 * result + (this.vmCommand == null ? 0 : this.vmCommand.hashCode());
        result = 31 * result + (this.workingDirectory == null ? 0 : this.workingDirectory.hashCode());
        result = 31 * result + (this.wsArguments == null ? 0 : this.wsArguments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaProfile other = (JavaProfile)obj;
        if (this.appArguments == null ? other.appArguments != null : !this.appArguments.equals(other.appArguments)) {
            return false;
        }
        if (this.appletURL == null ? other.appletURL != null : !this.appletURL.equals(other.appletURL)) {
            return false;
        }
        if (this.classPathEntries == null ? other.classPathEntries != null : !this.classPathEntries.equals(other.classPathEntries)) {
            return false;
        }
        if (this.command == null ? other.command != null : !this.command.equals(other.command)) {
            return false;
        }
        if (this.javaHome == null ? other.javaHome != null : !this.javaHome.equals(other.javaHome)) {
            return false;
        }
        if (this.jnlpPath == null ? other.jnlpPath != null : !this.jnlpPath.equals(other.jnlpPath)) {
            return false;
        }
        if (this.jnlpNoLocalCopy != other.jnlpNoLocalCopy) {
            return false;
        }
        if (this.launchMode != other.launchMode) {
            return false;
        }
        if (this.mainClass == null ? other.mainClass != null : !this.mainClass.equals(other.mainClass)) {
            return false;
        }
        if (this.nativeEvents != other.nativeEvents) {
            return false;
        }
        if (this.startWindowTitle == null ? other.startWindowTitle != null : !this.startWindowTitle.equals(other.startWindowTitle)) {
            return false;
        }
        if (this.vmArguments == null ? other.vmArguments != null : !this.vmArguments.equals(other.vmArguments)) {
            return false;
        }
        if (this.vmCommand == null ? other.vmCommand != null : !this.vmCommand.equals(other.vmCommand)) {
            return false;
        }
        if (this.workingDirectory == null ? other.workingDirectory != null : !this.workingDirectory.equals(other.workingDirectory)) {
            return false;
        }
        return !(this.wsArguments == null ? other.wsArguments != null : !this.wsArguments.equals(other.wsArguments));
    }

    public boolean isNativeEvents() {
        return this.nativeEvents;
    }

    public JavaProfile setExecutableJar(String jar) {
        this.checkValidProperty("executablejar");
        this.executableJar = jar;
        return this;
    }

    public boolean isEmbedded() {
        return this.launchMode == LaunchMode.EMBEDDED;
    }

    public boolean isCommandLine() {
        return this.launchMode == LaunchMode.COMMAND_LINE;
    }

    public boolean isJavaCommandLine() {
        return this.launchMode == LaunchMode.JAVA_COMMAND_LINE;
    }

    public boolean isExecutableJar() {
        return this.launchMode == LaunchMode.EXECUTABLE_JAR;
    }

    public boolean isJavaApplet() {
        return this.launchMode == LaunchMode.JAVA_APPLET;
    }

    public boolean isJavaWebStart() {
        return this.launchMode == LaunchMode.JAVA_WEBSTART;
    }

    public JavaProfile setLaunchType(LaunchType launchType) {
        this.launchType = launchType;
        return this;
    }

    public LaunchType getLaunchType() {
        return this.launchType;
    }

    public void setKeepLog(boolean keepLog) {
        this.keepLog = keepLog;
    }

    public JavaProfile setJNLPNoLocalCopy(boolean jnlpNoLocalCopy) {
        this.checkValidProperty("jnlpnolocalcopy");
        this.jnlpNoLocalCopy = jnlpNoLocalCopy;
        return this;
    }

    private int findPort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e1) {
            throw new WebDriverException("Could not allocate a port: " + e1.getMessage());
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setToolOptions(CommandLine commandLine) {
        StringBuilder java_tool_options = new StringBuilder();
        java_tool_options.append("-DkeepLog=" + Boolean.toString(this.keepLog)).append(" ");
        java_tool_options.append("-Dmarathon.launch.mode=" + this.launchMode.getName()).append(" ");
        java_tool_options.append("-Dmarathon.mode=" + (this.recordingPort != -1 ? "recording" : "playing")).append(" ");
        if (this.startWindowTitle != null) {
            java_tool_options.append("-Dstart.window.title=\"" + this.startWindowTitle).append("\" ");
        }
        if (LaunchMode.JAVA_WEBSTART == this.launchMode || LaunchMode.JAVA_APPLET == this.launchMode) {
            java_tool_options.append("-Dmarathon.agent=" + this.getAgentJarURL()).append(" ");
        }
        java_tool_options.append("-javaagent:\"" + this.getAgentJar() + "\"=" + this.port).append(" ");
        if (this.recordingPort != -1) {
            if (LaunchMode.JAVA_WEBSTART == this.launchMode || LaunchMode.JAVA_APPLET == this.launchMode) {
                java_tool_options.append("-Dmarathon.recorder=" + this.getRecorderJarURL()).append(" ");
            }
            java_tool_options.append(" -javaagent:\"" + this.getRecorderJar() + "\"=" + this.recordingPort).append(" ");
        }
        this.addExtensions(java_tool_options);
        for (String vmArg : this.vmArguments) {
            java_tool_options.append("\"" + vmArg + "\"").append(" ");
        }
        if (System.getProperty("java.util.logging.config.file") != null) {
            java_tool_options.append("-Djava.util.logging.config.file=\"" + System.getProperty("java.util.logging.config.file") + "\" ");
        }
        if (System.getProperty("marathon.project.dir") != null) {
            java_tool_options.append("-Dmarathon.project.dir=\"" + System.getProperty("marathon.project.dir") + "\" ");
        }
        java_tool_options.setLength(java_tool_options.length() - 1);
        if (java_tool_options.length() > 1023) {
            throw new RuntimeException("JAVA_TOOL_OPTIONS is more than 1023 bytes. Move marathon installation to a shorter path");
        }
        String currentOptions = System.getenv("JAVA_TOOL_OPTIONS");
        if (currentOptions != null) {
            commandLine.setEnvironmentVariable("USER_JTO", currentOptions);
        }
        commandLine.setEnvironmentVariable("JAVA_TOOL_OPTIONS", java_tool_options.toString());
    }

    private String getRecorderJar() {
        if (System.getenv("marathon.recorder.file") != null) {
            return System.getenv("marathon.recorder.file");
        }
        if (System.getProperty("marathon.recorder.file") != null) {
            return System.getProperty("marathon.recorder.file");
        }
        String prefix = this.launchType.getPrefix();
        String shortName = this.launchType == LaunchType.SWING_APPLICATION ? "mjr.jar" : "mfr.jar";
        String path = JavaProfile.findFile(new String[]{".", "marathon-" + prefix + "-recorder", "../marathon-" + prefix + "-recorder", System.getProperty(PROP_HOME, "."), dirOfMarathonJavaDriverJar, System.getenv("MARATHON_HOME")}, shortName);
        if (path != null) {
            Logger.getLogger(JavaProfile.class.getName()).info("Using " + path + " for recorder");
            return path;
        }
        path = JavaProfile.findFile(new String[]{".", "marathon-" + prefix + "-recorder", "../marathon-" + prefix + "-recorder", System.getProperty(PROP_HOME, "."), dirOfMarathonJavaDriverJar, System.getenv("MARATHON_HOME")}, "marathon-" + prefix + "-recorder.*.jar");
        if (path != null) {
            Logger.getLogger(JavaProfile.class.getName()).info("Using " + path + " for recorder");
            return path;
        }
        throw new WebDriverException("Unable to find marathon-recorder.jar. Set marathon.recorder.file environment variable to point to the jar file");
    }

    private String getRecorderJarURL() {
        return this.getURL(this.getRecorderJar());
    }

    private String getURL(String path) {
        try {
            return new File(path).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return path;
        }
    }

    private String getAgentJarURL() {
        return this.getURL(this.getAgentJar());
    }

    private void addExtensions(StringBuilder sb) {
        Collection<String> classes = FindResources.findClasses("MarathonExtension");
        for (String klass : classes) {
            String classPath = ClassPathHelper.getClassPath(klass);
            if (classPath == null) continue;
            sb.append("-javaagent:\"" + classPath + "\"").append(" ");
        }
    }

    private String getAgentJar() {
        String prefix = this.launchType.getPrefix();
        if (System.getenv("marathon.agent.file") != null) {
            return System.getenv("marathon.agent.file");
        }
        if (System.getProperty("marathon.agent.file") != null) {
            return System.getProperty("marathon.agent.file");
        }
        String shortName = this.launchType == LaunchType.SWING_APPLICATION ? "mja.jar" : "mfa.jar";
        String path = JavaProfile.findFile(new String[]{".", "marathon-" + prefix + "-agent", "../marathon-" + prefix + "-agent", "../../marathon/marathon-" + prefix + "/marathon-" + prefix + "-agent", System.getProperty(PROP_HOME, "."), dirOfMarathonJavaDriverJar, System.getenv("MARATHON_HOME")}, shortName);
        if (path != null) {
            Logger.getLogger(JavaProfile.class.getName()).info("Using " + path + " for agent");
            return path;
        }
        path = JavaProfile.findFile(new String[]{".", "marathon-" + prefix + "-agent", "../marathon-" + prefix + "-agent", "../../marathon/marathon-" + prefix + "/marathon-" + prefix + "-agent", System.getProperty(PROP_HOME, "."), dirOfMarathonJavaDriverJar, System.getenv("MARATHON_HOME")}, "marathon-" + prefix + "-agent.*.jar");
        if (path != null) {
            Logger.getLogger(JavaProfile.class.getName()).info("Using " + path + " for agent");
            return path;
        }
        Class klass = null;
        klass = this.launchType == LaunchType.FX_APPLICATION ? JavaFXAgent.class : JavaAgent.class;
        path = ClassPathHelper.getClassPath(klass);
        if (path != null) {
            return path;
        }
        throw new WebDriverException("Unable to find marathon-agent.jar. Set marathon.agent.file environment variable to point to the jar file: " + new File(".").getAbsolutePath());
    }

    private static String findFile(String[] likelyPlaces, final String namePattern) {
        String path = null;
        for (String likelyPlace : likelyPlaces) {
            File[] f;
            if (likelyPlace == null || (f = new File(likelyPlace).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(namePattern);
                }
            })) == null || f.length != 1) continue;
            try {
                path = f[0].getCanonicalPath();
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return path;
    }

    private String getClassPath() {
        StringBuilder sb = new StringBuilder();
        for (String f : this.classPathEntries) {
            sb.append(f).append(File.pathSeparator);
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private String findCommand(String command) {
        if (this.vmCommand != null) {
            return this.vmCommand;
        }
        if (this.javaHome != null) {
            File homeFolder = new File(this.javaHome);
            if (!homeFolder.exists() || !homeFolder.isDirectory()) {
                throw new WebDriverException(String.format("%s: No such directory", homeFolder));
            }
            File binFolder = new File(this.javaHome, "bin");
            if (!binFolder.exists() || !binFolder.isDirectory()) {
                throw new WebDriverException(String.format("%s: No bin directory found in home directory", binFolder));
            }
            File java = new File(binFolder, Platform.getCurrent().is(Platform.WINDOWS) ? command + ".exe" : command);
            if (!java.exists() || !java.isFile()) {
                throw new WebDriverException(String.format("%s: No such file", java));
            }
            return java.getAbsolutePath();
        }
        return command;
    }

    private String findJavaBinary() {
        return this.findCommand("java");
    }

    private String findJavaWSBinary() {
        if (this.vmCommand != null) {
            return this.vmCommand;
        }
        if (Platform.getCurrent().is(Platform.MAC)) {
            return "javaws";
        }
        return this.findCommand("javaws");
    }

    private String findAppletViewerBinary() {
        return this.findCommand("appletviewer");
    }

    private void checkValidProperty(String property) {
        if (!this.launchMode.isValidProperty(property)) {
            throw new WebDriverException(property + " is not valid for " + (Object)((Object)this.launchMode));
        }
    }

    private void parse(URL url) throws URISyntaxException {
        List values = URLEncodedUtils.parse((URI)url.toURI(), (Charset)StandardCharsets.UTF_8);
        String launchModeStr = this.findValueOf(values, "launchmode");
        this.launchMode = LaunchMode.valueOf(launchModeStr);
        int i = 1;
        while (this.hasValueFor(values, "arg" + i)) {
            this.appArguments.add(this.findValueOf(values, "arg" + i));
            ++i;
        }
        if (this.hasValueFor(values, "command")) {
            this.command = this.findValueOf(values, "command");
        }
        if (this.hasValueFor(values, "executablejar")) {
            this.executableJar = this.findValueOf(values, "executablejar");
        }
        if (this.hasValueFor(values, "swt")) {
            this.startWindowTitle = this.findValueOf(values, "swt");
        }
        if (this.hasValueFor(values, "javahome")) {
            this.javaHome = this.findValueOf(values, "javahome");
        }
        if (this.hasValueFor(values, "vmcommand")) {
            this.vmCommand = this.findValueOf(values, "vmcommand");
        }
        i = 1;
        while (this.hasValueFor(values, "vmarg" + i)) {
            this.vmArguments.add(this.findValueOf(values, "vmarg" + i));
            ++i;
        }
        i = 1;
        while (this.hasValueFor(values, "cp" + i)) {
            this.classPathEntries.add(this.findValueOf(values, "cp" + i));
            ++i;
        }
        if (this.hasValueFor(values, "mainclass")) {
            this.mainClass = this.findValueOf(values, "mainclass");
        }
        i = 1;
        while (this.hasValueFor(values, "wsarg" + i)) {
            this.wsArguments.add(this.findValueOf(values, "wsarg" + i));
            ++i;
        }
        if (this.hasValueFor(values, "jnlp")) {
            this.jnlpPath = this.findValueOf(values, "jnlp");
        }
        this.jnlpNoLocalCopy = false;
        if (this.hasValueFor(values, "jnlpNoLocalCopy")) {
            this.jnlpNoLocalCopy = Boolean.parseBoolean(this.findValueOf(values, "jnlpNoLocalCopy"));
        }
        if (this.hasValueFor(values, "appleturl")) {
            this.appletURL = this.findValueOf(values, "appleturl");
        }
        if (this.hasValueFor(values, "nativeevents")) {
            this.nativeEvents = true;
        }
        if (this.hasValueFor(values, "launchtype")) {
            this.launchType = LaunchType.valueOf(this.findValueOf(values, "launchtype"));
        }
        if (this.hasValueFor(values, "keepLog")) {
            this.keepLog = Boolean.parseBoolean(this.findValueOf(values, "keepLog"));
        }
    }

    private boolean hasValueFor(List<NameValuePair> values, String name) {
        for (NameValuePair nameValuePair : values) {
            if (!nameValuePair.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String findValueOf(List<NameValuePair> values, String name) {
        for (NameValuePair nameValuePair : values) {
            if (!nameValuePair.getName().equals(name)) continue;
            return this.replaceEnviron(nameValuePair.getValue());
        }
        throw new RuntimeException("Could not find value for " + name + " in " + values);
    }

    private String replaceEnviron(String value) {
        if (value == null) {
            return null;
        }
        Pattern p = Pattern.compile("[^%]*(%[^%]*%).*");
        Matcher m = p.matcher(value);
        while (m.matches()) {
            String var = m.group(1);
            String varValue = this.replaceEnviron(System.getProperty(var.substring(1, var.length() - 1)));
            if (varValue == null && (varValue = System.getProperty(var.substring(1, var.length() - 1), null)) == null && (varValue = System.getenv(var.substring(1, var.length() - 1))) == null) {
                varValue = "";
            }
            value = value.replaceAll(var, JavaProfile.escape(varValue));
            m = p.matcher(value);
        }
        return value;
    }

    private static String escape(String value) {
        return value.replaceAll("\\\\", "\\\\\\\\");
    }

    private String getLocalCopy(String url) {
        if (this.jnlpNoLocalCopy || !this.validURL(url)) {
            return url;
        }
        File file = jnlpFiles.get(url);
        if (file == null) {
            file = this.createJNLPCopy(url);
            if (file != NULLFILE) {
                LOGGER.info("WebStart: Copied remote URL " + url + " to " + file.getAbsolutePath());
            } else {
                LOGGER.info("WebStart: Considering " + url + " as local");
            }
            jnlpFiles.put(url, file);
        }
        if (file == NULLFILE) {
            return url;
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createJNLPCopy(String urlSpec) {
        File jnlpFile = NULLFILE;
        OutputStream os = null;
        InputStream is = null;
        try {
            URL url = new URL(urlSpec);
            URLConnection openConnection = url.openConnection();
            Object content = openConnection.getContent();
            File tempFile = File.createTempFile("marathon", ".jnlp");
            tempFile.deleteOnExit();
            os = new FileOutputStream(tempFile);
            if (content instanceof InputStream) {
                int n;
                is = (InputStream)content;
                byte[] b = new byte[1024];
                while ((n = is.read(b)) != -1) {
                    os.write(b, 0, n);
                }
            }
            jnlpFile = tempFile;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return jnlpFile;
    }

    private boolean validURL(String urlPath) {
        try {
            URL url = new URL(urlPath);
            String protocol = url.getProtocol();
            return protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    static {
        File dir = new File(dirOfMarathonJavaDriverJar).getParentFile();
        dirOfMarathonJavaDriverJar = dir.exists() ? dir.getAbsolutePath() : ".";
    }

    public static enum LaunchMode {
        EMBEDDED("unittesting", "Unit Testing", new String[0]),
        JAVA_COMMAND_LINE("javacommand", "Java Command Line", "vmargument", "classpath", "mainclass", "appargument"),
        JAVA_WEBSTART("webstart", "WebStart Application", "vmargument", "wsargument", "jnlppath", "jnlpnolocalcopy", "startwindowtitle"),
        COMMAND_LINE("commandline", "Command Line", "command", "appargument", "startwindowtitle", "vmargument"),
        JAVA_APPLET("applet", "Applet Application", "vmargument", "appleturl", "startwindowtitle"),
        EXECUTABLE_JAR("executablejar", "Executable JAR", "executablejar", "appargument", "startwindowtitle", "vmargument");

        private String name;
        private String description;
        private List<String> validProperties = new ArrayList<String>();

        private LaunchMode(String name, String description, String ... validProperties) {
            this.name = name;
            this.description = description;
            for (String prop : validProperties) {
                this.validProperties.add(prop);
            }
        }

        public boolean isValidProperty(String property) {
            return this.validProperties.contains(property);
        }

        public String toString() {
            return "Launchmode " + this.description;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum LaunchType {
        SWING_APPLICATION("java"),
        FX_APPLICATION("javafx");

        private String prefix;

        private LaunchType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

