/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.marathon.javadriver;

import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import net.sourceforge.marathon.javaagent.KeysMap;
import org.json.JSONArray;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class OSUtils {
    public static final Logger LOGGER = Logger.getLogger(OSUtils.class.getName());

    public static Keys getMenuKey() {
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (keyMask == 2) {
            return Keys.CONTROL;
        }
        if (keyMask == 4) {
            return Keys.META;
        }
        if (keyMask == 8) {
            return Keys.ALT;
        }
        throw new WebDriverException("Unable to find the keymask... not control or meta?");
    }

    public static CharSequence getKeysFor(WebElement e, String keysFor) {
        String sKeyStroke = e.getAttribute("keystrokeFor-" + keysFor);
        if (sKeyStroke == null) {
            throw new WebDriverException("Unable to find keystroke for " + keysFor);
        }
        JSONArray a = new JSONArray(sKeyStroke);
        for (int i = 0; i < a.length() - 1; ++i) {
            try {
                return OSUtils.getKeys(keysFor, a.getString(i));
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return OSUtils.getKeys(keysFor, a.getString(a.length() - 1));
    }

    private static CharSequence getKeys(String keysFor, String sKeyStroke) {
        int keyCode;
        KeyStroke ks = KeyStroke.getKeyStroke(sKeyStroke);
        if (ks == null) {
            throw new WebDriverException("Unable to parse keystroke for " + keysFor + " trying to parse " + sKeyStroke);
        }
        StringBuilder sb = new StringBuilder();
        int modifiers = ks.getModifiers();
        if ((modifiers & 0x80) == 128) {
            sb.append((CharSequence)Keys.CONTROL);
        }
        if ((modifiers & 0x200) == 512) {
            sb.append((CharSequence)Keys.ALT);
        }
        if ((modifiers & 0x100) == 256) {
            sb.append((CharSequence)Keys.META);
        }
        if ((modifiers & 0x40) == 64) {
            sb.append((CharSequence)Keys.SHIFT);
        }
        if ((keyCode = ks.getKeyCode()) == 0) {
            sb.append(ks.getKeyChar());
        } else {
            sb.append(OSUtils.keyCharFromKeyCode(keyCode, keysFor));
        }
        sb.append((CharSequence)Keys.NULL);
        return sb.toString();
    }

    private static CharSequence keyCharFromKeyCode(int keyCode, String keysFor) {
        if (keyCode >= 65 && keyCode <= 90) {
            return "" + (char)(keyCode - 65 + 97);
        }
        KeysMap entry = KeysMap.findMap((int)keyCode);
        if (entry != null) {
            return entry.getKeys();
        }
        if (keyCode <= 127) {
            return "" + (char)keyCode;
        }
        throw new WebDriverException("Unable to find Keys entry for keycode " + keyCode + " for action " + keysFor);
    }
}

