/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.MinimalMonitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorConverter;
import com.jamonapi.MonitorLeafFactory;
import com.jamonapi.MonitorReportInterface;
import com.jamonapi.TimingMonitor;
import com.jamonapi.utils.AppBaseException;
import com.jamonapi.utils.Command;
import com.jamonapi.utils.CommandIterator;
import com.jamonapi.utils.CompositeNode;
import com.jamonapi.utils.LeafNode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class MonitorComposite
implements MinimalMonitor,
CompositeNode,
MonitorReportInterface {
    private static String displayDelimiter = ".";
    private Map monitorList = new TreeMap();
    private static MonitorLeafFactory leafFactory = new MonitorLeafFactory();

    public long getAccrued() {
        final class AccruedCommand
        implements Command {
            long accrued;

            public void execute(Object object) throws Exception {
                this.accrued = object instanceof TimingMonitor ? (this.accrued += ((TimingMonitor)object).childMonitor.getAccrued()) : (this.accrued += ((MonitorComposite)object).getAccrued());
            }

            AccruedCommand(MonitorComposite monitorComposite) {
            }
        }
        AccruedCommand accruedCommand = new AccruedCommand(this);
        this.iterate(accruedCommand);
        return accruedCommand.accrued;
    }

    public String toString() {
        return this.getAccruedString();
    }

    public void reset() {
        final class ResetCommand
        implements Command {
            public void execute(Object object) throws Exception {
                ((MinimalMonitor)object).reset();
            }

            ResetCommand(MonitorComposite monitorComposite) {
            }
        }
        this.iterate(new ResetCommand(this));
    }

    void iterate(Command command) {
        try {
            CommandIterator.iterate(this.monitorList.values().iterator(), command);
        }
        catch (Exception exception) {
            throw AppBaseException.getRuntimeException(exception);
        }
    }

    void iterateMapEntries(Command command) {
        try {
            CommandIterator.iterate(this.monitorList, command);
        }
        catch (Exception exception) {
            throw AppBaseException.getRuntimeException(exception);
        }
    }

    public void increase(long l) {
        final class IncreaseCommand
        implements Command {
            final /* synthetic */ long val$increaseValue;

            public void execute(Object object) throws Exception {
                ((MinimalMonitor)object).increase(this.val$increaseValue);
            }

            IncreaseCommand(MonitorComposite monitorComposite, long l) {
                this.val$increaseValue = l;
            }
        }
        this.iterate(new IncreaseCommand(this, l));
    }

    public void getData(ArrayList arrayList) {
    }

    public void getHeader(ArrayList arrayList) {
    }

    public String getReport() throws Exception {
        MonitorConverter monitorConverter = new MonitorConverter(this);
        return monitorConverter.getReport();
    }

    public String getReport(int n, String string) throws Exception {
        MonitorConverter monitorConverter = new MonitorConverter(this);
        return monitorConverter.getReport(n, string);
    }

    public String[][] getData() {
        MonitorConverter monitorConverter = new MonitorConverter(this);
        return monitorConverter.getData();
    }

    public String[][] getData(String string) {
        MonitorConverter monitorConverter = new MonitorConverter(this);
        return monitorConverter.getData(string);
    }

    public static void setDisplayDelimiter(String string) {
        displayDelimiter = string;
    }

    public CompositeNode getCompositeNode(String string) {
        if (this.compositeNodeExists(string)) {
            return this.getExistingCompositeNode(string);
        }
        return new MonitorComposite();
    }

    public LeafNode getLeafNode(String string, String string2) {
        if (this.leafNodeExists(string)) {
            TimingMonitor timingMonitor = (TimingMonitor)this.getExistingLeafNode(string);
            return timingMonitor;
        }
        return leafFactory.createInstance(string2);
    }

    public void addCompositeNode(String string, CompositeNode compositeNode) {
        boolean bl = this.compositeNodeExists(string);
        if (!bl) {
            this.monitorList.put(this.getCompositeNodeKey(string), compositeNode);
        }
    }

    public boolean leafNodeExists(String string) {
        return this.monitorList.containsKey(this.getLeafNodeKey(string));
    }

    public boolean compositeNodeExists(String string) {
        return this.monitorList.containsKey(this.getCompositeNodeKey(string));
    }

    public CompositeNode getExistingCompositeNode(String string) {
        return (CompositeNode)this.monitorList.get(this.getCompositeNodeKey(string));
    }

    public LeafNode getExistingLeafNode(String string) {
        return (LeafNode)this.monitorList.get(this.getLeafNodeKey(string));
    }

    public void addLeafNode(String string, LeafNode leafNode) {
        boolean bl = this.leafNodeExists(string);
        if (!bl) {
            this.monitorList.put(this.getLeafNodeKey(string), leafNode);
        }
    }

    public CompositeNode getRootNode() {
        return this;
    }

    protected String getLabelFromKey(String string) {
        int n = string.length() - 1;
        String string2 = "";
        if ('C' == string.charAt(n)) {
            string2 = displayDelimiter;
        }
        return String.valueOf(string.substring(0, n)) + string2;
    }

    public String getCompositeNodeKey(String string) {
        return String.valueOf(string) + "C";
    }

    public String getLeafNodeKey(String string) {
        return String.valueOf(string) + "L";
    }

    public String getAccruedString() {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        decimalFormat.applyPattern("#,###");
        return decimalFormat.format(this.getAccrued());
    }

    protected static String[] getHeader() {
        return leafFactory.getHeader();
    }
}

