/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.BaseStats;
import java.util.Date;

abstract class BaseStatsImp
implements BaseStats {
    static double MAX = -1.7976931348623157E308;
    static double MIN = Double.MAX_VALUE;
    double total = 0.0;
    double min = MIN;
    double max = MAX;
    double hits = 0.0;
    double sumOfSquares = 0.0;
    double lastValue = 0.0;
    long firstAccess = 0L;
    long lastAccess = 0L;
    boolean isTimeMonitor = false;

    public synchronized void addValue(double value) {
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        this.lastValue = value;
        this.hits += 1.0;
        this.total += value;
        this.sumOfSquares += value * value;
        if (!this.isTimeMonitor) {
            this.setAccessStats(System.currentTimeMillis());
        }
    }

    public synchronized void setAccessStats(long now) {
        if (this.firstAccess == 0L) {
            this.firstAccess = now;
        }
        this.lastAccess = now;
    }

    public synchronized void reset() {
        this.lastValue = 0.0;
        this.sumOfSquares = 0.0;
        this.total = 0.0;
        this.hits = 0.0;
        this.lastAccess = 0L;
        this.firstAccess = 0L;
        this.min = MIN;
        this.max = MAX;
    }

    public synchronized double getTotal() {
        return this.total;
    }

    public synchronized void setTotal(double value) {
        this.total = value;
    }

    public synchronized double getAvg() {
        if (this.hits == 0.0) {
            return 0.0;
        }
        return this.total / this.hits;
    }

    public synchronized double getMin() {
        return this.min;
    }

    public synchronized void setMin(double value) {
        this.min = value;
    }

    public synchronized double getMax() {
        return this.max;
    }

    public synchronized void setMax(double value) {
        this.max = value;
    }

    public synchronized double getHits() {
        return this.hits;
    }

    public synchronized void setHits(double value) {
        this.hits = value;
    }

    public synchronized double getStdDev() {
        double stdDeviation = 0.0;
        if (this.hits != 0.0) {
            double sumOfX = this.total;
            double n = this.hits;
            double nMinus1 = n <= 1.0 ? 1.0 : n - 1.0;
            double numerator = this.sumOfSquares - sumOfX * sumOfX / n;
            stdDeviation = Math.sqrt(numerator / nMinus1);
        }
        return stdDeviation;
    }

    public synchronized void setFirstAccess(Date date) {
        this.firstAccess = date.getTime();
    }

    public synchronized Date getFirstAccess() {
        return new Date(this.firstAccess);
    }

    public synchronized void setLastAccess(Date date) {
        this.lastAccess = date.getTime();
    }

    public synchronized Date getLastAccess() {
        return new Date(this.lastAccess);
    }

    public synchronized double getLastValue() {
        return this.lastValue;
    }

    public synchronized void setLastValue(double value) {
        this.lastValue = value;
    }
}

