/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.ActivityStats;
import com.jamonapi.BaseMon;
import com.jamonapi.Counter;
import com.jamonapi.Mon;
import com.jamonapi.MonKey;
import com.jamonapi.MonKeyImp;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorFactoryInterface;
import com.jamonapi.MonitorImp;
import com.jamonapi.NullRange;
import com.jamonapi.RangeBase;
import com.jamonapi.RangeHolder;
import com.jamonapi.RangeImp;
import com.jamonapi.TimeMon;
import com.jamonapi.TimeMon2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FactoryEnabled
implements MonitorFactoryInterface {
    private Map map = Collections.synchronizedMap(new HashMap(500));
    private Counter allActive = new Counter();
    private Counter primaryActive = new Counter();
    private RangeFactory rangeFactory = new RangeFactory();
    private static final boolean PRIMARY = true;
    private static final boolean NOT_PRIMARY = false;
    private static final boolean TIME_MONITOR = true;
    private static final boolean NOT_TIME_MONITOR = false;
    private static final String VERSION = "2.0";

    public FactoryEnabled() {
        this.setRangeDefault("ms.", RangeHolder.getMSHolder());
    }

    public Monitor add(MonKey key, double value) {
        return this.getMonitor(key).add(value);
    }

    public Monitor add(String label, String units, double value) {
        return this.getMonitor(new MonKeyImp(label, units)).add(value);
    }

    public Monitor start(MonKey key) {
        return this.getTimeMonitor(key, false).start();
    }

    public Monitor start(String label) {
        return this.getTimeMonitor(new MonKeyImp(label, "ms."), false).start();
    }

    public Monitor startPrimary(MonKey key) {
        return this.getTimeMonitor(key, true).start();
    }

    public Monitor startPrimary(String label) {
        return this.getTimeMonitor(new MonKeyImp(label, "ms."), true).start();
    }

    public Monitor start() {
        return new TimeMon2().start();
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public Monitor getMonitor(MonKey key) {
        return this.getMonitor(key, false, false);
    }

    public Monitor getMonitor(String label, String units) {
        return this.getMonitor(new MonKeyImp(label, units));
    }

    public Monitor getTimeMonitor(MonKey key) {
        return this.getTimeMonitor(key, false);
    }

    public Monitor getTimeMonitor(String label) {
        return this.getTimeMonitor(new MonKeyImp(label, "ms."), false);
    }

    public void setRangeDefault(String key, RangeHolder rangeHolder) {
        RangeBase range = new RangeBase(rangeHolder);
        this.rangeFactory.setRangeDefault(key, range);
    }

    public String[] getRangeHeader() {
        return this.rangeFactory.getHeader();
    }

    public Object[][] getRangeNames() {
        return this.rangeFactory.getData();
    }

    public void remove(MonKey key) {
        this.map.remove(key);
    }

    public void remove(String label, String units) {
        this.map.remove(new MonKeyImp(label, units));
    }

    public boolean exists(MonKey key) {
        return this.map.containsKey(key);
    }

    public boolean exists(String label, String units) {
        return this.map.containsKey(new MonKeyImp(label, units));
    }

    public int getNumRows() {
        return this.map.size();
    }

    public MonitorComposite getRootMonitor() {
        return new MonitorComposite(this.getMonitors());
    }

    public MonitorComposite getComposite(String units) {
        return new MonitorComposite(this.getMonitors(units));
    }

    public String getVersion() {
        return VERSION;
    }

    private MonitorImp getTimeMonitor(MonKey key, boolean isPrimary) {
        MonitorImp mon = this.getMonitor(key, isPrimary, true);
        if (mon.isEnabled()) {
            return new TimeMon(mon);
        }
        return mon;
    }

    private MonitorImp getMonitor(MonKey key, boolean isPrimary, boolean isTimeMonitor) {
        MonitorImp mon = this.getExistingMonitor(key);
        if (mon == null) {
            mon = this.createMon(key, isPrimary, isTimeMonitor);
            this.putMon(key, mon);
        }
        return mon;
    }

    private MonitorImp createMon(MonKey key, boolean isPrimary, boolean isTimeMonitor) {
        ActivityStats activityStats = new ActivityStats(new Counter(), this.primaryActive, this.allActive);
        RangeImp range = this.rangeFactory.getRangeDefault(key.getRangeKey(), activityStats);
        BaseMon mon = new BaseMon(new Mon(key, range, activityStats, isTimeMonitor));
        mon.setPrimary(isPrimary);
        return mon;
    }

    private MonitorImp[] getMonitors(String units) {
        MonitorImp[] monitors = this.getMonitors();
        if (monitors == null || units == null) {
            return null;
        }
        if ("AllMonitors".equalsIgnoreCase(units)) {
            return monitors;
        }
        ArrayList<MonitorImp> rows = new ArrayList<MonitorImp>(500);
        int size = monitors.length;
        for (int i = 0; i < size; ++i) {
            if (!units.equalsIgnoreCase(monitors[i].getMonKey().getRangeKey())) continue;
            rows.add(monitors[i]);
        }
        if (rows.size() == 0) {
            return null;
        }
        return rows.toArray(new MonitorImp[0]);
    }

    private Collection getAllMonitors() {
        Collection monitors = this.map.values();
        if (monitors == null || monitors.size() == 0) {
            return null;
        }
        return monitors;
    }

    private MonitorImp[] getMonitors() {
        Collection monitors = this.getAllMonitors();
        if (monitors == null || monitors.size() == 0) {
            return null;
        }
        return monitors.toArray(new MonitorImp[0]);
    }

    private MonitorImp getExistingMonitor(MonKey key) {
        return (MonitorImp)this.map.get(key);
    }

    private void putMon(MonKey key, MonitorImp mon) {
        this.map.put(key, mon);
    }

    private static class RangeFactory {
        private Map rangeFactoryMap = Collections.synchronizedMap(new HashMap(50));
        private RangeImp RANGE_NULL_OBJ = new NullRange();

        private RangeFactory() {
        }

        private void setRangeDefault(String key, RangeImp range) {
            this.rangeFactoryMap.put(key, range);
        }

        private RangeImp getRangeDefault(String key, ActivityStats activityStats) {
            RangeImp range = (RangeImp)this.rangeFactoryMap.get(key);
            if (range == null) {
                return this.RANGE_NULL_OBJ;
            }
            return range.copy(activityStats);
        }

        private String[] getHeader() {
            return new String[]{"RangeName"};
        }

        private Object[][] getData() {
            return this.getRangeNames(this.getSortedRangeNames());
        }

        private Object[][] getRangeNames(Object[] rangeNames) {
            int len = rangeNames == null ? 0 : rangeNames.length;
            Object[][] data = new Object[len + 1][];
            data[0] = new Object[]{"AllMonitors"};
            for (int i = 0; i < len; ++i) {
                data[i + 1] = new Object[]{rangeNames[i]};
            }
            return data;
        }

        private Object[] getSortedRangeNames() {
            Object[] rangeNames = this.rangeFactoryMap.keySet().toArray();
            if (rangeNames == null) {
                return null;
            }
            Arrays.sort(rangeNames);
            return rangeNames;
        }
    }
}

