/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.ActivityStats;
import com.jamonapi.Counter;
import com.jamonapi.MonKey;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorImp;
import com.jamonapi.Range;
import com.jamonapi.RangeImp;

class Mon
extends MonitorImp {
    private double maxActive = 0.0;
    private double totalActive = 0.0;
    private boolean isPrimary = false;
    private boolean initializeActivityTracking = true;
    ActivityStats activityStats;

    Mon(MonKey key, RangeImp range, ActivityStats activityStats, boolean isTimeMonitor) {
        this.key = key;
        this.range = range;
        this.activityStats = activityStats;
        this.isTimeMonitor = isTimeMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor start() {
        double active;
        Counter counter = this.activityStats.allActive;
        synchronized (counter) {
            this.activityStats.allActive.count += 1.0;
        }
        if (this.isPrimary) {
            counter = this.activityStats.primaryActive;
            synchronized (counter) {
                this.activityStats.primaryActive.count += 1.0;
            }
        }
        Object object = this.activityStats.thisActive;
        synchronized (object) {
            active = this.activityStats.thisActive.count += 1.0;
        }
        object = this;
        synchronized (object) {
            this.totalActive += active;
            if (active > this.maxActive) {
                this.maxActive = active;
            }
        }
        if (this.initializeActivityTracking) {
            this.initializeActivityTracking = false;
            this.range.setActivityTracking(true);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor stop() {
        Counter counter = this.activityStats.thisActive;
        synchronized (counter) {
            this.activityStats.thisActive.count -= 1.0;
        }
        if (this.isPrimary) {
            counter = this.activityStats.primaryActive;
            synchronized (counter) {
                this.activityStats.primaryActive.count -= 1.0;
            }
        }
        counter = this.activityStats.allActive;
        synchronized (counter) {
            this.activityStats.allActive.count -= 1.0;
        }
        return this;
    }

    public Monitor add(double value) {
        this.addValue(value);
        this.range.add(value);
        return this;
    }

    public synchronized void reset() {
        super.reset();
        this.totalActive = 0.0;
        this.maxActive = 0.0;
        this.activityStats.thisActive.setCount(0.0);
        this.range.reset();
    }

    public synchronized Range getRange() {
        return this.range;
    }

    public synchronized double getActive() {
        return this.activityStats.thisActive.count;
    }

    public synchronized void setActive(double value) {
        this.activityStats.thisActive.setCount(value);
    }

    public synchronized double getMaxActive() {
        return this.maxActive;
    }

    public synchronized void setMaxActive(double value) {
        this.maxActive = value;
    }

    public synchronized void setTotalActive(double value) {
        this.totalActive = value;
    }

    public synchronized double getAvgActive() {
        if (this.hits == 0.0) {
            return 0.0;
        }
        return this.totalActive / this.hits;
    }

    public synchronized boolean isPrimary() {
        return this.isPrimary;
    }

    public synchronized void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(400);
        b.append(this.getMonKey() + ": (Hits=");
        b.append(this.getHits());
        b.append(", Avg=");
        b.append(this.getAvg());
        b.append(", Total=");
        b.append(this.getTotal());
        b.append(", Min=");
        b.append(this.getMin());
        b.append(", Max=");
        b.append(this.getMax());
        b.append(", Active=");
        b.append(this.getActive());
        b.append(", Avg Active=");
        b.append(this.getAvgActive());
        b.append(", Max Active=");
        b.append(this.getMaxActive());
        b.append(", First Access=");
        b.append(this.getFirstAccess());
        b.append(", Last Access=");
        b.append(this.getLastAccess());
        b.append(")");
        return b.toString();
    }

    public void disable() {
    }

    public void enable() {
    }

    public boolean isEnabled() {
        return true;
    }
}

