/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.JAMonListener;
import com.jamonapi.Monitor;
import com.jamonapi.utils.DetailData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeListener
implements JAMonListener,
DetailData {
    private List listenerList = new ArrayList(4);
    private String name;
    private static final String[] HEADER = new String[]{"ListenerName"};

    public CompositeListener() {
        this("CompositeJAMonListener");
    }

    public CompositeListener(String name) {
        this.name = name;
    }

    public CompositeListener addListener(JAMonListener listener) {
        this.listenerList.add(listener);
        return this;
    }

    public JAMonListener getListener(String listenerName) {
        int rows = this.getNumListeners();
        for (int i = 0; i < rows; ++i) {
            JAMonListener listener = (JAMonListener)this.listenerList.get(i);
            String name = listener.getName();
            if (listenerName.equalsIgnoreCase(name)) {
                return listener;
            }
            if (!(listener instanceof CompositeListener) || (listener = ((CompositeListener)listener).getListener(listenerName)) == null) continue;
            return listener;
        }
        return null;
    }

    public JAMonListener getListener(int index) {
        return (JAMonListener)this.listenerList.get(index);
    }

    public CompositeListener removeListener(String listenerName) {
        int rows = this.getNumListeners();
        for (int i = 0; i < rows; ++i) {
            JAMonListener listener = (JAMonListener)this.listenerList.get(i);
            String name = listener.getName();
            if (listenerName.equalsIgnoreCase(name)) {
                this.listenerList.remove(i);
                break;
            }
            if (!(listener instanceof CompositeListener) || !((CompositeListener)listener).hasListener(listenerName)) continue;
            ((CompositeListener)listener).removeListener(listenerName);
            break;
        }
        return this;
    }

    public boolean hasListener(String listenerName) {
        int rows = this.getNumListeners();
        for (int i = 0; i < rows; ++i) {
            JAMonListener listener = (JAMonListener)this.listenerList.get(i);
            String name = listener.getName();
            if (listenerName.equalsIgnoreCase(name)) {
                return true;
            }
            if (!(listener instanceof CompositeListener)) continue;
            return ((CompositeListener)listener).hasListener(listenerName);
        }
        return false;
    }

    public int getNumListeners() {
        return this.listenerList.size();
    }

    public int getRowCount() {
        return this.getNumListeners();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void processEvent(Monitor mon) {
        for (JAMonListener listener : this.listenerList) {
            listener.processEvent(mon);
        }
    }

    public Iterator iterator() {
        return this.listenerList.iterator();
    }

    public boolean isEmpty() {
        return this.listenerList.isEmpty();
    }

    public boolean hasData() {
        return !this.isEmpty();
    }

    public Object[][] getData() {
        if (this.isEmpty()) {
            return null;
        }
        int numListeners = this.getNumListeners();
        ArrayList list = new ArrayList();
        for (int i = 0; i < numListeners; ++i) {
            this.add(list, this.getListenerData(this.getListener(i)));
        }
        return this.toArray(list);
    }

    private void add(List list, Object[][] data) {
        int dataSize = data == null ? 0 : data.length;
        for (int i = 0; i < dataSize; ++i) {
            list.add(data[i]);
        }
    }

    private Object[][] getListenerData(JAMonListener listener) {
        if (listener instanceof CompositeListener) {
            return ((CompositeListener)listener).getData();
        }
        return new Object[][]{{listener.getName()}};
    }

    private Object[][] toArray(List list) {
        if (list.size() == 0) {
            return null;
        }
        Object[][] listenerArray = new Object[list.size()][];
        list.toArray((T[])listenerArray);
        return listenerArray;
    }

    public String[] getHeader() {
        return HEADER;
    }

    public static Object[][] getData(JAMonListener listener) {
        if (listener == null) {
            return null;
        }
        return new CompositeListener().addListener(listener).getData();
    }

    public static String[] getHeader(JAMonListener listener) {
        return HEADER;
    }
}

