/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.MonKey;
import com.jamonapi.MonKeyItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MonKeyBase
implements MonKey {
    private Map keyMap;
    private String rangeKeyStr;
    private Object details;

    public MonKeyBase(LinkedHashMap keyMap) {
        this(null, keyMap);
    }

    public MonKeyBase(String rangeKeyStr, LinkedHashMap keyMap) {
        this.rangeKeyStr = rangeKeyStr;
        this.keyMap = keyMap == null ? new LinkedHashMap() : keyMap;
    }

    public Object getValue(String key) {
        if ("Label".equalsIgnoreCase(key)) {
            return this.getLabel();
        }
        if ("details".equalsIgnoreCase(key)) {
            return this.getDetails();
        }
        return this.keyMap.get(key);
    }

    public String getLabel() {
        return this.toString();
    }

    public boolean equals(Object compareKey) {
        if (this == compareKey) {
            return true;
        }
        if (compareKey instanceof MonKeyBase) {
            MonKeyBase key = (MonKeyBase)compareKey;
            return ((Object)this.keyMap).equals(key.getMonKeyMap());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.keyMap).hashCode();
    }

    public Map getMonKeyMap() {
        return this.keyMap;
    }

    public List getBasicHeader(List header) {
        header.add("Label");
        return header;
    }

    public List getDisplayHeader(List header) {
        return this.getHeader(header);
    }

    public List getHeader(List header) {
        Iterator iter = this.keyMap.keySet().iterator();
        while (iter.hasNext()) {
            header.add(iter.next());
        }
        return header;
    }

    public List getBasicRowData(List rowData) {
        Collection row = this.keyMap.values();
        int currentElement = 1;
        int lastElement = row.size();
        Iterator iter = row.iterator();
        StringBuffer buff = new StringBuffer();
        while (iter.hasNext()) {
            buff.append(iter.next());
            if (currentElement != lastElement) {
                buff.append(", ");
            }
            ++currentElement;
        }
        if (buff.length() > 0) {
            rowData.add(buff.toString());
        }
        return rowData;
    }

    public List getRowData(List rowData) {
        Collection row = this.keyMap.values();
        Iterator iter = row.iterator();
        while (iter.hasNext()) {
            rowData.add(iter.next());
        }
        return rowData;
    }

    public List getRowDisplayData(List rowData) {
        return this.getRowData(rowData);
    }

    public String toString() {
        Iterator iter = this.keyMap.entrySet().iterator();
        StringBuffer buff = new StringBuffer("JAMon Key");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            buff.append(", ").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return buff.toString();
    }

    public String getRangeKey() {
        if (this.rangeKeyStr == null) {
            StringBuffer buff = new StringBuffer();
            Iterator iter = this.keyMap.keySet().iterator();
            while (iter.hasNext()) {
                buff.append(iter.next()).append(" ");
            }
            this.rangeKeyStr = buff.toString();
        }
        return this.rangeKeyStr;
    }

    public Object getDetails() {
        if (this.details == null) {
            ArrayList list = new ArrayList();
            for (Map.Entry entry : this.keyMap.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof MonKeyItem) {
                    value = ((MonKeyItem)value).getDetails();
                }
                list.add(value);
            }
            return list;
        }
        return this.details;
    }

    public void setDetails(Object details) {
        this.details = details;
    }

    public int getSize() {
        return this.toString().length();
    }
}

