/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.JAMonDetailValue;
import com.jamonapi.JAMonListener;
import com.jamonapi.ListenerType;
import com.jamonapi.Listeners;
import com.jamonapi.MonInternals;
import com.jamonapi.MonKey;
import com.jamonapi.MonitorInt;
import com.jamonapi.Range;
import java.util.Date;

public abstract class Monitor
implements MonitorInt {
    MonInternals monData;
    private double active;
    private static final Date NULL_DATE = new Date(0L);

    Monitor(MonInternals monData) {
        this.monData = monData;
    }

    Monitor() {
        this(new MonInternals());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MonInternals getMonInternals() {
        MonInternals monInternals = this.monData;
        synchronized (monInternals) {
            return this.monData;
        }
    }

    public MonKey getMonKey() {
        return this.monData.key;
    }

    public String getLabel() {
        return (String)this.getMonKey().getValue("Label");
    }

    public String getUnits() {
        return (String)this.getMonKey().getValue("Units");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessStats(long now) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                if (this.monData.firstAccess == 0L) {
                    this.monData.firstAccess = now;
                }
                this.monData.lastAccess = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotal() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.total;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotal(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.total = value;
            }
        }
    }

    public double getAvg() {
        if (this.monData.enabled) {
            return this.avg(this.monData.total);
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMin() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.min;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMin(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.min = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMax() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.max;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMax(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.max = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getHits() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.hits;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHits(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.hits = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStdDev() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                double stdDeviation = 0.0;
                if (this.monData.hits != 0.0) {
                    double sumOfX = this.monData.total;
                    double n = this.monData.hits;
                    double nMinus1 = n <= 1.0 ? 1.0 : n - 1.0;
                    double numerator = this.monData.sumOfSquares - sumOfX * sumOfX / n;
                    stdDeviation = Math.sqrt(numerator / nMinus1);
                }
                return stdDeviation;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstAccess(Date date) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.firstAccess = date.getTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFirstAccess() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return new Date(this.monData.firstAccess);
            }
        }
        return NULL_DATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccess(Date date) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.lastAccess = date.getTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastAccess() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return new Date(this.monData.lastAccess);
            }
        }
        return NULL_DATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLastValue() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.lastValue;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastValue(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.lastValue = value;
            }
        }
    }

    public void disable() {
        this.monData.enabled = false;
    }

    public void enable() {
        this.monData.enabled = true;
    }

    public boolean isEnabled() {
        return this.monData.enabled;
    }

    Listeners getListeners() {
        return this.monData.getListeners();
    }

    public ListenerType getListenerType(String listenerType) {
        Listeners listeners = this.getListeners();
        if (listeners == null) {
            return null;
        }
        return listeners.getListenerType(listenerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String listenerTypeName) {
        MonInternals monInternals = this.monData;
        synchronized (monInternals) {
            if (!this.monData.hasListeners()) {
                return false;
            }
            ListenerType type = this.getListenerType(listenerTypeName);
            if (type == null) {
                return false;
            }
            return type.hasListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String listenerTypeName, JAMonListener listener) {
        MonInternals monInternals = this.monData;
        synchronized (monInternals) {
            Listeners listeners = this.monData.hasListeners() ? this.monData.getListeners() : this.monData.createListeners();
            listeners.getListenerType(listenerTypeName).addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListener(String listenerTypeName, String listenerName) {
        MonInternals monInternals = this.monData;
        synchronized (monInternals) {
            if (!this.monData.hasListeners()) {
                return false;
            }
            ListenerType type = this.getListenerType(listenerTypeName);
            if (type == null) {
                return false;
            }
            return type.hasListener(listenerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String listenerTypeName, String listenerName) {
        MonInternals monInternals = this.monData;
        synchronized (monInternals) {
            if (!this.monData.hasListeners()) {
                return;
            }
            ListenerType type = this.getListenerType(listenerTypeName);
            if (type != null) {
                type.removeListener(listenerName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor start() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.incrementActivity();
                this.active = this.monData.incrementThisActive();
                if (!this.monData.startHasBeenCalled) {
                    this.monData.startHasBeenCalled = true;
                    if (this.monData.trackActivity && this.monData.range != null) {
                        this.monData.range.setActivityTracking(true);
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor skip() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.skip();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor stop() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                if (this.active >= this.monData.maxActive) {
                    this.monData.maxActive = this.active;
                    if (this.monData.hasListener(2) && this.active > 1.0) {
                        this.monData.getListener(2).processEvent(this);
                    }
                }
                this.monData.stop(this.active);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor add(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                if (!this.monData.isTimeMonitor) {
                    this.setAccessStats(System.currentTimeMillis());
                }
                this.monData.lastValue = value;
                this.monData.hits += 1.0;
                this.monData.total += value;
                this.monData.sumOfSquares += value * value;
                this.monData.updateActivity();
                if (value <= this.monData.min) {
                    this.monData.min = value;
                    if (this.monData.hasListener(3)) {
                        this.monData.getListener(3).processEvent(this);
                    }
                }
                if (value >= this.monData.max) {
                    this.monData.max = value;
                    if (this.monData.hasListener(1)) {
                        this.monData.getListener(1).processEvent(this);
                    }
                }
                if (this.monData.hasListener(0)) {
                    this.monData.getListener(0).processEvent(this);
                }
                if (this.monData.range != null) {
                    this.monData.range.processEvent(this);
                }
            }
        }
        return this;
    }

    public Range getRange() {
        return this.monData.range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getActive() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.getThisActiveCount();
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.setThisActiveCount(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMaxActive() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.maxActive;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActive(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.maxActive = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalActive(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.totalActive = value;
            }
        }
    }

    public boolean isPrimary() {
        return this.monData.isPrimary;
    }

    public void setPrimary(boolean isPrimary) {
        if (this.monData.enabled) {
            this.monData.isPrimary = isPrimary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        MonInternals monInternals = this.monData;
        synchronized (monInternals) {
            return this.monData.hasListeners();
        }
    }

    public Object getValue(String key) {
        if ("avg".equalsIgnoreCase(key)) {
            return new Double(this.getAvg());
        }
        if ("hits".equalsIgnoreCase(key)) {
            return new Double(this.getHits());
        }
        if ("min".equalsIgnoreCase(key)) {
            return new Double(this.getMin());
        }
        if ("max".equalsIgnoreCase(key)) {
            return new Double(this.getMax());
        }
        if ("total".equalsIgnoreCase(key)) {
            return new Double(this.getTotal());
        }
        if ("active".equalsIgnoreCase(key)) {
            return new Double(this.getActive());
        }
        if ("stddev".equalsIgnoreCase(key)) {
            return new Double(this.getStdDev());
        }
        if ("value".equalsIgnoreCase(key) || "lastvalue".equalsIgnoreCase(key)) {
            return new Double(this.getLastValue());
        }
        if ("lastaccess".equalsIgnoreCase(key)) {
            return this.getLastAccess();
        }
        if ("firstaccess".equalsIgnoreCase(key)) {
            return this.getFirstAccess();
        }
        if ("avgactive".equalsIgnoreCase(key)) {
            return new Double(this.getAvgActive());
        }
        if ("maxactive".equalsIgnoreCase(key)) {
            return new Double(this.getMaxActive());
        }
        if ("Label".equalsIgnoreCase(key)) {
            return this.getLabel();
        }
        if ("Units".equalsIgnoreCase(key)) {
            return this.getUnits();
        }
        return null;
    }

    public String toString() {
        if (this.monData.enabled) {
            StringBuffer b = new StringBuffer(400);
            b.append(this.getMonKey() + ": (");
            b.append("LastValue=");
            b.append(this.getLastValue());
            b.append(", Hits=");
            b.append(this.getHits());
            b.append(", Avg=");
            b.append(this.getAvg());
            b.append(", Total=");
            b.append(this.getTotal());
            b.append(", Min=");
            b.append(this.getMin());
            b.append(", Max=");
            b.append(this.getMax());
            b.append(", Active=");
            b.append(this.getActive());
            b.append(", Avg Active=");
            b.append(this.getAvgActive());
            b.append(", Max Active=");
            b.append(this.getMaxActive());
            b.append(", First Access=");
            b.append(this.getFirstAccess());
            b.append(", Last Access=");
            b.append(this.getLastAccess());
            b.append(")");
            return b.toString();
        }
        return "";
    }

    public void setActivityTracking(boolean trackActivity) {
        this.monData.trackActivity = trackActivity;
        if (this.monData.range != null) {
            this.monData.range.setActivityTracking(trackActivity);
        }
    }

    public boolean isActivityTracking() {
        return this.monData.trackActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double avg(double value) {
        MonInternals monInternals = this.monData;
        synchronized (monInternals) {
            if (this.monData.hits == 0.0) {
                return 0.0;
            }
            return value / this.monData.hits;
        }
    }

    public double getAvgActive() {
        if (this.monData.enabled) {
            if (this.monData.trackActivity) {
                return this.avg(this.monData.thisActiveTotal);
            }
            return this.avg(this.monData.totalActive);
        }
        return 0.0;
    }

    public double getAvgGlobalActive() {
        return this.avgNoNeg(this.monData.allActiveTotal);
    }

    public double getAvgPrimaryActive() {
        return this.avgNoNeg(this.monData.primaryActiveTotal);
    }

    private double avgNoNeg(double value) {
        double v = this.avg(value);
        return v <= 0.0 ? 0.0 : v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAMonDetailValue getJAMonDetailRow() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return new JAMonDetailValue(this.getMonKey(), this.monData.lastValue, this.monData.getThisActiveCount(), this.monData.lastAccess);
            }
        }
        return JAMonDetailValue.NULL_VALUE;
    }
}

